#include "converse.h"

#define NITER 100000

CpvDeclare(int, exitHandlerIdx);

void ExitHandler(void *msg)
{
  CsdExitScheduler();
}

void Yielder(void *arg)
{
  double starttime = CmiTimer();
  int i;
  for(i=0;i<NITER;i++) {
    // CmiPrintf("yielding %d\n", i);
    CthYield();
  }
  double endtime = CmiTimer();
  CmiPrintf("Context Switching Overhead : %lf seconds\n", 
            (endtime-starttime)/NITER);
  char endmsg[CmiMsgHeaderSizeBytes];
  CmiSetHandler(endmsg, CpvAccess(exitHandlerIdx));
  CmiSyncSend(CmiMyPe(), CmiMsgHeaderSizeBytes, endmsg);
}

void test_init(int argc, char **argv)
{
  CpvInitialize(int, exitHandlerIdx);
  CpvAccess(exitHandlerIdx) = CmiRegisterHandler((CmiHandler)ExitHandler);
  CthThread yielder = CthCreate((CthVoidFn)Yielder, 0, 0);
  CthAwaken(yielder);
}

int main(int argc, char **argv)
{
  ConverseInit(argc, argv, test_init, 0, 0);
}
