#ifndef _DECL_CkArray_H_
#define _DECL_CkArray_H_
#include "charm++.h"
/* DECLS: readonly CkGroupID _RRMapID;
 */
extern CkGroupID _RRMapID;
/* DECLS: message ArrayCreateMessage;
 */
class ArrayCreateMessage;
class CMessage_ArrayCreateMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayMessage;
 */
class ArrayMessage;
class CMessage_ArrayMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayElementAckMessage;
 */
class ArrayElementAckMessage;
class CMessage_ArrayElementAckMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayElementUpdateMessage;
 */
class ArrayElementUpdateMessage;
class CMessage_ArrayElementUpdateMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayMigrateMessage;
 */
class ArrayMigrateMessage;
class CMessage_ArrayMigrateMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    void *operator new(size_t s, int *sz, int p);
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayReductionMessage;
 */
class ArrayReductionMessage;
class CMessage_ArrayReductionMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    void *operator new(size_t s, int *sz, int p);
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: group Array1D{
Array1D(ArrayCreateMessage*);
void RecvForElement(ArrayMessage*);
void RecvMigratedElement(ArrayMigrateMessage*);
void AckMigratedElement(ArrayElementAckMessage*);
void UpdateLocation(ArrayElementUpdateMessage*);
void RecvReductionMessage(ArrayReductionMessage*);
void DummyAtSync(void);
};
 */
class Array1D;
class CProxy_Array1D:  public virtual _CK_GID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size) {
      __idx = CkRegisterChare(s, size);
    // REG: Array1D(ArrayCreateMessage*);
      __idx_Array1D_ArrayCreateMessage = CkRegisterEp("Array1D", (CkCallFnPtr)_call_Array1D_ArrayCreateMessage, CMessage_ArrayCreateMessage::__idx, __idx);

    // REG: void RecvForElement(ArrayMessage*);
      __idx_RecvForElement_ArrayMessage = CkRegisterEp("RecvForElement", (CkCallFnPtr)_call_RecvForElement_ArrayMessage, CMessage_ArrayMessage::__idx, __idx);

    // REG: void RecvMigratedElement(ArrayMigrateMessage*);
      __idx_RecvMigratedElement_ArrayMigrateMessage = CkRegisterEp("RecvMigratedElement", (CkCallFnPtr)_call_RecvMigratedElement_ArrayMigrateMessage, CMessage_ArrayMigrateMessage::__idx, __idx);

    // REG: void AckMigratedElement(ArrayElementAckMessage*);
      __idx_AckMigratedElement_ArrayElementAckMessage = CkRegisterEp("AckMigratedElement", (CkCallFnPtr)_call_AckMigratedElement_ArrayElementAckMessage, CMessage_ArrayElementAckMessage::__idx, __idx);

    // REG: void UpdateLocation(ArrayElementUpdateMessage*);
      __idx_UpdateLocation_ArrayElementUpdateMessage = CkRegisterEp("UpdateLocation", (CkCallFnPtr)_call_UpdateLocation_ArrayElementUpdateMessage, CMessage_ArrayElementUpdateMessage::__idx, __idx);

    // REG: void RecvReductionMessage(ArrayReductionMessage*);
      __idx_RecvReductionMessage_ArrayReductionMessage = CkRegisterEp("RecvReductionMessage", (CkCallFnPtr)_call_RecvReductionMessage_ArrayReductionMessage, CMessage_ArrayReductionMessage::__idx, __idx);

    // REG: void DummyAtSync(void);
      __idx_DummyAtSync_void = CkRegisterEp("DummyAtSync", (CkCallFnPtr)_call_DummyAtSync_void, 0, __idx);
    }
    CProxy_Array1D(CkGroupID _gid) { _ck_gid = _gid; _setChare(0); }
    CProxy_Array1D(CkChareID __cid) { ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    Array1D* ckLocalBranch(void) {
      return (Array1D *) CkLocalBranch(_ck_gid);
    }
    static Array1D* ckLocalBranch(CkGroupID gID) {
      return (Array1D *) CkLocalBranch(gID);
    }
/* DECLS: Array1D(ArrayCreateMessage*);
 */
    static int __idx_Array1D_ArrayCreateMessage;
    static CkGroupID ckNew(ArrayCreateMessage*msg);
    static CkGroupID ckNewSync(ArrayCreateMessage*msg);
    CProxy_Array1D(ArrayCreateMessage*msg, int retEP, CkChareID *cid);
    CProxy_Array1D(ArrayCreateMessage*msg);
    static int ckIdx_Array1D(ArrayCreateMessage*msg) { return __idx_Array1D_ArrayCreateMessage; }
    static void _call_Array1D_ArrayCreateMessage(void* msg, Array1D* obj);

/* DECLS: void RecvForElement(ArrayMessage*);
 */
    static int __idx_RecvForElement_ArrayMessage;
    void RecvForElement(ArrayMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvForElement_ArrayMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvForElement_ArrayMessage, msg, _ck_gid);
    }
    void RecvForElement(ArrayMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvForElement_ArrayMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_RecvForElement(ArrayMessage*) { return __idx_RecvForElement_ArrayMessage; }
    static void _call_RecvForElement_ArrayMessage(void* msg, Array1D* obj);

/* DECLS: void RecvMigratedElement(ArrayMigrateMessage*);
 */
    static int __idx_RecvMigratedElement_ArrayMigrateMessage;
    void RecvMigratedElement(ArrayMigrateMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvMigratedElement_ArrayMigrateMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvMigratedElement_ArrayMigrateMessage, msg, _ck_gid);
    }
    void RecvMigratedElement(ArrayMigrateMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvMigratedElement_ArrayMigrateMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_RecvMigratedElement(ArrayMigrateMessage*) { return __idx_RecvMigratedElement_ArrayMigrateMessage; }
    static void _call_RecvMigratedElement_ArrayMigrateMessage(void* msg, Array1D* obj);

/* DECLS: void AckMigratedElement(ArrayElementAckMessage*);
 */
    static int __idx_AckMigratedElement_ArrayElementAckMessage;
    void AckMigratedElement(ArrayElementAckMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_AckMigratedElement_ArrayElementAckMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_AckMigratedElement_ArrayElementAckMessage, msg, _ck_gid);
    }
    void AckMigratedElement(ArrayElementAckMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_AckMigratedElement_ArrayElementAckMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_AckMigratedElement(ArrayElementAckMessage*) { return __idx_AckMigratedElement_ArrayElementAckMessage; }
    static void _call_AckMigratedElement_ArrayElementAckMessage(void* msg, Array1D* obj);

/* DECLS: void UpdateLocation(ArrayElementUpdateMessage*);
 */
    static int __idx_UpdateLocation_ArrayElementUpdateMessage;
    void UpdateLocation(ArrayElementUpdateMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_UpdateLocation_ArrayElementUpdateMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_UpdateLocation_ArrayElementUpdateMessage, msg, _ck_gid);
    }
    void UpdateLocation(ArrayElementUpdateMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_UpdateLocation_ArrayElementUpdateMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_UpdateLocation(ArrayElementUpdateMessage*) { return __idx_UpdateLocation_ArrayElementUpdateMessage; }
    static void _call_UpdateLocation_ArrayElementUpdateMessage(void* msg, Array1D* obj);

/* DECLS: void RecvReductionMessage(ArrayReductionMessage*);
 */
    static int __idx_RecvReductionMessage_ArrayReductionMessage;
    void RecvReductionMessage(ArrayReductionMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_RecvReductionMessage_ArrayReductionMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_RecvReductionMessage_ArrayReductionMessage, msg, _ck_gid);
    }
    void RecvReductionMessage(ArrayReductionMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_RecvReductionMessage_ArrayReductionMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_RecvReductionMessage(ArrayReductionMessage*) { return __idx_RecvReductionMessage_ArrayReductionMessage; }
    static void _call_RecvReductionMessage_ArrayReductionMessage(void* msg, Array1D* obj);

/* DECLS: void DummyAtSync(void);
 */
    static int __idx_DummyAtSync_void;
    void DummyAtSync(void){
      void *msg = CkAllocSysMsg();
      if(_isChare())
        CkSendMsg(__idx_DummyAtSync_void, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_DummyAtSync_void, msg, _ck_gid);
    }
    void DummyAtSync(int onPE) {
      void *msg = CkAllocSysMsg();
      CkSendMsgBranch(__idx_DummyAtSync_void, msg, onPE, _ck_gid);
    }
    static int ckIdx_DummyAtSync(void) { return __idx_DummyAtSync_void; }
    static void _call_DummyAtSync_void(void* msg, Array1D* obj);
};

/* DECLS: message ArrayElementCreateMessage;
 */
class ArrayElementCreateMessage;
class CMessage_ArrayElementCreateMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayElementMigrateMessage;
 */
class ArrayElementMigrateMessage;
class CMessage_ArrayElementMigrateMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: message ArrayElementExitMessage;
 */
class ArrayElementExitMessage;
class CMessage_ArrayElementExitMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: array ArrayElement{
ArrayElement();
void exit(ArrayElementExitMessage*);
};
 */
class ArrayElement;
class CProxy_ArrayElement: public virtual _CK_AID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size) {
      __idx = CkRegisterChare(s, size);
    // REG: ArrayElement();
      __idx_ArrayElement_ArrayElementCreateMessage = CkRegisterEp("ArrayElement", (CkCallFnPtr)_call_ArrayElement_ArrayElementCreateMessage,CMessage_ArrayElementCreateMessage::__idx, __idx);
      __idx_ArrayElement_ArrayElementMigrateMessage = CkRegisterEp("ArrayElement", (CkCallFnPtr)_call_ArrayElement_ArrayElementMigrateMessage,CMessage_ArrayElementMigrateMessage::__idx, __idx);

    // REG: void exit(ArrayElementExitMessage*);
      __idx_exit_ArrayElementExitMessage = CkRegisterEp("exit", (CkCallFnPtr)_call_exit_ArrayElementExitMessage, CMessage_ArrayElementExitMessage::__idx, __idx);
    }
    CProxy_ArrayElement(CkArrayID _aid) { ckSetArrayId(_aid);}
    CProxy_ArrayElement(const CProxy_ArrayElement &_arr) { *this = _arr;}
    CProxy_ArrayElement(CkChareID __cid) { ckSetChareId(__cid);}
    CkArrayID ckGetArrayId(void) { return CkArrayID(_ck_aid, _elem); }
    void ckSetArrayId(CkArrayID _aid) { 
      _setChare(0); _setAid(_aid._ck_aid); _elem = _aid._elem; 
    }
    CkChareID ckGetChareId(void) { return _cid; }
    void ckSetChareId(CkChareID __cid) { 
      _CHECK_CID(__cid, __idx); _setChare(1); _setCid(__cid); 
    }
    CProxy_ArrayElement operator [] (int idx) {
      return CProxy_ArrayElement(CkArrayID(_ck_aid, idx));
    }
/* DECLS: ArrayElement();
 */
    static int __idx_ArrayElement_ArrayElementCreateMessage;
    static int __idx_ArrayElement_ArrayElementMigrateMessage;
    static CkGroupID ckNew_GID(int numElements, CkGroupID mapID)
    {
        return Array1D::CreateArray(numElements,mapID,__idx,
            ConstructorIndex(ArrayElement, ArrayElementCreateMessage), 
            ConstructorIndex(ArrayElement, ArrayElementMigrateMessage));
    }
    static CkArrayID ckNew(int numElements, CkGroupID mapID=_RRMapID)
        {return CkArrayID(ckNew_GID(numElements,mapID),-1);}
    CProxy_ArrayElement(int numElements,CkGroupID mapID=_RRMapID)
    {
        _setAid(ckNew_GID(numElements,mapID)); 
        _setChare(0); _elem=-1;
    }
    static int ckIdx_ArrayElement(ArrayElementCreateMessage*)
        { return __idx_ArrayElement_ArrayElementCreateMessage; }
    static int ckIdx_ArrayElement(ArrayElementMigrateMessage*)
        { return __idx_ArrayElement_ArrayElementMigrateMessage; }
    static void _call_ArrayElement_ArrayElementCreateMessage(void* msg, ArrayElement* obj);
    static void _call_ArrayElement_ArrayElementMigrateMessage(void* msg, ArrayElement* obj);

/* DECLS: void exit(ArrayElementExitMessage*);
 */
    static int __idx_exit_ArrayElementExitMessage;
    void exit(ArrayElementExitMessage*msg, int index=-2) {
      if(index==-2) index=_elem;
      if(_isChare())
        CkSendMsg(__idx_exit_ArrayElementExitMessage, msg, &_cid);
      else if(_elem==(-1)) 
        _array->broadcast((ArrayMessage*) msg, __idx_exit_ArrayElementExitMessage);
      else _array->send((ArrayMessage*) msg, index, __idx_exit_ArrayElementExitMessage);
    }
    static int ckIdx_exit(ArrayElementExitMessage*msg) { return __idx_exit_ArrayElementExitMessage; }
    static void _call_exit_ArrayElementExitMessage(void* msg, ArrayElement* obj);
};

/* DECLS: message ArrayMapRegisterMessage;
 */
class ArrayMapRegisterMessage;
class CMessage_ArrayMapRegisterMessage{
  public:
    static int __idx;
    void*operator new(size_t s){return CkAllocMsg(__idx,s,0);}
    void operator delete(void *p){CkFreeMsg(p);}
    void*operator new(size_t,void*p){return p;}
    void*operator new(size_t s, int p){return CkAllocMsg(__idx,s,p);}
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, 0, size);
    }
};

/* DECLS: group ArrayMap{
void registerArray(ArrayMapRegisterMessage*);
};
 */
class ArrayMap;
class CProxy_ArrayMap:  public virtual _CK_GID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size) {
      __idx = CkRegisterChare(s, size);
    // REG: void registerArray(ArrayMapRegisterMessage*);
      __idx_registerArray_ArrayMapRegisterMessage = CkRegisterEp("registerArray", (CkCallFnPtr)_call_registerArray_ArrayMapRegisterMessage, CMessage_ArrayMapRegisterMessage::__idx, __idx);
    }
    CProxy_ArrayMap(void) {};
    CProxy_ArrayMap(CkGroupID _gid) { _ck_gid = _gid; _setChare(0); }
    CProxy_ArrayMap(CkChareID __cid) { ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    ArrayMap* ckLocalBranch(void) {
      return (ArrayMap *) CkLocalBranch(_ck_gid);
    }
    static ArrayMap* ckLocalBranch(CkGroupID gID) {
      return (ArrayMap *) CkLocalBranch(gID);
    }
/* DECLS: void registerArray(ArrayMapRegisterMessage*);
 */
    static int __idx_registerArray_ArrayMapRegisterMessage;
    virtual void registerArray(ArrayMapRegisterMessage*msg){
      if(_isChare())
        CkSendMsg(__idx_registerArray_ArrayMapRegisterMessage, msg, &_ck_cid);
      else
        CkBroadcastMsgBranch(__idx_registerArray_ArrayMapRegisterMessage, msg, _ck_gid);
    }
    virtual void registerArray(ArrayMapRegisterMessage*msg, int onPE) {
      CkSendMsgBranch(__idx_registerArray_ArrayMapRegisterMessage, msg, onPE, _ck_gid);
    }
    static int ckIdx_registerArray(ArrayMapRegisterMessage*) { return __idx_registerArray_ArrayMapRegisterMessage; }
    static void _call_registerArray_ArrayMapRegisterMessage(void* msg, ArrayMap* obj);
};

/* DECLS: group RRMap: ArrayMap{
RRMap(void);
};
 */
class RRMap;
class CProxy_RRMap:  public virtual _CK_GID, public CProxy_ArrayMap{
  public:
    static int __idx;
    static void __register(const char *s, size_t size) {
      __idx = CkRegisterChare(s, size);
  _REGISTER_BASE(__idx, CProxy_ArrayMap::__idx);
    // REG: RRMap(void);
      __idx_RRMap_void = CkRegisterEp("RRMap", (CkCallFnPtr)_call_RRMap_void, 0, __idx);
    }
    CProxy_RRMap(CkGroupID _gid) :CProxy_ArrayMap(_gid){ _ck_gid = _gid; _setChare(0); }
    CProxy_RRMap(CkChareID __cid) :CProxy_ArrayMap(__cid){ ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid){_CHECK_CID(__cid,__idx);_ck_cid=__cid;_setChare(1);}
    CkGroupID ckGetGroupId(void) { return _ck_gid; }
    void ckSetGroupId(CkGroupID _gid){_ck_gid=_gid;_setChare(0);}
    RRMap* ckLocalBranch(void) {
      return (RRMap *) CkLocalBranch(_ck_gid);
    }
    static RRMap* ckLocalBranch(CkGroupID gID) {
      return (RRMap *) CkLocalBranch(gID);
    }
/* DECLS: RRMap(void);
 */
    static int __idx_RRMap_void;
    static CkGroupID ckNew(void);
    static CkGroupID ckNewSync(void);
    CProxy_RRMap(int retEP, CkChareID *cid);
    CProxy_RRMap(void);
    static int ckIdx_RRMap(void) { return __idx_RRMap_void; }
    static void _call_RRMap_void(void* msg, RRMap* obj);
};

/* DECLS: mainchare ArrayInit{
ArrayInit();
};
 */
class ArrayInit;
class CProxy_ArrayInit: public virtual _CK_CID{
  public:
    static int __idx;
    static void __register(const char *s, size_t size) {
      __idx = CkRegisterChare(s, size);
    // REG: ArrayInit();
      __idx_ArrayInit = CkRegisterEp("ArrayInit", (CkCallFnPtr)_call_ArrayInit, 0, __idx);
      CkRegisterMainChare(__idx, __idx_ArrayInit);
    }
    CProxy_ArrayInit(CkChareID __cid) { ckSetChareId(__cid); }
    CkChareID ckGetChareId(void) { return _ck_cid; }
    void ckSetChareId(CkChareID __cid) {_CHECK_CID(__cid,__idx);_ck_cid=__cid;}
/* DECLS: ArrayInit();
 */
    static int __idx_ArrayInit;
    static void ckNew(int onPE=CK_PE_ANY);
    static void ckNew(CkChareID* pcid, int onPE=CK_PE_ANY);
    CProxy_ArrayInit(int onPE=CK_PE_ANY);
    static int ckIdx_ArrayInit() { return __idx_ArrayInit; }
    static void _call_ArrayInit(CkArgMsg* msg, ArrayInit* obj);
};

extern void _registerCkArray(void);
#endif
