#include "migration.h"

void migration_init(void)
{
  const int numElements = 10;
  if(CkNumPes() < 2) {
    CkError("migration: requires at least 2 processors.\n");
    finishTest();
  } else
    CProxy_mig_Element::ckNew(numElements);
}

void migration_moduleinit(void){}

mig_Element::mig_Element(ArrayElementCreateMessage *msg) : ArrayElement(msg)
{
  delete msg;
  origPE = CkMyPe();
  sum = CkMyPe() + 1;
  index = thisIndex;
  numDone = 0;
  int nextPE = (CkMyPe()+1)%CkNumPes();
  CProxy_mig_Element self(thisAID);
  self[thisIndex].migrate_next(new mig_msg(nextPE));
  finishConstruction();
}

mig_Element::mig_Element(ArrayElementMigrateMessage *msg):ArrayElement(msg)
{
  mig_Element *tmp =  (mig_Element*) msg->packData;
  origPE = tmp->origPE;
  sum = tmp->sum;
  numDone = tmp->numDone;
  index = tmp->index;
  if (thisIndex != index) 
    CkError("migration: chare-data corrupted!\n");
  CProxy_mig_Element self(thisAID);
  if(CkMyPe() == origPE) {
    if(sum != ((CkNumPes()+1)*CkNumPes())/2)
      CkError("migrate: Element did not migrate to all the processors!\n");
    self[0].done();
  } else {
    sum += CkMyPe() + 1;
    int nextPE = (CkMyPe()+1)%CkNumPes();
    self[thisIndex].migrate_next(new mig_msg(nextPE));
  }
  delete msg;
  finishMigration();
}

void
mig_Element::migrate_next(mig_msg *msg)
{
  int nextPE = msg->nextPE;
  delete msg;
  migrate(nextPE);
}

void
mig_Element::done(void)
{
  numDone++;
  if(numDone==numElements)
    finishTest();
}

int 
mig_Element::packsize(void)
{
  return sizeof(mig_Element);
};

void mig_Element::pack(void *buf)
{
  mig_Element *hbuf = (mig_Element *)buf;
  hbuf->origPE = origPE;
  hbuf->sum = sum;
  hbuf->numDone = numDone;
  hbuf->index = index;
};

#include "migration.def.h"
