/*
A small library of oft-used reductions for use with the 
Array Reduction Manager.

Parallel Programming Lab, University of Illinois at Urbana-Champaign
Orion Sky Lawlor, 11/13/1999, olawlor@acm.org

*/

//Compute the sum the integers passed by each element.
ArrayReductionMessage *reduction_sum_int(int nMsg,ArrayReductionMessage **msg);

//Compute the logical AND of the integers passed by each element.
// The resulting integer will be zero if any source integer is zero.
ArrayReductionMessage *reduction_and(int nMsg,ArrayReductionMessage **msg);

//Compute the logical OR of the integers passed by each element.
// The resulting integer will be 1 if any source integer is nonzero.
ArrayReductionMessage *reduction_or(int nMsg,ArrayReductionMessage **msg);

//Compute the largest integer passed by any element.
ArrayReductionMessage *reduction_max_int(int nMsg,ArrayReductionMessage **msg);

//Compute the smallest integer passed by any element.
ArrayReductionMessage *reduction_min_int(int nMsg,ArrayReductionMessage **msg);


//Compute the sum the doubles passed by each element.
ArrayReductionMessage *reduction_sum_double(int nMsg,ArrayReductionMessage **msg);

//Compute the largest double passed by any element.
ArrayReductionMessage *reduction_max_double(int nMsg,ArrayReductionMessage **msg);

//Compute the smallest double passed by any element.
ArrayReductionMessage *reduction_min_double(int nMsg,ArrayReductionMessage **msg);


//This structure contains the contribution of one array element.
typedef struct {
	int sourceElement;//The element number from which this contribution came
	int dataSize;//The length of the data array below
	char data[1];//The (dataSize-long) array of data
} reduction_set_element;

//Combine the data passed by each element into an list of reduction_set_elements.
// Each element may contribute arbitrary data (with arbitrary length).
ArrayReductionMessage *reduction_set(int nMsg,ArrayReductionMessage **msg);

//Utility routine: get the next reduction_set_element in the list
// if there is one, or return NULL if there are none.
//To get all the elements, just keep feeding this procedure's output back to
// its input until it returns NULL.
reduction_set_element *next_reduction_set_element(reduction_set_element *cur);

