#include "pgm.h"

int migHandle;
static Array1D *arrayMgr;
CkChareID mainhandle;

UserArray::UserArray(ArrayElementCreateMessage *msg) : TempoArray(msg)
{
  arrayMgr = thisArray;
  delete msg;
}

UserArray::UserArray(ArrayElementMigrateMessage *msg) : TempoArray(msg)
{
  arrayMgr = thisArray;
  thread_id = CthUnpackThread(msg->packData);
  CthAwaken(thread_id);
  delete msg;
  finishMigration();
}

static void migrate_now(UserArray *element)
{
  CProxy_migrator pmg(migHandle);
  pmg.migrateElement(new MigrateInfo(element, (CkMyPe()+1)%2), CkMyPe());
  // CkPrintf("migrating from %d to %d\n", CkMyPe(), (CkMyPe()+1)%2);
  CthSuspend();
}

void 
UserArray::startMigrate(void)
{
  int i, index;
  index = thisIndex;
  UserArray *element = (UserArray *) arrayMgr->getElement(index);
  for(i=0;i<NITER;i++) {
    migrate_now(element);
    element = (UserArray *) arrayMgr->getElement(index);
  }
  CProxy_main pmain(mainhandle);
  pmain.Finish();
}

main::main(CkArgMsg *)
{
  CProxy_migrator::ckNew();
  CProxy_UserArray  pua(1);
  pua[0].startMigrate();
  starttime = CkTimer();
  mainhandle = thishandle;
}

void 
main::Finish(void)
{
  endtime = CkTimer();
  CkPrintf("Time per migration = %lf seconds\n", (endtime-starttime)/NITER);
  CkExit();
}

#include "pgm.def.h"
