#include "charm++.h"
#include "pgm.decl.h"
#include "tempo.h"

#define NITER 50000

extern CkChareID mainhandle;

class UserArray : public TempoArray
{
  public:
    UserArray(ArrayElementCreateMessage *msg);
    UserArray(ArrayElementMigrateMessage *msg);
    void startMigrate(void);
    int packsize(void) { return CthPackBufSize(thread_id); }
    void pack(void *buf) { CthPackThread(thread_id, buf); }
};

extern int migHandle;

class MigrateInfo : public CMessage_MigrateInfo {
  public:
    ArrayElement *elem;
    int where;
    MigrateInfo(ArrayElement *e, int w) : elem(e), where(w) {}
};

class migrator : public Group {
  public:
    migrator(void) { migHandle = thisgroup; }
    void migrateElement(MigrateInfo *msg) {
      msg->elem->migrate(msg->where);
      delete msg;
    }
};

class main : public Chare
{
  double starttime, endtime;
  public :
    main(CkArgMsg *);
    void Finish(void);
};
