
/* this is the client program that uses master-slave library. Note
that it is meant to run on one processor where its main program
lives. It just gets the work done by other processors, including
itself, when needed and continues its sequential execution
afterward. It may invoke the master-slave (or worker-manager)
functionality repeatedly, stopping each time after receiving all
responses from the workers.  */

#include "cms.h"
#define MAX 10
typedef struct {
  float a;
} Task;

typedef struct {
  float result;
} Response;

Task t;

int worker(Task * t, Response ** r) {
  /* do work and generate a single response */
  int i;
  Task * t1;
  int k;

  CmiPrintf("%d: in worker %f \n", CmiMyPe(), t->a);
  *r = (Response *) malloc(sizeof(Response));
  (*r)->result = t->a * t->a;
  return sizeof(r);
}

int consumer(Response * r, int refnum) 
{
  CmiPrintf("consumer: response with refnum = %d is %f\n", refnum, r->result);
}

main(int argc,char *argv[])
{
  int i, j, k, ref;
  CmsInit(worker, 20); /* 2nd parameter is the max number of tasks fired before "awaitResponses" */
  if (CmiMyPe() == 0) { /* I am the manager */
    CmiPrintf("manager inited\n");
    for (i=0; i< 3; i++) { /* number of iterations or phases */
      /* prepare the next generation of problems to solve */

      /* then, fire the next batch of tasks for the worker */
      for (j=0; j<5; j++) {
	t.a = 10*i + j;
	ref = j; /* a reference number to associate with the task, */
	/* so that the reponse for this task can be identified. */
	CmsFireTask(ref, t, sizeof(t));
      }
      /* Now wait for the responses */
      CmsAwaitResponses(); /* allows the system to use processor 0 as a worker.*/
      /* Now extract the resoneses from the system */
      for (j = 0; j<5; j++) {
	Response * r = (Response *) CmsGetResponse(j);
	CmiPrintf("Response %d is: %f \n", j, r->result);
      }
      /* End of one mast-slave phase */
      CmiPrintf("End of phase %d\n", i);
    }
    /*    CmsExit();*/
  }

  CmiPrintf("Now the consumerFunction mode\n");

  if (CmiMyPe() == 0) { /* I am the manager */
    for (i=0; i<3; i++) {
      t.a = 5+i;
      CmsFireTask(i, t, sizeof(t)); }
    CmsProcessResponses(consumer);
    /* Also allows proc. 0 to be used as a worker. In addition,
       responses will be processed on processor 0 via the "consumer" function
       as soon as they are available */
  }
  CmsExit();

  
}
