// This file needs to be written in Fortran 

#include "util.h"

CellData * initializeCell(int cellPosition, int width, int  height)
{
  int i,j;
  CellData * d = new CellData;
  d->height = height;
  d->width = width + 2; // for ghost cells.
  for (i=0; i<width; i++)
    for (j=0; j<height; j++)
      { d->temperature[i][j] = 100*i+j; 
      }
  return d;
}

void copyBorder(CellData *data, double *a, int fromLeft)
{
  int i;
  if (fromLeft = 1) {
    for (i=0; i< data->height; i++)
      data->temperature[0][i] = a[i];
  } else {
    for (i=0; i< data->height; i++)
      data->temperature[data->width+1][i] = a[i];
  }
}

void nextIteration(CellData *data)
{ // all the remote data is here. Main computation now.
  int i,j;
  for (i=1; i<11; i++)
    for (j=0; j<100; j++)
	data->temperature[i][j] = (
	  data->temperature[i][j] +
	  data->temperature[i+1][j] +
	  data->temperature[i-1][j] +
	  data->temperature[i][j+1] +
	  data->temperature[i][j-1] )/5.0;
}

void fillBorder(CellData *data, double * d, int fromLeft)
{
  int i;
  if (fromLeft = 1) {
    for (i=0; i< data->height; i++)
      d[i] = data->temperature[data->width][i];
  } else {
    for (i=0; i< data->height; i++)
      d[i] = data->temperature[1][i];
  }
}

