/*
Simple Array Reduction test program--
Orion Sky Lawlor, olawlor@acm.org, 11/15/1999

This program shows how to use the Array mangager's 
reduction routines.
 */
#include <stdio.h>
#include <string.h>
#include "hello.decl.h"
#include "reductions.h"

CkChareID mid;
CkAID aid;
int nElements;

class HiMsg : public ArrayMessage, public CMessage_HiMsg
{
  int data;
};
typedef struct {
	int reductionsRemaining;
} myReductionCounter;

//Set this to 1 to test the set-wise reductions;
// otherwise the reduction will be a sum.
#define REDUCE_SET 1

void printIntReductionHandler(void *param,int dataSize,void *data)
{
	CkPrintf("**********************************************\n");
	CkPrintf("*** Final reduction handler called-- %d bytes:\n",dataSize);
#if REDUCE_SET
//Is a reduction set--parse each element
	reduction_set_element *cur=(reduction_set_element *)data;
	char *start=(char *)data;
	while (cur!=NULL)
	{
		CkPrintf("*** element %d contribution is %d bytes (starting at %d): ",cur->sourceElement,cur->dataSize,(int)(((char *)cur)-start));
		CkPrintf("'%s'\n",(char *)cur->data);
		cur=next_reduction_set_element(cur);
	}
#else
//Not a reduction set-- just some sort of data
		CkPrintf("*** as int: %d\n",*(int *)data);
		CkPrintf("*** as double: %f\n",*(double *)data);
#endif
		
	CkPrintf("**********************************************\n");
	myReductionCounter *c=(myReductionCounter *)param;
	c->reductionsRemaining--;
	if (c->reductionsRemaining<=0)
	{//We're finished-- tell main to quit
		CProxy_main mproxy(mid);
		mproxy.maindone();
	} else 
	{//Start the ring going again
		CProxy_Hello hproxy(aid);
		for (int i=0;i<nElements;i++)
			hproxy[i].SayHi(new HiMsg);
	}
}

class main : public Chare
{
public:
  main(CkArgMsg* m)
  {
    if(m->argc < 2) {
      CkAbort("Usage: hello <nElements>\n");
    }
    nElements = atoi(m->argv[1]);
    delete m;
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mid = thishandle;

    aid = CProxy_Hello::ckNew(nElements);
    myReductionCounter *c=new myReductionCounter;
    c->reductionsRemaining=2;
    aid._array->registerReductionHandler(printIntReductionHandler,(void *)c);
    
    CProxy_Hello hproxy(aid);
    for (int i=0;i<nElements;i++)
    	hproxy[i].SayHi(new HiMsg);
  };

  void maindone(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

class Hello : public ArrayElement
{
public:
  Hello(ArrayElementCreateMessage *m) : ArrayElement(m)
  {
    //CkPrintf("Hello %d created\n",thisIndex);
    finishConstruction();
  }

  Hello(ArrayElementMigrateMessage *m) : ArrayElement(m)
  {
    CkPrintf("Hello %d migrating\n",thisIndex);
    finishMigration();
  }

  void SayHi(HiMsg *m)
  {
  	int f=thisIndex*(thisIndex+1)+2;
#if REDUCE_SET
	//Reducting to a set-- contribute some random string
	char buf[100];
	sprintf(buf,"I'm %d, running on PE %d.  f=%d.",thisIndex,CkMyPe(),f);
	contribute(strlen(buf)+1,(void *)buf,reduction_set);
#else
	//Not reducting to a set-- just contribute an integer
  	contribute(sizeof(int),(void *)&f,reduction_sum_int);
#endif
  	
    /*if (thisIndex < numElements-1) {
      CProxy_Hello hproxy(aid);
      hproxy[thisIndex+1].SayHi(m);
    } else {
      CProxy_main mproxy(mid);
      mproxy.maindone();
      delete m;
    }*/
  }
};

#include "hello.def.h"
