#include "arrayring.h"

void arrayring_init(void)
{ 
  const int numElements = 50;
  CProxy_arrayRing_array::ckNew(numElements);
}

void arrayring_moduleinit(void){}

arrayRing_array::arrayRing_array(ArrayElementCreateMessage *msg) : 
                 ArrayElement(msg)
{
   delete msg;
   if(thisIndex==0) {
     CProxy_arrayRing_array carr(thisAID);
     carr[0].start(new arrayMessage);
   }
   finishConstruction();
}

arrayRing_array::arrayRing_array(ArrayElementMigrateMessage *msg) : 
                 ArrayElement(msg)
{
   delete msg;
   finishMigration();
}

void arrayRing_array::start(arrayMessage *msg)
{
  const int maxRings = 10;

  if(!msg->check()) {
    CkError("Message corrupted!\n");
    finishTest();
    return;
  }
  if(thisIndex==0)
    msg->iter++;
  if (msg->iter < maxRings) {
    CProxy_arrayRing_array hr(thisAID);
    hr[(thisIndex+1) % numElements].start(msg);
  } else {
    delete msg;
    finishTest();
  }
  return;
}

#include "arrayring.def.h"
