#include <stdio.h>
#include "hello.decl.h"

CkChareID mid;
CkAID aid;

class HiMsg : public ArrayMessage, public CMessage_HiMsg
{
  int data;
};

class main : public Chare
{
public:
  main(CkArgMsg* m)
  {
    if(m->argc < 2) {
      CkAbort("Usage: hello <nElements>\n");
    }
    int nElements = atoi(m->argv[1]);
    delete m;
    CkPrintf("Running Hello on %d processors for %d elemenst\n",
	     CkNumPes(),nElements);
    mid = thishandle;

    aid = CProxy_Hello::ckNew(nElements);

    CProxy_Hello hproxy(aid);
    hproxy[0].SayHi(new HiMsg);
  };

  void maindone(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

class Hello : public ArrayElement
{
public:
  Hello(ArrayElementCreateMessage *m) : ArrayElement(m)
  {
    CkPrintf("Hello %d created\n",thisIndex);
    finishConstruction();
  }

  Hello(ArrayElementMigrateMessage *m) : ArrayElement(m)
  {
    CkPrintf("Hello %d migrating\n",thisIndex);
    finishMigration();
  }

  void SayHi(HiMsg *m)
  {
    CkPrintf("Hi from element %d\n",thisIndex);
    if (thisIndex < numElements-1) {
      CProxy_Hello hproxy(aid);
      hproxy[thisIndex+1].SayHi(m);
    } else {
      CProxy_main mproxy(mid);
      mproxy.maindone();
      delete m;
    }
  }
};

#include "hello.def.h"
