#ifndef _QUEENS_H
#define _QUEENS_H

#include "queens.decl.h"
#include "megatest.h"

#define NUMQUEENS 8
#define Q_GRAIN 6


extern int queens_counterGroup;

class queens_PartialBoard : public CMessage_queens_PartialBoard { 
 public:
  int nextRow;
  int Queens[NUMQUEENS];
  int counterGroup;
};

class queens_DMSG: public CMessage_queens_DMSG {
 public:
  int counterGroup;
};

class queens_countMsg : public CMessage_queens_countMsg {
 public:
  int count;
  queens_countMsg(int c) : count(c) {};
};

class queens_main : public Chare {
 public:
  int counterGroup;
  queens_main(queens_DMSG * dmsg);
  void Quiescence1(CkQdMsg *);
};

class queens_queens : public Chare {
 private:
  void seqQueens(int queens[], int nextRow);
  int consistent(int queens[], int lastRow, int col);
  void solutionFound(void);

 public:
  int counterGroup;
  queens_queens(queens_PartialBoard *m);
};

class queens_counter: public Group {
 private:
  int myCount;
  int totalCount;
  int waitFor;
  CthThread threadId;
 public:
  queens_counter(void);
  void childCount(queens_countMsg *);
  void increment(void);
  void sendCounts(void);
  int  getTotalCount(void);
};

#endif
