recursive subroutine ampimain
  use mpi
  implicit none
    interface
      function AMPI_Wtime()
        double precision :: AMPI_Wtime
      end function AMPI_Wtime
    end interface

  integer :: thisIndex, ierr, nblocks, i
  double precision :: inval, outval, expect

  call AMPI_Init(ierr)
  call AMPI_Comm_rank(AMPI_COMM_WORLD, thisIndex, ierr)
  call AMPI_Comm_size(AMPI_COMM_WORLD, nblocks, ierr)

  inval = thisIndex + 1
  call AMPI_Reduce(inval, outval, 1, AMPI_DOUBLE_PRECISION, AMPI_SUM, &
&                     0, AMPI_COMM_WORLD, ierr)

  expect = (nblocks*(nblocks+1))/2
  if(thisIndex .eq. 0) then
    if (outval .eq. expect) then
      write(*,*) 'reduce test passed'
    else
      write(*,*) 'reduce test failed expected', expect, ' got ', outval
    end if
  end if
  call AMPI_Finalize(ierr)

end subroutine
