!! compiling
!! ~ruiliu/projects/mesh/meshdata.PeN
!! log onto elegance to compile


SUBROUTINE init
    WRITE (*,*) 'init_ called\n'
END SUBROUTINE init


SUBROUTINE driver(NumNodes, arrayNodeNumbers, NumElems, arrayElemNumbers, NumNodesPerElem, arrayConnectivity)

  !!--------------- Begin Variable Declaration ----------------!!

  TYPE Node
      DOUBLE PRECISION               :: temp
      DOUBLE PRECISION               :: prev
  END TYPE Node

  TYPE Element
      DOUBLE PRECISION               :: temp
      DOUBLE PRECISION               :: prev
  END TYPE Element

  !! Parameters !!
  INTEGER                            :: NumNodes, NumElems, NumNodesPerElem
  INTEGER, DIMENSION(0:NumNodes-1)   :: arrayNodeNumbers
  INTEGER, DIMENSION(0:NumElems-1)   :: arrayElemNumbers
  INTEGER, DIMENSION(0:NumElems-1,0:NumNodesPerElem-1)   :: arrayConnectivity

  !! Local variables !!
  INTEGER                           :: i,j  !! loop indices
  TYPE(Node), DIMENSION(0:NumNodes-1)        :: arrayNodes
  TYPE(Node), DIMENSION(0:NumElems-1)        :: arrayElems
  INTEGER                           :: fid   !! field id
  LOGICAL                           :: converged    !! is error small enough to quit?
  REAL                              :: diff   

  !!---------------- End Variable Declaration -----------------!!


  !! Set the arrays initially to zero !!
  DO i = 0, NumNodes-1
    arrayNodes(i)%temp = RANDOM_NUMBER/8.d0;
    arrayNodes(i)%prev = 0.d0;
  ENDDO
  DO i = 0, NumElems-1
    arrayElems(i)%temp = 0.d0;
    arrayElems(i)%prev = 0.d0;
  ENDDO

  !! Register the node size and offset of temp field with Framework !!
  !! FEM_type, # of variables, offset of first var from beginning of TYPE, sizeof(TYPE)
  fid = FEM_Create_Field(FEM_DOUBLE, 1, 0, &
	offsetof(arrayNodes(0), arrayNodes(1)))
  
  !! Combine shared nodes
  CALL FEM_Update_Field(fid, arrayNodes(0));
              
  converged = .false.
  DO WHILE (.NOT.converged)

    !! Do the calculations on the elements: avg of surrounding neighbors !!
    DO i = 0, NumElems-1
      arrayElems(i)%prev = arrayElems(i)%temp
      arrayElems(i)%temp = 0.d0
      DO j = 0, NumNodesPerElem
        arrayElems(i)%temp = arrayElems(i)%temp + &
             arrayNodes(arrayConnectivity(i,j))%temp
      ENDDO
      arrayElems(i)%temp = arrayElems(i)%temp / NumNodesPerElem
    ENDDO

    !! Prepare the nodes for calculation !!
    DO i = 0, NumNodes-1
      arrayNodes(i)%prev = arrayNodes(i)%temp
      arrayNodes(i)%temp = 0.d0
    ENDDO

    !! Do calculation on nodes !!
    DO i = 0, NumElems-1
      DO j = 0, NumNodesPerElem
        arrayNodes(arrayConnectivity(i,j))%temp =  &
             arrayNodes(arrayConnectivity(i,j))%temp + arrayElems(i)%temp / 8.d0
      ENDDO
    ENDDO

    !! Combine shared nodes !!
    CALL FEM_Update_Field(fid, arrayNodes)

    !! Calculate the error to determine if we should stop !!

    !! Calculate the error on this calculation for all these elements
    diff = 0.d0
    DO i = 0, NumElems
      diff = diff + ABS(arrayElems(i)%prev - arrayElems(i)%temp);
    ENDDO

    !! Now, sum the errors from all the elements in all the chunks
    CALL FEM_Reduce(FEM_DOUBLE, diff, diff)

    !! If we are on the first processor, print error achieved
    IF (FEM_My_Partition() == 0) WRITE(*,*) 'Error - ', diff
    converged = (diff < 1*10**(-8))
  ENDDO

END SUBROUTINE driver


SUBROUTINE finalize()
  WRITE(*,*) 'finalize_ called'
END SUBROUTINE finalize

