/*
** client.c -- client for the scheduler
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <signal.h>
#include <fcntl.h>

int PORT;   /* the port client will be connecting to */

#define MAXDATASIZE 100 /* max number of bytes we can get at once */

extern int errno;

void handler(int);

int main(int argc, char **argv)
{
    int sockfd, numbytes;
    char buf[MAXDATASIZE];
    struct hostent *he;
    struct sockaddr_in their_addr; /* connector's address information */
    char *str;
    int status, argcount;

    // SIGPIPE is received if the socket stream connection is broken.
    signal(SIGPIPE,handler);

    if (argc < 4) {
	printf("usage: client scheduler_name port program_name [<args>]\n");
        exit(1);
    }

    if ((he=gethostbyname(argv[1])) == NULL) {  /* get the host info */
        perror("gethostbyname");
        exit(1);
    }

    PORT = atoi(argv[2]);
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    their_addr.sin_family = AF_INET;         /* host byte order */
    their_addr.sin_port = htons(PORT);     /* short, network byte order */
    their_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(their_addr.sin_zero), 8);        /* zero the rest of the struct */

    if (connect(sockfd, (struct sockaddr *)&their_addr,
		sizeof(struct sockaddr)) == -1) {
        perror("connect");
        exit(1);
    }

    // Prepare and send the command line to the scheduler.
    str = (char*)malloc(MAXDATASIZE);
    sprintf(str,"%d ", argc - 3);

    for(argcount = 3; argcount < argc; argcount++){
	strcat(str, argv[argcount]);
	strcat(str, " ");
    }
    str[strlen(str)] = '\n';
    str[strlen(str)] = '\0';
    write(sockfd, str, strlen(str));

    errno = 0;

    // Print to STDOUT everything that we get from the other side.
    while(1){
       numbytes = read(sockfd, buf, MAXDATASIZE);
       if (numbytes <= 0)
	  break;
       write(1, buf, numbytes);
    }

    close(sockfd);

    return 0;
}

void  handler(int id){
  printf("handler\n");
  exit(0);
}
