
#include <stdlib.h>
#include "blue.h"

int sendID;

extern "C" void sendHandler(char *) ;
const int MAX_ITERATIONS=1000;
int NUM_ITERATIONS;

class Msg
{};

void BgEmulatorInit(int argc, char **argv) 
{
  if (argc < 7) { 
    CmiAbort("Usage: <program> <x> <y> <z> <numCommTh> <numWorkTh> <numIterations>\n"); 
  }

  BgSetSize(atoi(argv[1]), atoi(argv[2]), atoi(argv[3]));
  BgSetNumCommThread(atoi(argv[4]));
  BgSetNumWorkThread(atoi(argv[5]));

  NUM_ITERATIONS = atoi(argv[6]);

  sendID = BgRegisterHandler(sendHandler) ;
}

void BgNodeStart(int argc, char **argv) 
{
  //ckout << "Initializing node " << bgNode->thisIndex.x << "," 
  //      << bgNode->thisIndex.y << "," << bgNode->thisIndex.z << endl; 

  int x,y,z;
  BgGetXYZ(&x, &y, &z);

  if(x == 0 && y == 0 && z == 0)
  {
  	Msg *msg = new Msg;
	CmiPrintf("adding message\n");
  	BgSendLocalPacket(ANYTHREAD, sendID, SMALL_WORK, sizeof(Msg), (char *)msg);
  	CmiPrintf("after addMessage\n");
  }

  int *neelam;
  BgSetNodeData((char *)neelam);
}

void sendHandler(char *info) 
{
  int i;
  //int x,y,z;
  //info->bgNode->getXYZ(x,y,z);
  CmiPrintf("handler\n");

  double time[MAX_ITERATIONS];
  
  //if(x==0 && y==0 && z==0)
  {
	for(i=0; i<NUM_ITERATIONS; i++)
		time[i] = BgGetTime();
	for(i=0; i<NUM_ITERATIONS; i++)
		CmiPrintf("%f\n", time[i]);

        BgShutdown();
  }
}



