/*Automatically generated from tk_init.tcl:*/
"# tcl_init.tcl\n"
"#\n"
"# This is the GUI initialization/utility portion.\n"
"#\n"
"# Orion Sky Lawlor, olawlor@acm.org, 11/27/2001\n"
"#\r\n"
"\r\n"
"wm withdraw .\n"
"\n"
"################ Window Maintainance ################\n"
"\n"
"proc addMenus {w} {\n"
"	# Menu bar section\n"
"	set currMenu 0\n"
"	menu $w.menubar\n"
"	# I'm using TCL-8.0 style menus, so I can attach $w.menubar to $w\n"
"	$w configure -menu $w.menubar\n"
"\n"
"	global tcl_platform mod_user modifier\n"
"	if {$tcl_platform(platform) == \"macintosh\"} {\n"
"	   set modifier Command; set mod_user Command\n"
"	} elseif {$tcl_platform(platform) == \"windows\"} {\n"
"	    set modifier Control; set mod_user Ctrl\n"
"	} else {\n"
"	    set modifier Meta;set mod_user Meta\n"
"	}\n"
"\n"
"	proc makeMenu {w name title under} {\n"
"		global currMenu \n"
"		set currMenu $w.menubar.$name\n"
"		$w.menubar add cascade -label $title -menu $currMenu -underline $under\n"
"		menu $currMenu -tearoff 0\n"
"	}\n"
"\n"
"	proc makeCommand {w command label letter underlineNo} {\n"
"		global currMenu modifier mod_user\n"
"		$currMenu add command -label $label -command $command \\\n"
"			-accelerator $mod_user+[string toupper $letter] \\\n"
"			-underline $underlineNo\n"
"		bind $w <$modifier-$letter> $command\n"
"	}\n"
"\n"
"	############## File Menu (always there) ###############\n"
"	makeMenu $w file \"File\" 0\n"
"\n"
"	if {$tcl_platform(platform) == \"macintosh\"} {\n"
"		makeCommand $w {doQuit} \"Quit\" q 0\n"
"	} else {makeCommand $w {doQuit} \"Exit\" x 1}\n"
"}\n"
"\n"
"proc buildWindow {w name} {\n"
"#	catch \"destroy $w\"\n"
"        catch {\r\n"
"			toplevel $w\n"
"			wm title $w $name\n"
"			wm iconname $w $name\n"
"			wm group $w .\r\n"
"		}\n"
"}\n"
"proc neededWindow {w} {\n"
"        bind $w <Destroy> {doQuit}\n"
"}\n"
"proc buildToplevel {w name} {\n"
"	buildWindow $w $name\n"
"        addMenus $w\n"
"        neededWindow $w\n"
"}\n"
"\n"
"proc killWindow {w} {\n"
"	catch \"destroy $w\"\n"
"}\n"
"\n"
"# Create a modal text entry dialog box with the given \n"
"# description\n"
"proc textDialogBegin {w shortDesc desc default accept reject} {\n"
"	buildWindow $w $shortDesc\n"
"	\n"
"# Set up buttons-- OK, Log, and log file name display\n"
"	label $w.desc -text $desc\n"
"	pack $w.desc -side top -anchor nw\n"
"\n"
"	frame $w.bf\n"
"	pack $w.bf -side bottom -fill x\n"
"	\n"
"	button $w.bf.accept -text $accept -command {modalEnd}\n"
"	pack $w.bf.accept -side right\n"
"	bind $w <Key-Return> {modalEnd}\n"
"	\n"
"	button $w.bf.reject -text $reject -command \"\n"
"		$w.text delete 0.0 end\n"
"		modalEnd\n"
"	\"\n"
"	pack $w.bf.reject -side right\n"
"	bind $w <Destroy> {doQuit}\n"
"\n"
"# Set up text field\n"
"	text $w.text -wrap word -height 1 -width 50\n"
"	$w.text insert 0.0 $default\n"
"	pack $w.text -fill both -expand yes\n"
"}\n"
"proc textDialogGet {w} {\n"
"	modalBegin\n"
"	set ret [ string trimright [ $w.text get 0.0 end ] ]\n"
"	return $ret\n"
"}\n"
"proc textDialogEnd {w} {\n"
"	wm withdraw $w\n"
"}\n"
"\n"
"proc fatalError {what} {\n"
"	set errtext \"Sorry, a fatal error occured:\\n\"\n"
"	append errtext $what\n"
"	append errtext {\n"
"For support information, contact olawlor@acm.org\n"
"}\n"
"	tk_dialog .fatalerr_dialog \"Fatal Error!\" $errtext {} 0 \"Exit\"\n"
"	puts \"Tcl GUI exiting after error\"\n"
"	doQuit\n"
"}\n"
"proc fatalTcl {} {\n"
"  	global errorCode errorInfo\n"
"  	fatalError $errorInfo\n"
"}\n"
"\n"
"################ commands ###############\n"
"proc doQuit {} {\n"
"# This one's pretty simple...\n"
"	exit 1\n"
"}\n"
"\n"
"############# Eval-- catches errors in commands ###########\n"
"proc c2tcl_eval args {\n"
"  set programResult [catch \"eval $args\" ]\n"
"\n"
"# Check for abnormal termination\n"
"  if {$programResult!=0} {fatalTcl}\n"
"}\n"
"\n"
"################## Visualization tools #####################\n"
"# These were moved into C++ side because of linking problems\r\n"
"# under Win32.\n"
"\n"
"proc v_step {p} {\n"
"	ccsGetStepAll\r\n"
"	guiRerender\n"
"}\n"
"\n"
"\n"
"############################################################\n"
"#################### Main program ##########################\n"
"\n"
"#c2tcl_eval {buildToplevel .crap \"It loaded\"}\n"
"\n"
"proc startAppWith {nameStr} {\n"
"	set res [ catch \"eval ccsConnect $nameStr\" ]\n"
"	if {$res} {\n"
"		global errorInfo\n"
"		puts \"Could not connect: $errorInfo\"\n"
"		doQuit\n"
"	}\n"
"	buildMain\n"
"}\n"
"\n"
"proc startApp {} {\n"
"	set loaded 0\n"
"	set td .tdw\n"
"	textDialogBegin $td \"Server\" \"Please enter the CCS Server to connect to:\" \"localhost:1234\" \"Connect\" \"Exit\"\n"
"	while {!$loaded} {\n"
"		set nameStr [ textDialogGet $td ]\n"
"		if {$nameStr==\"\"} {doQuit}\n"
"		set loaded 1\n"
"		set res [ catch \"eval ccsConnect $nameStr\" ]\n"
"		if {$res} {\n"
"			global errorInfo\n"
"			tk_dialog .err_dialog \"Could not connect:\" $errorInfo {} 0 \"OK\"\n"
"			set loaded 0\n"
"		}\n"
"	}\r\n"
"	textDialogEnd $td\r\n"
"	buildMain\r\n"
"}\n"
"\n"
"proc setStatus {toWhat} {\n"
"	.main.status configure -text \"$toWhat\"\n"
"}\n"
"\n"
"# Create and initialize the main window\n"
"proc buildMain {} {\n"
"	set w \".main\"\n"
"	buildToplevel $w \"CCS View\"\n"
"	\n"
"	label $w.spacer -text \" \" -height 12 -width 1\n"
"	pack $w.spacer -side right\n"
"	\n"
"	label $w.status -text \"Starting up...\"\n"
"	pack $w.status -side bottom -fill x -anchor nw\n"
"	\n"
"	frame $w.f\n"
"	pack $w.f -side top -fill both -expand yes\n"
"	\n"
"	ccsWidgets $w.f\n"
"}\n"
"\n"
"\n"
"# End of init. routine	\n"
