#
#set title "Normalized Timing with and without Temperature LDB for Jacobi 2D"
set xlabel "Num. of cores" font "Helvetica,13"
set ylabel "Power (W)" font "Helvetica,13"
set key top right
set size 0.6,0.6
#set title "Wave2D: Normalized Execution times"
#set auto x
#set xtics ("58" 1,"62" 2,"65" 3,"68" 4,"" 5) 
set yrange [0:1200]
set style data histogram
set style histogram cluster gap 1
set style fill solid border -1
#set style histogram rowstacked
set boxwidth 0.9
#set style line 1 lc rgb "#a020f0"
set style line 1 lc rgb "#e6e6fa"
set style line 2 lc rgb "#da70d6"
set style line 4 lc rgb "#8B3A62"

#set style line 1 lc rgb "#ffc0cb"
#set style line 2 lc rgb "#e6e6fa"
#set style line 3 lc rgb "#9370db"
#set style line 4 lc rgb "#000080"

set y2label "Energy Overhead (%)" font "Helvetica,13"
set y2range [0:400]
set y2tics 0, 50
set ytics nomirror
#set style line 1 lc 12
#set style line 2 lc 13
set style increment user
#set grid y
#set xtic rotate by -45 scale 0
#set bmargin 10 
#set terminal postscript eps enhanced color "NimbusRomNo9L-Regu" fontfile "/opt/local/share/texmf-texlive-dist/fonts/type1/urw/times/utmr8a.pfb" 14
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 14
#set terminal png
set y2range [0:350]
set output "mol_e.eps"
plot 'mol_e.dat' using 2:xtic(1) ti "noLB Power" fs solid 4, '' u 3 axes x1y1 ti  "LB Power" fs solid 5, '' u 4 axes x1y2 ti  "noLB Energy" fs solid 5,  '' u 5 axes x1y2 ti  "LB Energy" fs solid 5
set output "wave_e.eps"
set y2range [0:80]
set y2tics 0, 10
set key top left
plot 'wave_e.dat' using 2:xtic(1) ti "noLB Power" fs solid 4, '' u 3 axes x1y1 ti  "LB Power" fs solid 5, '' u 4 axes x1y2 ti  "noLB Energy" fs solid 5,  '' u 5 axes x1y2 ti  "LB Energy" fs solid 5
set output "jacobi_e.eps"
set y2range [0:80]
set y2tics 0, 10
plot 'jacobi_e.dat' using 2:xtic(1) ti "noLB Power" fs solid 4, '' u 3 axes x1y1 ti  "LB Power" fs solid 5, '' u 4 axes x1y2 ti  "noLB Energy" fs solid 5,  '' u 5 axes x1y2 ti  "LB Energy" fs solid 5
