#
#set title "Normalized Timing with and without Temperature LDB for Jacobi 2D"
set xlabel "Num. of Cores"
set ylabel "Timing Penalty (%)"
set size 0.50,0.50
#set title "Wave2D: Normalized Execution times"
#set auto x
#set xtics ("58" 1,"62" 2,"65" 3,"68" 4,"" 5) 
set xtics nomirror
set yrange [0.0:45]
set style data histogram
set style histogram cluster gap 1
set style fill solid border -1
set boxwidth 0.9

set style line 1 lc 12
set style line 2 lc 13

set style line 1 lc rgb "#ffc0cb"
set style line 2 lc rgb "#e6e6fa"
set style line 3 lc rgb "#9370db"
set style line 4 lc rgb "#000080"

#set style line 1 lc rgb "#FF34B3"
#set style line 2 lc rgb "#AB82FF"
#set style line 3 lc rgb "#8A2BE2"
#set style line 4 lc rgb "#1E90FF"
set style increment user
#set xtic rotate by -45 scale 0
#set bmargin 10
set grid y
Ref100(x) = 1.00 
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 14
#set terminal png
set yrange [0.0:250]
set key top left
set output "wave_t.eps"
plot 'wave_t.dat' using 3:xtic(1) ti  col fs solid 4, '' u 2 ti  col fs solid 5, '' u 5 ti  col fs solid 4,'' u 4 ti  col fs solid 5
set yrange [0.0:250]
set key top right
set output "jacobi_t.eps"
plot 'jacobi_t.dat' using 3:xtic(1) ti  col fs solid 4, '' u 2 ti  col fs solid 5, '' u 5 ti  col fs solid 4,'' u 4 ti  col fs solid 5
set yrange [0.01:100000]
set logscale y
set output "mol_t.eps"
plot 'mol_t.dat' using 3:xtic(1) ti  col fs solid 4, '' u 2 ti  col fs solid 5, '' u 5 ti  col fs solid 4,'' u 4 ti  col fs solid 5
