set xlabel "Message Size (bytes)"
set ylabel "Latency (us)"
set y2label "Bandwidth (Mb/s)"
#set title "Startup Time vs Number of Cores: Comparison with OpenMPI Startup"
set logscale x 2
#set logscale y 2
#set logscale y2 2
set key top left
set size 0.75,0.75
#set yrange [0:10000]
set xtics ("8" 8,  "32" 32,  "128" 128, "512" 512 ,  "2K" 2048, "8k" 8192 , "32K" 32768, "128K" 131072, "512K" 524288)
#set xtics ("8" 8, "16" 16, "32" 32, "64" 64, "128" 128, "256" 256, "512" 512 , "1k" 1024, "2K" 2048, "4K" 4096, "8k" 8192 , "16K" 16384, "32K" 32768, "64K" 65536, "128K" 131072, "256K" 262144, "512K" 524288, "1M" 1048576)
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 14
set output "lat.eps"

plot "pingpongResult.dat" using 1:2 title "Latency" axes x1y1 with linespoints lw 3, \
"pingpongResult.dat" using 1:($1/$2) title "Throughput" axes x1y2 with linespoints lw 3
