set xlabel "Processors"
set ylabel "Parallel Efficiency"
#set y2label "Bandwidth (Mb/s)"
#set title "Startup Time vs Number of Cores: Comparison with OpenMPI Startup"
set logscale x 2
#set logscale y 2
#set logscale y2 2
set key top left
set size 0.75,0.75
#set yrange [32:20000]
#set y2range [0:1050]
#set y2tics ("0" 0 , "100" 100, "200" 200, "300" 300, "400" 400 ,"500" 500, "600" 600, "700" 700, "800" 800,"900" 900,"1000" 1000)
#set y2tics border
#set ytics ("1000" 1000, "400" 400 , "600" 600, "800" 800, "1000" 1000)
#set xtics ("8" 8,  "32" 32,  "128" 128, "512" 512 ,  "2K" 2048, "8k" 8192 , "32K" 32768, "128K" 131072, "512K" 524288, "2M" 2097152)
#set xtics ("8" 8, "16" 16, "32" 32, "64" 64, "128" 128, "256" 256, "512" 512 , "1k" 1024, "2K" 2048, "4K" 4096, "8k" 8192 , "16K" 16384, "32K" 32768, "64K" 65536, "128K" 131072, "256K" 262144, "512K" 524288, "1M" 1048576)
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 14
set output "jacobi.eps"

plot "vr1.dat" using 1:(0.001263/($2*$1)) title "256" axes x1y1 with linespoints lw 3, \
"vr1.dat" using 1:(0.004597/($3*$1)) title "512" axes x1y1 with linespoints lw 3, \
"vr1.dat" using 1:(0.0163/($4*$1)) title "1k" axes x1y1 with linespoints lw 3, \
"vr1.dat" using 1:(0.0732/($5*$1)) title "2k" axes x1y1 with linespoints lw 3, \
"vr1.dat" using 1:(0.3372/($6*$1)) title "4k" axes x1y1 with linespoints lw 3, \
"vr1.dat" using 1:(1.8298/($7*$1)) title "8k" axes x1y1 with linespoints lw 3

set output "jacobi2.eps"

plot "vrFG.dat" using 1:(0.001263/($2*$1)) title "256" axes x1y1 with linespoints lw 3, \
"vrFG.dat" using 1:(0.004597/($3*$1)) title "512" axes x1y1 with linespoints lw 3, \
"vrFG.dat" using 1:(0.0163/($4*$1)) title "1k" axes x1y1 with linespoints lw 3, \
"vrFG.dat" using 1:(0.0732/($5*$1)) title "2k" axes x1y1 with linespoints lw 3, \
"vrFG.dat" using 1:(0.3372/($6*$1)) title "4k" axes x1y1 with linespoints lw 3, \
"vrFG.dat" using 1:(1.8298/($7*$1)) title "8k" axes x1y1 with linespoints lw 3
