set xlabel "Message Size (bytes)"
set ylabel "Latency (us)"
#set title "Startup Time vs Number of Cores: Comparison with OpenMPI Startup"
set logscale x 2
set logscale y 2
#set logscale y2 2
set key top left
set size 0.5,0.5
set yrange [1:200000]
#set y2tics ("0" 0 , "100" 100, "200" 200, "300" 300, "400" 400 ,"500" 500, "600" 600, "700" 700, "800" 800,"900" 900,"1000" 1000)
#set ytics ("1000" 1000, "400" 400 , "600" 600, "800" 800, "1000" 1000)
set xtics ("8" 8,  "32" 32,  "128" 128, "512" 512 ,  "2K" 2048, "8k" 8192 , "32K" 32768, "128K" 131072, "512K" 524288, "2M" 2097152)
set xtics rotate by -40
#set xtics ("8" 8, "16" 16, "32" 32, "64" 64, "128" 128, "256" 256, "512" 512 , "1k" 1024, "2K" 2048, "4K" 4096, "8k" 8192 , "16K" 16384, "32K" 32768, "64K" 65536, "128K" 131072, "256K" 262144, "512K" 524288, "1M" 1048576)
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 15
set output "lat.eps"

plot "ping_Euca.dat" using 1:2 title "Euca. Cloud" axes x1y1 with linespoints ls 3  , \
"pingpongResult.dat" using 1:2 title "Open Cirrus" axes x1y1 with linespoints ls 2 , \
"pingTaub.dat" using 1:2 title "Taub" axes x1y1 with linespoints ls 1
