set xlabel "Grain Size"
set ylabel "Parallel Effeciency"
#set title "Startup Time vs Number of Cores: Comparison with OpenMPI Startup"
set logscale x 2
#set logscale y 2
#set logscale y2 2
set key top left
set format y "%g %% "
set size 0.75,0.75
set yrange [0:125]
set ytics 0,20,110
#set ytics ("20" 0.2, "40" 0.4, "60" 0.6, "80" 0.8, "100" 1)
#set xtics ("8" 8,  "32" 32,  "128" 128, "512" 512 ,  "2K" 2048, "8k" 8192 , "32K" 32768, "128K" 131072, "512K" 524288, "2M" 2097152)
set terminal postscript eps enhanced color "NimbusSanL-Regu" fontfile "/usr/share/texmf-texlive/fonts/type1/urw/helvetic/uhvr8a.pfb" 14
set output "vrjacobi.eps"

plot "vr2k.dat" using 1:(100*(0.0732/($2*16))) title "Problem Size = 2K" axes x1y1 with linespoints lw 3, \
"vr4k.dat" using 1:(100*(0.3372/($2*16))) title "Problem Size = 4K" axes x1y1 with linespoints lw 3, \
"vr8k.dat" using 1:(100*(1.8298/($2*16))) title "Problem Size = 8K" axes x1y1 with linespoints lw 3
