/**
 * \addtogroup CkLdb
*/
/*@{*/

#include "elements.h"
#include "ckheap.h"
#include "RefineLB.h"

CreateLBFunc_Def(RefineLB, "Move objects away from overloaded processor to reach average")
double oldTime,curTime,lbTime;
int numCPUPerNode1=4;
RefineLB::RefineLB(const CkLBOptions &opt): CentralLB(opt)
{
  oldTime = curTime = 0.0;
  lbname = (char *)"RefineLB";
getIdleTime(0);
numCPUPerNode1=4;
  if (CkMyPe() == 0)
    CkPrintf("[%d] RefineLB created\n",CkMyPe());
}
/*
double RefineLB::getIdleTime()
{
        FILE * pFile;
        char str[1000];
        pFile = fopen ("/proc/stat","r");
        fgets (str, 1000,pFile);
        for(int i=0;i<numCPUPerNode1;i++)
        {
                fgets (str, 1000, pFile);
//              CkPrintf("sss: %s\n",str);
 char * pch;
  pch = strtok (str," ");
  int cc=0;
  while (pch != NULL)
  {
//    printf ("%s ",pch);
    if(cc==4)
    {
        newIdle[i] = ((double) atoi(pch))/100.0;
//      CkPrintf("**%f** ",newIdle[i]);
    }
    pch = strtok (NULL, " ");
        cc++;
  }
CkPrintf("\n");
        }
///////
        for(int i=0;i<numCPUPerNode1;i++)
        {
                CkPrintf("PROC#%d idle=%f\n",i,newIdle[i]-oldIdle[i]);
                idleTime[i] = newIdle[i]-oldIdle[i];
        }
////////
for(int i=0;i<numCPUPerNode1;i++)
        oldIdle[i] = newIdle[i];
}
*/

void RefineLB::work(LDStats* stats)
{
curTime = CmiWallTimer();
lbTime = curTime - oldTime;
CkPrintf("------------- RefineLB work --------------- curTime = %f oldTime = %f lbTime = %f\n",curTime,oldTime,lbTime);
  int obj;
  int n_pes = stats->nprocs();

  //  CkPrintf("[%d] RefineLB strategy\n",CkMyPe());

  // RemoveNonMigratable(stats, n_pes);

  // get original object mapping
  int* from_procs = Refiner::AllocProcs(n_pes, stats);
//////////////////////////////////////////////////////////////////////////////////////
int numProcs = n_pes;
if(idleTime!=NULL) delete [] idleTime;
idleTime = new double[numProcs];
for(int i=0;i<numProcs;i++) 
{
	idleTime[i] = stats->procs[i].idleTime;
//	CkPrintf("PROC#%d IDLE T=%f\n",i,idleTime[i]);
}
//////////////////////////////////////////////////////////////////////////////////////
  for(obj=0;obj<stats->n_objs;obj++)  {
    int pe = stats->from_proc[obj];
    from_procs[obj] = pe;
  }

  // Get a new buffer to refine into
  int* to_procs = Refiner::AllocProcs(n_pes, stats);

  Refiner refiner(1.003);  // overload tolerance=1.05
//getIdleTime();
  refiner.Refine(n_pes, stats, from_procs, to_procs,lbTime,idleTime);

  // Save output
  for(obj=0;obj<stats->n_objs;obj++) {
      int pe = stats->from_proc[obj];
      if (to_procs[obj] != pe) {
        if (_lb_args.debug()>=2)  {
	  CkPrintf("[%d] Obj %d migrating from %d to %d\n",
		 CkMyPe(),obj,pe,to_procs[obj]);
        }
	stats->to_proc[obj] = to_procs[obj];
      }
  }

  // Free the refine buffers
  Refiner::FreeProcs(from_procs);
  Refiner::FreeProcs(to_procs);
  oldTime = CmiWallTimer();
}

#include "RefineLB.def.h"

/*@}*/
