#ifndef _DECL_jacobi3d_H_
#define _DECL_jacobi3d_H_
#include "charm++.h"
/* DECLS: readonly CProxy_Main mainProxy;
 */

/* DECLS: readonly int arrayDimX;
 */

/* DECLS: readonly int arrayDimY;
 */

/* DECLS: readonly int arrayDimZ;
 */

/* DECLS: readonly int blockDimX;
 */

/* DECLS: readonly int blockDimY;
 */

/* DECLS: readonly int blockDimZ;
 */

/* DECLS: readonly int num_chare_x;
 */

/* DECLS: readonly int num_chare_y;
 */

/* DECLS: readonly int num_chare_z;
 */

/* DECLS: readonly int globalBarrier;
 */

/* DECLS: message ghostMsg{
double gh[];
}
;
 */
class ghostMsg;
class CMessage_ghostMsg:public CkMessage{
  public:
    static int __idx;
    void* operator new(size_t, void*p) { return p; }
    void* operator new(size_t);
    void* operator new(size_t, int*, const int);
    void* operator new(size_t, int*);
#if CMK_MULTIPLE_DELETE
    void operator delete(void*p, void*){dealloc(p);}
    void operator delete(void*p){dealloc(p);}
    void operator delete(void*p, int*, const int){dealloc(p);}
    void operator delete(void*p, int*){dealloc(p);}
#endif
    void operator delete(void*p, size_t){dealloc(p);}
    static void* alloc(int,size_t, int*, int);
    static void dealloc(void *p);
    CMessage_ghostMsg() {};
    static void *pack(ghostMsg *p);
    static ghostMsg* unpack(void* p);
    void *operator new(size_t, int);
    void *operator new(size_t, int, const int);
#if CMK_MULTIPLE_DELETE
    void operator delete(void *p, int){dealloc(p);}
    void operator delete(void *p, int, const int){dealloc(p);}
#endif
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, dealloc, size);
    }
};

/* DECLS: mainchare Main: Chare{
Main(CkArgMsg* impl_msg);
void report(CkReductionMsg* impl_msg);
};
 */
 class Main;
 class CkIndex_Main;
 class CProxy_Main;
/* --------------- index object ------------------ */
class CkIndex_Main:public CProxy_Chare{
  public:
    typedef Main local_t;
    typedef CkIndex_Main index_t;
    typedef CProxy_Main proxy_t;
    typedef CProxy_Main element_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: Main(CkArgMsg* impl_msg);
 */
    static int __idx_Main_CkArgMsg;
    static int ckNew(CkArgMsg* impl_msg) { return __idx_Main_CkArgMsg; }
    static void _call_Main_CkArgMsg(void* impl_msg,Main* impl_obj);

/* DECLS: void report(CkReductionMsg* impl_msg);
 */
    static int __idx_report_CkReductionMsg;
    static int report(CkReductionMsg* impl_msg) { return __idx_report_CkReductionMsg; }
    static void _call_report_CkReductionMsg(void* impl_msg,Main* impl_obj);

};
/* --------------- element proxy ------------------ */
class CProxy_Main:public CProxy_Chare{
  public:
    typedef Main local_t;
    typedef CkIndex_Main index_t;
    typedef CProxy_Main proxy_t;
    typedef CProxy_Main element_t;

    CProxy_Main(void) {};
    CProxy_Main(CkChareID __cid) : CProxy_Chare(__cid){  }
    CProxy_Main(const Chare *c) : CProxy_Chare(c){  }
int ckIsDelegated(void) const {return CProxy_Chare::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_Chare::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_Chare::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_Chare::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_Chare::ckCheck();}
const CkChareID &ckGetChareID(void) const
{ return CProxy_Chare::ckGetChareID(); }
operator const CkChareID &(void) const {return ckGetChareID();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_Chare::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_Chare::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_Chare::pup(p);
    }
    void ckSetChareID(const CkChareID &c) {
      CProxy_Chare::ckSetChareID(c);
    }
    Main *ckLocal(void) const
     { return (Main *)CkLocalChare(&ckGetChareID()); }
/* DECLS: Main(CkArgMsg* impl_msg);
 */
    static CkChareID ckNew(CkArgMsg* impl_msg, int onPE=CK_PE_ANY);
    static void ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int onPE=CK_PE_ANY);
    CProxy_Main(CkArgMsg* impl_msg, int onPE=CK_PE_ANY);

/* DECLS: void report(CkReductionMsg* impl_msg);
 */
    void report(CkReductionMsg* impl_msg);

};
PUPmarshall(CProxy_Main)
typedef CBaseT1<Chare, CProxy_Main> CBase_Main;

/* DECLS: array Jacobi: ArrayElement{
Jacobi(CkMigrateMessage* impl_msg);
Jacobi(void);
void receiveGhosts(ghostMsg* impl_msg);
void doStep(void);
};
 */
 class Jacobi;
 class CkIndex_Jacobi;
 class CProxy_Jacobi;
 class CProxyElement_Jacobi;
 class CProxySection_Jacobi;
/* --------------- index object ------------------ */
class CkIndex_Jacobi:public CProxyElement_ArrayElement{
  public:
    typedef Jacobi local_t;
    typedef CkIndex_Jacobi index_t;
    typedef CProxy_Jacobi proxy_t;
    typedef CProxyElement_Jacobi element_t;
    typedef CProxySection_Jacobi section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: Jacobi(CkMigrateMessage* impl_msg);
 */
    static int __idx_Jacobi_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_Jacobi_CkMigrateMessage; }
    static void _call_Jacobi_CkMigrateMessage(void* impl_msg,Jacobi* impl_obj);

/* DECLS: Jacobi(void);
 */
    static int __idx_Jacobi_void;
    static int ckNew(void) { return __idx_Jacobi_void; }
    static void _call_Jacobi_void(void* impl_msg,Jacobi* impl_obj);

/* DECLS: void receiveGhosts(ghostMsg* impl_msg);
 */
    static int __idx_receiveGhosts_ghostMsg;
    static int receiveGhosts(ghostMsg* impl_msg) { return __idx_receiveGhosts_ghostMsg; }
    static void _call_receiveGhosts_ghostMsg(void* impl_msg,Jacobi* impl_obj);

/* DECLS: void doStep(void);
 */
    static int __idx_doStep_void;
    static int doStep(void) { return __idx_doStep_void; }
    static void _call_doStep_void(void* impl_msg,Jacobi* impl_obj);

};
/* --------------- element proxy ------------------ */
 class CProxyElement_Jacobi : public CProxyElement_ArrayElement{
  public:
    typedef Jacobi local_t;
    typedef CkIndex_Jacobi index_t;
    typedef CProxy_Jacobi proxy_t;
    typedef CProxyElement_Jacobi element_t;
    typedef CProxySection_Jacobi section_t;

    CProxyElement_Jacobi(void) {}
    CProxyElement_Jacobi(const ArrayElement *e) : CProxyElement_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxyElement_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxyElement_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxyElement_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxyElement_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxyElement_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxyElement_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxyElement_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxyElement_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxyElement_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_ArrayElement::ckSetReductionClient(cb); }
inline void ckInsert(CkArrayMessage *m,int ctor,int onPe)
  { CProxyElement_ArrayElement::ckInsert(m,ctor,onPe); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0) const
  { CProxyElement_ArrayElement::ckSend(m,ep,opts); }
inline void *ckSendSync(CkArrayMessage *m, int ep) const
  { return CProxyElement_ArrayElement::ckSendSync(m,ep); }
inline const CkArrayIndex &ckGetIndex() const
  { return CProxyElement_ArrayElement::ckGetIndex(); }
    Jacobi *ckLocal(void) const
      { return (Jacobi *)CProxyElement_ArrayElement::ckLocal(); }
    CProxyElement_Jacobi(const CkArrayID &aid,const CkArrayIndex3D &idx,CK_DELCTOR_PARAM)
        :CProxyElement_ArrayElement(aid,idx,CK_DELCTOR_ARGS) {}
    CProxyElement_Jacobi(const CkArrayID &aid,const CkArrayIndex3D &idx)
        :CProxyElement_ArrayElement(aid,idx) {}
/* DECLS: Jacobi(CkMigrateMessage* impl_msg);
 */

/* DECLS: Jacobi(void);
 */
    void insert(int onPE=-1);
/* DECLS: void receiveGhosts(ghostMsg* impl_msg);
 */
    void receiveGhosts(ghostMsg* impl_msg) ;

/* DECLS: void doStep(void);
 */
    void doStep(void) ;

};
PUPmarshall(CProxyElement_Jacobi)
/* ---------------- collective proxy -------------- */
 class CProxy_Jacobi : public CProxy_ArrayElement{
  public:
    typedef Jacobi local_t;
    typedef CkIndex_Jacobi index_t;
    typedef CProxy_Jacobi proxy_t;
    typedef CProxyElement_Jacobi element_t;
    typedef CProxySection_Jacobi section_t;

    CProxy_Jacobi(void) {}
    CProxy_Jacobi(const ArrayElement *e) : CProxy_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxy_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxy_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxy_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxy_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxy_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxy_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxy_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxy_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxy_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_ArrayElement::ckSetReductionClient(cb); }
    static CkArrayID ckNew(void) {return ckCreateEmptyArray();}
//Generalized array indexing:
    CProxyElement_Jacobi operator [] (const CkArrayIndex3D &idx) const
        {return CProxyElement_Jacobi(ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_Jacobi operator() (const CkArrayIndex3D &idx) const
        {return CProxyElement_Jacobi(ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_Jacobi operator () (int i0,int i1,int i2) const 
        {return CProxyElement_Jacobi(ckGetArrayID(), CkArrayIndex3D(i0,i1,i2), CK_DELCTOR_CALL);}
    CProxy_Jacobi(const CkArrayID &aid,CK_DELCTOR_PARAM) 
        :CProxy_ArrayElement(aid,CK_DELCTOR_ARGS) {}
    CProxy_Jacobi(const CkArrayID &aid) 
        :CProxy_ArrayElement(aid) {}
/* DECLS: Jacobi(CkMigrateMessage* impl_msg);
 */

/* DECLS: Jacobi(void);
 */
    static CkArrayID ckNew(const CkArrayOptions &opts);
    static CkArrayID ckNew(const int s1, const int s2, const int s3);

/* DECLS: void receiveGhosts(ghostMsg* impl_msg);
 */
    void receiveGhosts(ghostMsg* impl_msg) ;

/* DECLS: void doStep(void);
 */
    void doStep(void) ;

};
PUPmarshall(CProxy_Jacobi)
/* ---------------- section proxy -------------- */
 class CProxySection_Jacobi : public CProxySection_ArrayElement{
  public:
    typedef Jacobi local_t;
    typedef CkIndex_Jacobi index_t;
    typedef CProxy_Jacobi proxy_t;
    typedef CProxyElement_Jacobi element_t;
    typedef CProxySection_Jacobi section_t;

    CProxySection_Jacobi(void) {}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxySection_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxySection_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxySection_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxySection_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxySection_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxySection_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxySection_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxySection_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxySection_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_ArrayElement::ckSetReductionClient(cb); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0)
 { CProxySection_ArrayElement::ckSend(m,ep,opts); }
inline CkSectionInfo &ckGetSectionInfo()
  { return CProxySection_ArrayElement::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
  { return CProxySection_ArrayElement::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
  { return CProxySection_ArrayElement::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
  { return CProxySection_ArrayElement::ckGetSectionID(i); }
inline CkArrayID ckGetArrayIDn(int i) const
{return CProxySection_ArrayElement::ckGetArrayIDn(i); } 
inline CkArrayIndexMax *ckGetArrayElements() const
  { return CProxySection_ArrayElement::ckGetArrayElements(); }
inline CkArrayIndexMax *ckGetArrayElements(int i) const
{return CProxySection_ArrayElement::ckGetArrayElements(i); }
inline int ckGetNumElements() const
  { return CProxySection_ArrayElement::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{return CProxySection_ArrayElement::ckGetNumElements(i); } 
//Generalized array indexing:
    CProxyElement_Jacobi operator [] (const CkArrayIndex3D &idx) const
        {return CProxyElement_Jacobi(ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_Jacobi operator() (const CkArrayIndex3D &idx) const
        {return CProxyElement_Jacobi(ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_Jacobi operator () (int idx) const 
        {return CProxyElement_Jacobi(ckGetArrayID(), *(CkArrayIndex3D*)&ckGetArrayElements()[idx], CK_DELCTOR_CALL);}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndex3D *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
    static CkSectionID ckNew(const CkArrayID &aid, int l1, int u1, int s1, int l2, int u2, int s2, int l3, int u3, int s3) {
      CkVec<CkArrayIndex3D> al;
      for (int i=l1; i<=u1; i+=s1) 
        for (int j=l2; j<=u2; j+=s2) 
          for (int k=l3; k<=u3; k+=s3) 
          al.push_back(CkArrayIndex3D(i, j, k));
      return CkSectionID(aid, al.getVec(), al.size());
    } 
    CProxySection_Jacobi(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayElement(aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_Jacobi(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) 
        :CProxySection_ArrayElement(aid,elems,nElems) {}
    CProxySection_Jacobi(const CkSectionID &sid)       :CProxySection_ArrayElement(sid) {}
    CProxySection_Jacobi(int n, const CkArrayID *aid, CkArrayIndexMax const * const *elems, const int *nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayElement(n,aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_Jacobi(int n, const CkArrayID *aid, CkArrayIndexMax const * const *elems, const int *nElems) 
        :CProxySection_ArrayElement(n,aid,elems,nElems) {}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
/* DECLS: Jacobi(CkMigrateMessage* impl_msg);
 */

/* DECLS: Jacobi(void);
 */

/* DECLS: void receiveGhosts(ghostMsg* impl_msg);
 */
    void receiveGhosts(ghostMsg* impl_msg) ;

/* DECLS: void doStep(void);
 */
    void doStep(void) ;

};
PUPmarshall(CProxySection_Jacobi)
typedef CBaseT1<ArrayElementT<CkIndex3D>, CProxy_Jacobi> CBase_Jacobi;

extern void _registerjacobi3d(void);
extern "C" void CkRegisterMainModule(void);
#endif
