/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArrayInitializer;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayDimensions
extends SimpleNode {
    public Class baseType;
    public int numDefinedDims;
    public int numUndefinedDims;
    public int[] definedDimensions;

    BSHArrayDimensions(int n2) {
        super(n2);
    }

    public void addDefinedDimension() {
        ++this.numDefinedDims;
    }

    public void addUndefinedDimension() {
        ++this.numUndefinedDims;
    }

    public Object eval(Class clazz, CallStack callStack, Interpreter interpreter) throws EvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("array base type = " + clazz);
        }
        this.baseType = clazz;
        return this.eval(callStack, interpreter);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHArrayInitializer) {
            if (this.baseType == null) {
                throw new EvalError("Internal Array Eval err:  unknown base type", this, callStack);
            }
            Object object = ((BSHArrayInitializer)simpleNode).eval(this.baseType, this.numUndefinedDims, callStack, interpreter);
            Class<?> clazz = object.getClass();
            int n2 = Reflect.getArrayDimensions(clazz);
            this.definedDimensions = new int[n2];
            if (this.definedDimensions.length != this.numUndefinedDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.numUndefinedDims + " dimensional array, but initializer is a " + n2 + " dimensional array", this, callStack);
            }
            Object object2 = object;
            int n3 = 0;
            while (n3 < this.definedDimensions.length) {
                this.definedDimensions[n3] = Array.getLength(object2);
                if (this.definedDimensions[n3] > 0) {
                    object2 = Array.get(object2, 0);
                }
                ++n3;
            }
            return object;
        }
        this.definedDimensions = new int[this.numDefinedDims];
        int n4 = 0;
        while (n4 < this.numDefinedDims) {
            try {
                Object object = ((SimpleNode)this.jjtGetChild(n4)).eval(callStack, interpreter);
                this.definedDimensions[n4] = ((Primitive)object).intValue();
            }
            catch (Exception exception) {
                throw new EvalError("Array index: " + n4 + " does not evaluate to an integer", this, callStack);
            }
            ++n4;
        }
        return Primitive.VOID;
    }
}

