/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class JpegSegmentReader {
    private final File _file;
    private final byte[] _data;
    private final InputStream _stream;
    private JpegSegmentData _segmentData;
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;

    public JpegSegmentReader(File file) throws JpegProcessingException {
        this._file = file;
        this._data = null;
        this._stream = null;
        this.readSegments();
    }

    public JpegSegmentReader(byte[] fileContents) throws JpegProcessingException {
        this._file = null;
        this._data = fileContents;
        this._stream = null;
        this.readSegments();
    }

    public JpegSegmentReader(InputStream in) throws JpegProcessingException {
        this._stream = in;
        this._file = null;
        this._data = null;
        this.readSegments();
    }

    public JpegSegmentReader(JpegSegmentData segmentData) {
        this._file = null;
        this._data = null;
        this._stream = null;
        this._segmentData = segmentData;
    }

    public byte[] readSegment(byte segmentMarker) throws JpegProcessingException {
        return this.readSegment(segmentMarker, 0);
    }

    public byte[] readSegment(byte segmentMarker, int occurrence) {
        return this._segmentData.getSegment(segmentMarker, occurrence);
    }

    public final int getSegmentCount(byte segmentMarker) {
        return this._segmentData.getSegmentCount(segmentMarker);
    }

    public final JpegSegmentData getSegmentData() {
        return this._segmentData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readSegments() throws JpegProcessingException {
        this._segmentData = new JpegSegmentData();
        BufferedInputStream inStream = this.getJpegInputStream();
        try {
            int offset = 0;
            if (!this.isValidJpegHeaderBytes(inStream)) {
                throw new JpegProcessingException("not a jpeg file");
            }
            offset += 2;
            while (true) {
                byte segmentIdentifier;
                if (((segmentIdentifier = (byte)(inStream.read() & 0xFF)) & 0xFF) != 255) {
                    throw new JpegProcessingException("expected jpeg segment start identifier 0xFF at offset " + offset + ", not 0x" + Integer.toHexString(segmentIdentifier & 0xFF));
                }
                ++offset;
                byte thisSegmentMarker = (byte)(inStream.read() & 0xFF);
                ++offset;
                byte[] segmentLengthBytes = new byte[2];
                inStream.read(segmentLengthBytes, 0, 2);
                offset += 2;
                int segmentLength = segmentLengthBytes[0] << 8 & 0xFF00 | segmentLengthBytes[1] & 0xFF;
                if ((segmentLength -= 2) > inStream.available()) {
                    throw new JpegProcessingException("segment size would extend beyond file stream length");
                }
                if (segmentLength < 0) {
                    throw new JpegProcessingException("segment size would be less than zero");
                }
                byte[] segmentBytes = new byte[segmentLength];
                inStream.read(segmentBytes, 0, segmentLength);
                offset += segmentLength;
                if ((thisSegmentMarker & 0xFF) == 218) {
                    return;
                }
                if ((thisSegmentMarker & 0xFF) == 217) {
                    return;
                }
                this._segmentData.addSegment(thisSegmentMarker, segmentBytes);
                continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new JpegProcessingException("IOException processing Jpeg file: " + ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe) {
                throw new JpegProcessingException("IOException processing Jpeg file: " + ioe.getMessage(), ioe);
            }
        }
    }

    private BufferedInputStream getJpegInputStream() throws JpegProcessingException {
        InputStream inputStream;
        if (this._stream != null) {
            if (this._stream instanceof BufferedInputStream) {
                return (BufferedInputStream)this._stream;
            }
            return new BufferedInputStream(this._stream);
        }
        if (this._data == null) {
            try {
                inputStream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e2) {
                throw new JpegProcessingException("Jpeg file does not exist", e2);
            }
        } else {
            inputStream = new ByteArrayInputStream(this._data);
        }
        return new BufferedInputStream(inputStream);
    }

    private boolean isValidJpegHeaderBytes(InputStream fileStream) throws IOException {
        byte[] header = new byte[2];
        fileStream.read(header, 0, 2);
        return (header[0] & 0xFF) == 255 && (header[1] & 0xFF) == 216;
    }
}

