/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class SampleUsage {
    public SampleUsage(String fileName) {
        Metadata metadata;
        Metadata metadata2;
        File jpegFile = new File(fileName);
        try {
            metadata2 = JpegMetadataReader.readMetadata(jpegFile);
            this.printImageTags(1, metadata2);
        }
        catch (JpegProcessingException e2) {
            System.err.println("error 1a");
        }
        try {
            metadata2 = new Metadata();
            new ExifReader(jpegFile).extract(metadata2);
            new IptcReader(jpegFile).extract(metadata2);
            this.printImageTags(2, metadata2);
        }
        catch (JpegProcessingException jpe) {
            System.err.println("error 2a");
        }
        try {
            JpegSegmentReader segmentReader = new JpegSegmentReader(jpegFile);
            byte[] exifSegment = segmentReader.readSegment((byte)-31);
            byte[] iptcSegment = segmentReader.readSegment((byte)-19);
            metadata = new Metadata();
            new ExifReader(exifSegment).extract(metadata);
            new IptcReader(iptcSegment).extract(metadata);
            this.printImageTags(3, metadata);
        }
        catch (JpegProcessingException jpe) {
            System.err.println("error 3a");
        }
        try {
            JPEGImageDecoder jpegDecoder = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream(jpegFile));
            BufferedImage image = jpegDecoder.decodeAsBufferedImage();
            JPEGDecodeParam decodeParam = jpegDecoder.getJPEGDecodeParam();
            metadata = JpegMetadataReader.readMetadata(decodeParam);
            this.printImageTags(4, metadata);
        }
        catch (FileNotFoundException e3) {
            System.err.println("error 4a");
        }
        catch (IOException e4) {
            System.err.println("error 4b");
        }
    }

    private void printImageTags(int approachCount, Metadata metadata) {
        System.out.println();
        System.out.println("*** APPROACH " + approachCount + " ***");
        System.out.println();
        Iterator directories = metadata.getDirectoryIterator();
        while (directories.hasNext()) {
            Directory directory = (Directory)directories.next();
            Iterator tags = directory.getTagIterator();
            while (tags.hasNext()) {
                Tag tag = (Tag)tags.next();
                System.out.println(tag);
            }
            if (!directory.hasErrors()) continue;
            Iterator errors = directory.getErrors();
            while (errors.hasNext()) {
                System.out.println("ERROR: " + errors.next());
            }
        }
    }

    public static void main(String[] args) {
        new SampleUsage("src/com/drew/metadata/test/withIptcExifGps.jpg");
    }
}

