/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPActiveDataSocket
implements FTPDataSocket {
    public static String cvsId = "@(#)$Id: FTPActiveDataSocket.java,v 1.6 2006/10/17 10:27:15 bruceb Exp $";
    private static Logger log = Logger.getLogger("FTPActiveDataSocket");
    protected ServerSocket sock = null;
    protected Socket acceptedSock = null;

    protected FTPActiveDataSocket(ServerSocket sock) {
        this.sock = sock;
    }

    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
        if (this.acceptedSock != null) {
            this.acceptedSock.setSoTimeout(millis);
        }
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    protected void acceptConnection() throws IOException {
        log.debug("Calling accept()");
        this.acceptedSock = this.sock.accept();
        this.acceptedSock.setSoTimeout(this.sock.getSoTimeout());
        log.debug("accept() succeeded");
    }

    public OutputStream getOutputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        this.acceptConnection();
        return this.acceptedSock.getInputStream();
    }

    public void close() throws IOException {
        this.closeChild();
        this.sock.close();
        log.debug("close() succeeded");
    }

    public void closeChild() throws IOException {
        if (this.acceptedSock != null) {
            this.acceptedSock.close();
            this.acceptedSock = null;
            log.debug("closeChild() succeeded");
        }
    }
}

