/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.SocketUtils;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class FTPControlSocket {
    public static final String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.35 2007/01/10 02:36:53 bruceb Exp $";
    static final String EOL = "\r\n";
    public static final int CONTROL_PORT = 21;
    private static final String DEBUG_ARROW = "---> ";
    private static final String PASSWORD_MESSAGE = "---> PASS";
    private static Logger log = Logger.getLogger("FTPControlSocket");
    private boolean strictReturnCodes = true;
    protected Socket controlSock = null;
    protected Writer writer = null;
    protected BufferedReader reader = null;
    private FTPMessageListener messageListener = null;
    protected String forcedActiveIP;
    private int lowPort = -1;
    private int highPort = -1;
    private int nextPort = 0;
    private String encoding;
    protected InetAddress remoteAddr;
    protected boolean autoPassiveIPSubstitution = false;

    protected FTPControlSocket(InetAddress remoteAddr, int controlPort, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this(remoteAddr, SocketUtils.createSocket(remoteAddr, controlPort, timeout), timeout, encoding, messageListener);
    }

    protected FTPControlSocket(InetAddress remoteAddr, Socket controlSock, int timeout, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        this.remoteAddr = remoteAddr;
        this.controlSock = controlSock;
        this.messageListener = messageListener;
        this.encoding = encoding;
        this.setTimeout(timeout);
        this.initStreams();
        this.validateConnection();
    }

    protected void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
    }

    private void validateConnection() throws IOException, FTPException {
        FTPReply reply = this.readReply();
        String[] validCodes = new String[]{"220", "230"};
        this.validateReply(reply, validCodes);
    }

    protected void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is, this.encoding));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os, this.encoding);
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
    }

    void setTimeout(int millis) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(millis);
    }

    void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
    }

    public void logout() throws IOException {
        IOException ex = null;
        try {
            this.writer.close();
        }
        catch (IOException e2) {
            ex = e2;
        }
        try {
            this.reader.close();
        }
        catch (IOException e3) {
            ex = e3;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException e4) {
            ex = e4;
        }
        if (ex != null) {
            throw ex;
        }
    }

    FTPDataSocket createDataSocket(FTPConnectMode connectMode) throws IOException, FTPException {
        if (connectMode == FTPConnectMode.ACTIVE) {
            return this.createDataSocketActive();
        }
        return this.createDataSocketPASV();
    }

    FTPDataSocket createDataSocketActive() throws IOException, FTPException {
        FTPDataSocket socket = this.newActiveDataSocket(this.nextPort);
        if (this.lowPort >= 0 && this.highPort >= 0) {
            this.nextPort = this.nextPort < this.highPort ? ++this.nextPort : this.lowPort;
        }
        short port = (short)socket.getLocalPort();
        this.sendPORTCommand(port);
        return socket;
    }

    void sendPORTCommand(short port) throws IOException, FTPException {
        InetAddress localhost = this.controlSock.getLocalAddress();
        this.setDataPort(localhost, port);
    }

    private short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    protected byte[] toByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    void setActivePortIPAddress(String forcedActiveIP) {
        this.forcedActiveIP = forcedActiveIP;
    }

    public void setActivePortRange(int lowest, int highest) {
        this.lowPort = lowest;
        this.highPort = highest;
        this.nextPort = this.lowPort;
    }

    private byte[] getIPAddressBytes(String IPAddress) throws FTPException {
        byte[] ipbytes = new byte[4];
        int len = IPAddress.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < len && partCount <= 4; ++i2) {
            char ch2 = IPAddress.charAt(i2);
            if (Character.isDigit(ch2)) {
                buf.append(ch2);
            } else if (ch2 != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
            if (ch2 != '.' && i2 + 1 != len) continue;
            try {
                ipbytes[partCount++] = (byte)Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
        }
        return ipbytes;
    }

    protected void setDataPort(InetAddress host, short portNo) throws IOException, FTPException {
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = this.toByteArray(portNo);
        if (this.forcedActiveIP != null) {
            log.info("Forcing use of fixed IP for PORT command");
            hostBytes = this.getIPAddressBytes(this.forcedActiveIP);
        }
        String cmd = "PORT " + this.toUnsignedShort(hostBytes[0]) + "," + this.toUnsignedShort(hostBytes[1]) + "," + this.toUnsignedShort(hostBytes[2]) + "," + this.toUnsignedShort(hostBytes[3]) + "," + this.toUnsignedShort(portBytes[0]) + "," + this.toUnsignedShort(portBytes[1]);
        FTPReply reply = this.sendCommand(cmd);
        this.validateReply(reply, "200");
    }

    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        FTPReply replyObj = this.sendCommand("PASV");
        this.validateReply(replyObj, "227");
        String reply = replyObj.getReplyText();
        int startIP = reply.indexOf(40);
        int endIP = reply.indexOf(41);
        if (startIP < 0) {
            for (startIP = 0; startIP < reply.length() && !Character.isDigit(reply.charAt(startIP)); ++startIP) {
            }
            --startIP;
        }
        if (endIP < 0) {
            for (endIP = reply.length() - 1; endIP > 0 && !Character.isDigit(reply.charAt(endIP)); --endIP) {
            }
            if (++endIP >= reply.length()) {
                reply = reply + ")";
            }
        }
        String ipData = reply.substring(startIP + 1, endIP).trim();
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < len && partCount <= 6; ++i2) {
            char ch2 = ipData.charAt(i2);
            if (Character.isDigit(ch2)) {
                buf.append(ch2);
            } else if (ch2 != ',' && ch2 != ' ') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch2 != ',' && i2 + 1 != len) continue;
            try {
                parts[partCount++] = Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
        }
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        String hostIP = ipAddress;
        if (this.autoPassiveIPSubstitution) {
            hostIP = this.remoteAddr.getHostAddress();
            StringBuffer msg = new StringBuffer("Substituting server supplied IP (");
            msg.append(ipAddress).append(") with remote host IP (").append(hostIP).append(")");
            log.debug(msg.toString());
        }
        return this.newPassiveDataSocket(hostIP, port);
    }

    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        return new FTPPassiveDataSocket(new Socket(remoteHost, port));
    }

    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        ServerSocket sock = new ServerSocket(port);
        sock.setSoTimeout(this.controlSock.getSoTimeout());
        return new FTPActiveDataSocket(sock);
    }

    public FTPReply sendCommand(String command) throws IOException {
        this.writeCommand(command);
        return this.readReply();
    }

    void writeCommand(String command) throws IOException {
        this.log(DEBUG_ARROW + command, true);
        this.writer.write(command + EOL);
        this.writer.flush();
    }

    FTPReply readReply() throws IOException {
        String line = this.reader.readLine();
        while (line != null && line.length() == 0) {
            line = this.reader.readLine();
        }
        if (line == null) {
            throw new IOException("Unexpected null reply received");
        }
        this.log(line, false);
        if (line.length() < 3) {
            throw new IOException("Short reply received");
        }
        String replyCode = line.substring(0, 3);
        StringBuffer reply = new StringBuffer("");
        if (line.length() > 3) {
            reply.append(line.substring(4));
        }
        Vector<String> dataLines = null;
        if (line.charAt(3) == '-') {
            dataLines = new Vector<String>();
            boolean complete = false;
            while (!complete) {
                line = this.reader.readLine();
                if (line == null) {
                    throw new IOException("Unexpected null reply received");
                }
                if (line.length() == 0) continue;
                this.log(line, false);
                if (line.length() > 3 && line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ").append(line);
                dataLines.addElement(line);
            }
        }
        if (dataLines != null) {
            Object[] data = new String[dataLines.size()];
            dataLines.copyInto(data);
            return new FTPReply(replyCode, reply.toString(), (String[])data);
        }
        return new FTPReply(replyCode, reply.toString());
    }

    FTPReply validateReply(String reply, String expectedReplyCode) throws FTPException {
        FTPReply replyObj = new FTPReply(reply);
        if (this.validateReplyCode(replyObj, expectedReplyCode)) {
            return replyObj;
        }
        throw new FTPException(replyObj);
    }

    public FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        FTPReply replyObj = new FTPReply(reply);
        return this.validateReply(replyObj, expectedReplyCodes);
    }

    public FTPReply validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        for (int i2 = 0; i2 < expectedReplyCodes.length; ++i2) {
            if (!this.validateReplyCode(reply, expectedReplyCodes[i2])) continue;
            return reply;
        }
        throw new FTPException(reply);
    }

    public FTPReply validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        if (this.validateReplyCode(reply, expectedReplyCode)) {
            return reply;
        }
        throw new FTPException(reply);
    }

    private boolean validateReplyCode(FTPReply reply, String expectedReplyCode) {
        String replyCode = reply.getReplyCode();
        if (this.strictReturnCodes) {
            return replyCode.equals(expectedReplyCode);
        }
        return replyCode.charAt(0) == expectedReplyCode.charAt(0);
    }

    void log(String msg, boolean command) {
        if (msg.startsWith(PASSWORD_MESSAGE)) {
            msg = "---> PASS ********";
        }
        log.debug(msg);
        if (this.messageListener != null) {
            if (command) {
                this.messageListener.logCommand(msg);
            } else {
                this.messageListener.logReply(msg);
            }
        }
    }
}

