/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestFileOperations
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestFileOperations.java,v 1.8 2005/07/15 17:30:06 bruceb Exp $";
    private SimpleDateFormat modFormatter = new SimpleDateFormat("yyyy/MM/dd @ HH:mm:ss");

    protected String getLogName() {
        return "TestFileOperations.log";
    }

    public void testDelete() throws Exception {
        this.connect();
        this.ftp.chdir(this.testdir);
        try {
            String file = this.generateRandomFilename();
            this.log.debug("Deleting a non-existent file");
            this.ftp.delete(file);
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testRename() throws Exception {
        this.connect();
        this.ftp.chdir(this.testdir);
        String rename = this.remoteTextFile + ".renamed";
        this.ftp.rename(this.remoteTextFile, rename);
        Date modTime = this.ftp.modtime(rename);
        String mod = this.modFormatter.format(modTime);
        this.log.debug(rename + ": " + mod);
        try {
            this.ftp.modtime(this.remoteTextFile);
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.rename(rename, this.remoteTextFile);
        modTime = this.ftp.modtime(this.remoteTextFile);
        mod = this.modFormatter.format(modTime);
        this.log.debug(this.remoteTextFile + ": " + mod);
        try {
            this.ftp.modtime(rename);
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testModtime() throws Exception {
        this.connect();
        this.ftp.chdir(this.testdir);
        this.log.debug("Modtime on existing file: " + this.remoteTextFile);
        Date modTime = this.ftp.modtime(this.remoteTextFile);
        String mod = this.modFormatter.format(modTime);
        this.log.debug(this.remoteTextFile + ": " + mod);
        try {
            String file = this.generateRandomFilename();
            this.log.debug("Modtime on non-existent file");
            modTime = this.ftp.modtime(file);
            mod = this.modFormatter.format(modTime);
            this.log.debug(this.remoteTextFile + ": " + mod);
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testSize() throws Exception {
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localDataDir + this.localTextFile, filename);
        File local = new File(this.localDataDir + this.localTextFile);
        long sizeLocal = local.length();
        long sizeRemote = this.ftp.size(filename);
        this.ftp.delete(filename);
        if (sizeLocal != sizeRemote) {
            String msg = "Local size(" + sizeLocal + ") != remote size(" + sizeRemote + ")";
            this.log.debug(msg);
            throw new Exception(msg);
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(TestFileOperations.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestFileOperations.suite());
    }
}

