/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

public class Buffer {
    final byte[] tmp = new byte[4];
    byte[] buffer;
    int index;
    int s;

    public Buffer(int n2) {
        this.buffer = new byte[n2];
        this.index = 0;
        this.s = 0;
    }

    public Buffer(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.s = 0;
    }

    public Buffer() {
        this(20480);
    }

    public void putByte(byte by2) {
        this.buffer[this.index++] = by2;
    }

    public void putByte(byte[] byArray) {
        this.putByte(byArray, 0, byArray.length);
    }

    public void putByte(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buffer, this.index, n3);
        this.index += n3;
    }

    public void putString(byte[] byArray) {
        this.putString(byArray, 0, byArray.length);
    }

    public void putString(byte[] byArray, int n2, int n3) {
        this.putInt(n3);
        this.putByte(byArray, n2, n3);
    }

    public void putInt(int n2) {
        this.tmp[0] = (byte)(n2 >>> 24);
        this.tmp[1] = (byte)(n2 >>> 16);
        this.tmp[2] = (byte)(n2 >>> 8);
        this.tmp[3] = (byte)n2;
        System.arraycopy(this.tmp, 0, this.buffer, this.index, 4);
        this.index += 4;
    }

    public void putLong(long l2) {
        this.tmp[0] = (byte)(l2 >>> 56);
        this.tmp[1] = (byte)(l2 >>> 48);
        this.tmp[2] = (byte)(l2 >>> 40);
        this.tmp[3] = (byte)(l2 >>> 32);
        System.arraycopy(this.tmp, 0, this.buffer, this.index, 4);
        this.tmp[0] = (byte)(l2 >>> 24);
        this.tmp[1] = (byte)(l2 >>> 16);
        this.tmp[2] = (byte)(l2 >>> 8);
        this.tmp[3] = (byte)l2;
        System.arraycopy(this.tmp, 0, this.buffer, this.index + 4, 4);
        this.index += 8;
    }

    void skip(int n2) {
        this.index += n2;
    }

    void putPad(int n2) {
        while (n2 > 0) {
            this.buffer[this.index++] = 0;
            --n2;
        }
    }

    public void putMPInt(byte[] byArray) {
        int n2 = byArray.length;
        if ((byArray[0] & 0x80) != 0) {
            this.putInt(++n2);
            this.putByte((byte)0);
        } else {
            this.putInt(n2);
        }
        this.putByte(byArray);
    }

    public int getLength() {
        return this.index - this.s;
    }

    public int getOffSet() {
        return this.s;
    }

    public void setOffSet(int n2) {
        this.s = n2;
    }

    public long getLong() {
        long l2 = (long)this.getInt() & 0xFFFFFFFFL;
        l2 = l2 << 32 | (long)this.getInt() & 0xFFFFFFFFL;
        return l2;
    }

    public int getInt() {
        int n2 = this.getShort();
        n2 = n2 << 16 & 0xFFFF0000 | this.getShort() & 0xFFFF;
        return n2;
    }

    int getShort() {
        int n2 = this.getByte();
        n2 = n2 << 8 & 0xFF00 | this.getByte() & 0xFF;
        return n2;
    }

    public int getByte() {
        return this.buffer[this.s++] & 0xFF;
    }

    public void getByte(byte[] byArray) {
        this.getByte(byArray, 0, byArray.length);
    }

    void getByte(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.buffer, this.s, byArray, n2, n3);
        this.s += n3;
    }

    public int getByte(int n2) {
        int n3 = this.s;
        this.s += n2;
        return n3;
    }

    public byte[] getMPInt() {
        int n2 = this.getInt();
        byte[] byArray = new byte[n2];
        this.getByte(byArray, 0, n2);
        return byArray;
    }

    public byte[] getMPIntBits() {
        int n2 = this.getInt();
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        this.getByte(byArray, 0, n3);
        if ((byArray[0] & 0x80) != 0) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] getString() {
        int n2 = this.getInt();
        byte[] byArray = new byte[n2];
        this.getByte(byArray, 0, n2);
        return byArray;
    }

    byte[] getString(int[] nArray, int[] nArray2) {
        int n2 = this.getInt();
        nArray[0] = this.getByte(n2);
        nArray2[0] = n2;
        return this.buffer;
    }

    public void reset() {
        this.index = 0;
        this.s = 0;
    }

    public void shift() {
        if (this.s == 0) {
            return;
        }
        System.arraycopy(this.buffer, this.s, this.buffer, 0, this.index - this.s);
        this.index -= this.s;
        this.s = 0;
    }

    void rewind() {
        this.s = 0;
    }
}

