/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public class ChannelSftp
extends ChannelSession {
    private static final byte SSH_FXP_INIT = 1;
    private static final byte SSH_FXP_VERSION = 2;
    private static final byte SSH_FXP_OPEN = 3;
    private static final byte SSH_FXP_CLOSE = 4;
    private static final byte SSH_FXP_READ = 5;
    private static final byte SSH_FXP_WRITE = 6;
    private static final byte SSH_FXP_LSTAT = 7;
    private static final byte SSH_FXP_FSTAT = 8;
    private static final byte SSH_FXP_SETSTAT = 9;
    private static final byte SSH_FXP_FSETSTAT = 10;
    private static final byte SSH_FXP_OPENDIR = 11;
    private static final byte SSH_FXP_READDIR = 12;
    private static final byte SSH_FXP_REMOVE = 13;
    private static final byte SSH_FXP_MKDIR = 14;
    private static final byte SSH_FXP_RMDIR = 15;
    private static final byte SSH_FXP_REALPATH = 16;
    private static final byte SSH_FXP_STAT = 17;
    private static final byte SSH_FXP_RENAME = 18;
    private static final byte SSH_FXP_READLINK = 19;
    private static final byte SSH_FXP_SYMLINK = 20;
    private static final byte SSH_FXP_STATUS = 101;
    private static final byte SSH_FXP_HANDLE = 102;
    private static final byte SSH_FXP_DATA = 103;
    private static final byte SSH_FXP_NAME = 104;
    private static final byte SSH_FXP_ATTRS = 105;
    private static final byte SSH_FXP_EXTENDED = -56;
    private static final byte SSH_FXP_EXTENDED_REPLY = -55;
    private static final int SSH_FXF_READ = 1;
    private static final int SSH_FXF_WRITE = 2;
    private static final int SSH_FXF_APPEND = 4;
    private static final int SSH_FXF_CREAT = 8;
    private static final int SSH_FXF_TRUNC = 16;
    private static final int SSH_FXF_EXCL = 32;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    private static final int MAX_MSG_LENGTH = 262144;
    public static final int OVERWRITE = 0;
    public static final int RESUME = 1;
    public static final int APPEND = 2;
    private boolean interactive = false;
    private int seq = 1;
    private int[] ackid = new int[1];
    private Buffer buf;
    private Packet packet = new Packet(this.buf);
    private String version = "3";
    private int server_version = 3;
    private static final String file_separator = File.separator;
    private static final char file_separatorc = File.separatorChar;
    private String cwd;
    private String home;
    private String lcwd;
    private Vector threadList = null;

    public void init() {
    }

    public void start() throws JSchException {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.io.setOutputStream(pipedOutputStream);
            Channel.MyPipedInputStream myPipedInputStream = new Channel.MyPipedInputStream(pipedOutputStream, 32768);
            this.io.setInputStream(myPipedInputStream);
            RequestSftp requestSftp = new RequestSftp();
            ((Request)requestSftp).request(this.session, this);
            this.buf = new Buffer(this.rmpsize);
            this.packet = new Packet(this.buf);
            int n2 = 0;
            this.sendINIT();
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            if (n3 > 262144) {
                throw new SftpException(4, "Received message is too long: " + n3);
            }
            int n4 = header.type;
            this.server_version = header.rid;
            this.skip(n3);
            this.sendREALPATH(".".getBytes());
            header = this.header(this.buf, header);
            n3 = header.length;
            n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            n2 = this.buf.getInt();
            byte[] byArray = this.buf.getString();
            this.home = this.cwd = new String(byArray);
            byArray = this.buf.getString();
            this.lcwd = new File(".").getCanonicalPath();
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public void quit() {
        this.disconnect();
    }

    public void exit() {
        this.disconnect();
    }

    public void lcd(String string) throws SftpException {
        if (new File(string = this.localAbsolutePath(string)).isDirectory()) {
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lcwd = string;
            return;
        }
        throw new SftpException(2, "No such directory");
    }

    public void cd(String string) throws SftpException {
        try {
            int n2;
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.sendREALPATH(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            int n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101 && n4 != 104) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                n2 = this.buf.getInt();
                this.throwStatusError(this.buf, n2);
            }
            n2 = this.buf.getInt();
            byte[] byArray = this.buf.getString();
            if (byArray != null && byArray[0] != 47) {
                byArray = (this.cwd + "/" + new String(byArray)).getBytes();
            }
            byArray = this.buf.getString();
            n2 = this.buf.getInt();
            String string2 = new String(byArray);
            SftpATTRS sftpATTRS = this._stat(string2);
            if ((sftpATTRS.getFlags() & 4) == 0) {
                throw new SftpException(4, "Can't change directory: " + string);
            }
            if (!sftpATTRS.isDir()) {
                throw new SftpException(4, "Can't change directory: " + string);
            }
            this.cwd = string2;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void put(String string, String string2) throws SftpException {
        this.put(string, string2, null, 0);
    }

    public void put(String string, String string2, int n2) throws SftpException {
        this.put(string, string2, null, n2);
    }

    public void put(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.put(string, string2, sftpProgressMonitor, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        string = this.localAbsolutePath(string);
        string2 = this.remoteAbsolutePath(string2);
        try {
            Vector vector = this.glob_remote(string2);
            int n3 = vector.size();
            if (n3 != 1) {
                if (n3 != 0) throw new SftpException(4, vector.toString());
                if (this.isPattern(string2)) {
                    throw new SftpException(4, string2);
                }
                string2 = Util.unquote(string2);
                throw new SftpException(4, vector.toString());
            }
            string2 = (String)vector.elementAt(0);
            boolean bl2 = this.isRemoteDir(string2);
            vector = this.glob_local(string);
            n3 = vector.size();
            StringBuffer stringBuffer = null;
            if (bl2) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                stringBuffer = new StringBuffer(string2);
            } else if (n3 > 1) {
                throw new SftpException(4, "Copying multiple files, but destination is missing or a file.");
            }
            int n4 = 0;
            while (true) {
                block24: {
                    Object var17_19;
                    Object object;
                    if (n4 >= n3) {
                        return;
                    }
                    String string3 = (String)vector.elementAt(n4);
                    String string4 = null;
                    if (bl2) {
                        int n5 = string3.lastIndexOf(file_separatorc);
                        if (n5 == -1) {
                            stringBuffer.append(string3);
                        } else {
                            stringBuffer.append(string3.substring(n5 + 1));
                        }
                        string4 = stringBuffer.toString();
                        stringBuffer.delete(string2.length(), string4.length());
                    } else {
                        string4 = string2;
                    }
                    long l2 = 0L;
                    if (n2 == 1) {
                        try {
                            object = this._stat(string4);
                            l2 = ((SftpATTRS)object).getSize();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        long l3 = new File(string3).length();
                        if (l3 < l2) {
                            throw new SftpException(4, "failed to resume for " + string4);
                        }
                        if (l3 == l2) {
                            return;
                        }
                    }
                    if (sftpProgressMonitor != null) {
                        sftpProgressMonitor.init(0, string3, string4, new File(string3).length());
                        if (n2 == 1) {
                            sftpProgressMonitor.count(l2);
                        }
                    }
                    object = null;
                    try {
                        object = new FileInputStream(string3);
                        this._put((InputStream)object, string4, sftpProgressMonitor, n2);
                        var17_19 = null;
                        if (object == null) break block24;
                    }
                    catch (Throwable throwable) {
                        var17_19 = null;
                        if (object == null) throw throwable;
                        ((FileInputStream)object).close();
                        throw throwable;
                    }
                    ((FileInputStream)object).close();
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (!(exception instanceof Throwable)) throw new SftpException(4, exception.toString());
            throw new SftpException(4, exception.toString(), exception);
        }
    }

    public void put(InputStream inputStream, String string) throws SftpException {
        this.put(inputStream, string, null, 0);
    }

    public void put(InputStream inputStream, String string, int n2) throws SftpException {
        this.put(inputStream, string, null, n2);
    }

    public void put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.put(inputStream, string, sftpProgressMonitor, 0);
    }

    public void put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            if (n3 != 1) {
                if (n3 == 0) {
                    if (this.isPattern(string)) {
                        throw new SftpException(4, string);
                    }
                    string = Util.unquote(string);
                }
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (this.isRemoteDir(string)) {
                throw new SftpException(4, string + " is a directory");
            }
            this._put(inputStream, string, sftpProgressMonitor, n2);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, exception.toString(), exception);
            }
            throw new SftpException(4, exception.toString());
        }
    }

    public void _put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        try {
            int n3;
            int n4;
            long l2;
            long l3 = 0L;
            if (n2 == 1 || n2 == 2) {
                try {
                    SftpATTRS sftpATTRS = this._stat(string);
                    l3 = sftpATTRS.getSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n2 == 1 && l3 > 0L && (l2 = inputStream.skip(l3)) < l3) {
                throw new SftpException(4, "failed to resume for " + string);
            }
            if (n2 == 0) {
                this.sendOPENW(string.getBytes());
            } else {
                this.sendOPENA(string.getBytes());
            }
            Header header = new Header();
            header = this.header(this.buf, header);
            int n5 = header.length;
            int n6 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n5);
            if (n6 != 101 && n6 != 102) {
                throw new SftpException(4, "invalid type=" + n6);
            }
            if (n6 == 101) {
                int n7 = this.buf.getInt();
                this.throwStatusError(this.buf, n7);
            }
            byte[] byArray = this.buf.getString();
            byte[] byArray2 = null;
            boolean bl2 = true;
            if (!bl2) {
                byArray2 = new byte[this.buf.buffer.length - (39 + byArray.length + 32 + 20)];
            }
            long l4 = 0L;
            if (n2 == 1 || n2 == 2) {
                l4 += l3;
            }
            int n8 = this.seq;
            int n9 = this.seq;
            int n10 = 0;
            do {
                n3 = 0;
                int n11 = 0;
                int n12 = 0;
                n4 = 0;
                if (!bl2) {
                    n12 = byArray2.length - n11;
                } else {
                    byArray2 = this.buf.buffer;
                    n11 = 39 + byArray.length;
                    n12 = this.buf.buffer.length - n11 - 32 - 20;
                }
                do {
                    if ((n3 = inputStream.read(byArray2, n11, n12)) <= 0) continue;
                    n11 += n3;
                    n12 -= n3;
                    n4 += n3;
                } while (n12 > 0 && n3 > 0);
                if (n4 <= 0) break;
                int n13 = n4;
                block6: while (n13 > 0) {
                    n13 -= this.sendWRITE(byArray, l4, byArray2, 0, n13);
                    if (this.seq - 1 != n8 && this.io.in.available() < 1024) continue;
                    while (this.io.in.available() > 0) {
                        if (!this.checkStatus(this.ackid, header)) continue block6;
                        n9 = this.ackid[0];
                        if (n8 > n9 || n9 > this.seq - 1) {
                            if (n9 == this.seq) {
                                System.err.println("ack error: startid=" + n8 + " seq=" + this.seq + " _ackid=" + n9);
                            } else {
                                throw new SftpException(4, "ack error: startid=" + n8 + " seq=" + this.seq + " _ackid=" + n9);
                            }
                        }
                        ++n10;
                    }
                }
                l4 += (long)n4;
            } while (sftpProgressMonitor == null || sftpProgressMonitor.count(n4));
            n3 = this.seq - n8;
            while (n3 > n10) {
                if (!this.checkStatus(null, header)) break;
                ++n10;
            }
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this._sendCLOSE(byArray, header);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, exception.toString(), exception);
            }
            throw new SftpException(4, exception.toString());
        }
    }

    public OutputStream put(String string) throws SftpException {
        return this.put(string, (SftpProgressMonitor)null, 0);
    }

    public OutputStream put(String string, int n2) throws SftpException {
        return this.put(string, (SftpProgressMonitor)null, n2);
    }

    public OutputStream put(String string, SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        return this.put(string, sftpProgressMonitor, n2, 0L);
    }

    public OutputStream put(String string, final SftpProgressMonitor sftpProgressMonitor, int n2, long l2) throws SftpException {
        string = this.remoteAbsolutePath(string);
        try {
            Object object;
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (this.isRemoteDir(string)) {
                throw new SftpException(4, string + " is a directory");
            }
            long l3 = 0L;
            if (n2 == 1 || n2 == 2) {
                try {
                    object = this._stat(string);
                    l3 = ((SftpATTRS)object).getSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n2 == 0) {
                this.sendOPENW(string.getBytes());
            } else {
                this.sendOPENA(string.getBytes());
            }
            object = new Header();
            object = this.header(this.buf, (Header)object);
            int n3 = ((Header)object).length;
            int n4 = ((Header)object).type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101 && n4 != 102) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                int n5 = this.buf.getInt();
                this.throwStatusError(this.buf, n5);
            }
            final byte[] byArray = this.buf.getString();
            if (n2 == 1 || n2 == 2) {
                l2 += l3;
            }
            final long[] lArray = new long[]{l2};
            OutputStream outputStream = new OutputStream(){
                private boolean init = true;
                private boolean isClosed = false;
                private int[] ackid = new int[1];
                private int startid = 0;
                private int _ackid = 0;
                private int ackcount = 0;
                private int writecount = 0;
                private Header header = new Header();
                byte[] _data = new byte[1];

                public void write(byte[] byArray2) throws IOException {
                    this.write(byArray2, 0, byArray2.length);
                }

                public void write(byte[] byArray2, int n2, int n3) throws IOException {
                    if (this.init) {
                        this.startid = ChannelSftp.this.seq;
                        this._ackid = ChannelSftp.this.seq;
                        this.init = false;
                    }
                    if (this.isClosed) {
                        throw new IOException("stream already closed");
                    }
                    try {
                        int n4 = n3;
                        block3: while (n4 > 0) {
                            int n5 = ChannelSftp.this.sendWRITE(byArray, lArray[0], byArray2, n2, n4);
                            ++this.writecount;
                            lArray[0] = lArray[0] + (long)n5;
                            n2 += n5;
                            n4 -= n5;
                            if (ChannelSftp.this.seq - 1 != this.startid && ChannelSftp.this.io.in.available() < 1024) continue;
                            while (ChannelSftp.this.io.in.available() > 0) {
                                if (!ChannelSftp.this.checkStatus(this.ackid, this.header)) continue block3;
                                this._ackid = this.ackid[0];
                                if (this.startid > this._ackid || this._ackid > ChannelSftp.this.seq - 1) {
                                    throw new SftpException(4, "");
                                }
                                ++this.ackcount;
                            }
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n3)) {
                            this.close();
                            throw new IOException("canceled");
                        }
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.toString());
                    }
                }

                public void write(int n2) throws IOException {
                    this._data[0] = (byte)n2;
                    this.write(this._data, 0, 1);
                }

                public void flush() throws IOException {
                    if (this.isClosed) {
                        throw new IOException("stream already closed");
                    }
                    if (!this.init) {
                        try {
                            while (this.writecount > this.ackcount) {
                                if (ChannelSftp.this.checkStatus(null, this.header)) {
                                    ++this.ackcount;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (SftpException sftpException) {
                            throw new IOException(sftpException.toString());
                        }
                    }
                }

                public void close() throws IOException {
                    if (this.isClosed) {
                        return;
                    }
                    this.flush();
                    if (sftpProgressMonitor != null) {
                        sftpProgressMonitor.end();
                    }
                    try {
                        ChannelSftp.this._sendCLOSE(byArray, this.header);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.toString());
                    }
                    this.isClosed = true;
                }
            };
            return outputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, String string2) throws SftpException {
        this.get(string, string2, null, 0);
    }

    public void get(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.get(string, string2, sftpProgressMonitor, 0);
    }

    public void get(String string, String string2, SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        string = this.remoteAbsolutePath(string);
        string2 = this.localAbsolutePath(string2);
        try {
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            if (n3 == 0) {
                throw new SftpException(2, "No such file");
            }
            File file = new File(string2);
            boolean bl2 = file.isDirectory();
            StringBuffer stringBuffer = null;
            if (bl2) {
                if (!string2.endsWith(file_separator)) {
                    string2 = string2 + file_separator;
                }
                stringBuffer = new StringBuffer(string2);
            } else if (n3 > 1) {
                throw new SftpException(4, "Copying multiple files, but destination is missing or a file.");
            }
            int n4 = 0;
            while (n4 < n3) {
                String string3 = (String)vector.elementAt(n4);
                SftpATTRS sftpATTRS = this._stat(string3);
                if (sftpATTRS.isDir()) {
                    throw new SftpException(4, "not supported to get directory " + string3);
                }
                String string4 = null;
                if (bl2) {
                    int n5 = string3.lastIndexOf(47);
                    if (n5 == -1) {
                        stringBuffer.append(string3);
                    } else {
                        stringBuffer.append(string3.substring(n5 + 1));
                    }
                    string4 = stringBuffer.toString();
                    stringBuffer.delete(string2.length(), string4.length());
                } else {
                    string4 = string2;
                }
                if (n2 == 1) {
                    long l2 = sftpATTRS.getSize();
                    long l3 = new File(string4).length();
                    if (l3 > l2) {
                        throw new SftpException(4, "failed to resume for " + string4);
                    }
                    if (l3 == l2) {
                        return;
                    }
                }
                if (sftpProgressMonitor != null) {
                    sftpProgressMonitor.init(1, string3, string4, sftpATTRS.getSize());
                    if (n2 == 1) {
                        sftpProgressMonitor.count(new File(string4).length());
                    }
                }
                FileOutputStream fileOutputStream = null;
                fileOutputStream = n2 == 0 ? new FileOutputStream(string4) : new FileOutputStream(string4, true);
                this._get(string3, fileOutputStream, sftpProgressMonitor, n2, new File(string4).length());
                fileOutputStream.close();
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, OutputStream outputStream) throws SftpException {
        this.get(string, outputStream, null, 0, 0L);
    }

    public void get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        this.get(string, outputStream, sftpProgressMonitor, 0, 0L);
    }

    public void get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor, int n2, long l2) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (sftpProgressMonitor != null) {
                SftpATTRS sftpATTRS = this._stat(string);
                sftpProgressMonitor.init(1, string, "??", sftpATTRS.getSize());
                if (n2 == 1) {
                    sftpProgressMonitor.count(l2);
                }
            }
            this._get(string, outputStream, sftpProgressMonitor, n2, l2);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private void _get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor, int n2, long l2) throws SftpException {
        try {
            byte[] byArray;
            Header header;
            block14: {
                int n3;
                int n4;
                this.sendOPENR(string.getBytes());
                header = new Header();
                header = this.header(this.buf, header);
                int n5 = header.length;
                int n6 = header.type;
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, n5);
                if (n6 != 101 && n6 != 102) {
                    throw new SftpException(4, "");
                }
                if (n6 == 101) {
                    int n7 = this.buf.getInt();
                    this.throwStatusError(this.buf, n7);
                }
                byArray = this.buf.getString();
                long l3 = 0L;
                if (n2 == 1) {
                    l3 += l2;
                }
                int n8 = 0;
                block2: while (true) {
                    int n9;
                    n8 = this.buf.buffer.length - 13;
                    if (this.server_version == 0) {
                        n8 = 1024;
                    }
                    this.sendREAD(byArray, l3, n8);
                    header = this.header(this.buf, header);
                    n5 = header.length;
                    n6 = header.type;
                    if (n6 == 101) {
                        this.buf.rewind();
                        this.fill(this.buf.buffer, 0, n5);
                        n4 = this.buf.getInt();
                        if (n4 == 1) break block14;
                        this.throwStatusError(this.buf, n4);
                    }
                    if (n6 != 103) break block14;
                    this.buf.rewind();
                    this.fill(this.buf.buffer, 0, 4);
                    n5 -= 4;
                    n3 = n4 = this.buf.getInt();
                    do {
                        if (n3 <= 0) continue block2;
                        int n10 = n3;
                        if (n10 > this.buf.buffer.length) {
                            n10 = this.buf.buffer.length;
                        }
                        if ((n4 = this.io.in.read(this.buf.buffer, 0, n10)) < 0) break block14;
                        n9 = n4;
                        outputStream.write(this.buf.buffer, 0, n9);
                        l3 += (long)n9;
                        n3 -= n9;
                    } while (sftpProgressMonitor == null || sftpProgressMonitor.count(n9));
                    break;
                }
                while (n3 > 0) {
                    n4 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length < n3 ? this.buf.buffer.length : n3);
                    if (n4 <= 0) break;
                    n3 -= n4;
                }
            }
            outputStream.flush();
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this._sendCLOSE(byArray, header);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public InputStream get(String string) throws SftpException {
        return this.get(string, null, 0);
    }

    public InputStream get(String string, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        return this.get(string, sftpProgressMonitor, 0);
    }

    public InputStream get(String string, int n2) throws SftpException {
        return this.get(string, null, n2);
    }

    public InputStream get(String string, final SftpProgressMonitor sftpProgressMonitor, int n2) throws SftpException {
        if (n2 == 1) {
            throw new SftpException(4, "faile to resume from " + string);
        }
        string = this.remoteAbsolutePath(string);
        try {
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            SftpATTRS sftpATTRS = this._stat(string);
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.init(1, string, "??", sftpATTRS.getSize());
            }
            this.sendOPENR(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            int n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101 && n4 != 102) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                int n5 = this.buf.getInt();
                this.throwStatusError(this.buf, n5);
            }
            final byte[] byArray = this.buf.getString();
            InputStream inputStream = new InputStream(){
                long offset = 0L;
                boolean closed = false;
                int rest_length = 0;
                byte[] _data = new byte[1];
                byte[] rest_byte = new byte[1024];
                Header header = new Header();

                public int read() throws IOException {
                    if (this.closed) {
                        return -1;
                    }
                    int n2 = this.read(this._data, 0, 1);
                    if (n2 == -1) {
                        return -1;
                    }
                    return this._data[0] & 0xFF;
                }

                public int read(byte[] byArray2) throws IOException {
                    if (this.closed) {
                        return -1;
                    }
                    return this.read(byArray2, 0, byArray2.length);
                }

                public int read(byte[] byArray2, int n2, int n3) throws IOException {
                    if (this.closed) {
                        return -1;
                    }
                    if (byArray2 == null) {
                        throw new NullPointerException();
                    }
                    if (n2 < 0 || n3 < 0 || n2 + n3 > byArray2.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (n3 == 0) {
                        return 0;
                    }
                    if (this.rest_length > 0) {
                        int n4 = this.rest_length;
                        if (n4 > n3) {
                            n4 = n3;
                        }
                        System.arraycopy(this.rest_byte, 0, byArray2, n2, n4);
                        if (n4 != this.rest_length) {
                            System.arraycopy(this.rest_byte, n4, this.rest_byte, 0, this.rest_length - n4);
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n4)) {
                            this.close();
                            return -1;
                        }
                        this.rest_length -= n4;
                        return n4;
                    }
                    if (((ChannelSftp)ChannelSftp.this).buf.buffer.length - 13 < n3) {
                        n3 = ((ChannelSftp)ChannelSftp.this).buf.buffer.length - 13;
                    }
                    if (ChannelSftp.this.server_version == 0 && n3 > 1024) {
                        n3 = 1024;
                    }
                    try {
                        ChannelSftp.this.sendREAD(byArray, this.offset, n3);
                    }
                    catch (Exception exception) {
                        throw new IOException("error");
                    }
                    this.header = ChannelSftp.this.header(ChannelSftp.this.buf, this.header);
                    this.rest_length = this.header.length;
                    int n5 = this.header.type;
                    int n6 = this.header.rid;
                    if (n5 != 101 && n5 != 103) {
                        throw new IOException("error");
                    }
                    if (n5 == 101) {
                        ChannelSftp.this.buf.rewind();
                        ChannelSftp.this.fill(((ChannelSftp)ChannelSftp.this).buf.buffer, 0, this.rest_length);
                        int n7 = ChannelSftp.this.buf.getInt();
                        this.rest_length = 0;
                        if (n7 == 1) {
                            this.close();
                            return -1;
                        }
                        throw new IOException("error");
                    }
                    ChannelSftp.this.buf.rewind();
                    ChannelSftp.this.fill(((ChannelSftp)ChannelSftp.this).buf.buffer, 0, 4);
                    int n8 = ChannelSftp.this.buf.getInt();
                    this.rest_length -= 4;
                    this.offset += (long)this.rest_length;
                    int n9 = n8;
                    if (n9 > 0) {
                        int n10 = this.rest_length;
                        if (n10 > n3) {
                            n10 = n3;
                        }
                        if ((n8 = ChannelSftp.this.io.in.read(byArray2, n2, n10)) < 0) {
                            return -1;
                        }
                        this.rest_length -= n8;
                        if (this.rest_length > 0) {
                            if (this.rest_byte.length < this.rest_length) {
                                this.rest_byte = new byte[this.rest_length];
                            }
                            int n11 = 0;
                            int n12 = this.rest_length;
                            while (n12 > 0) {
                                int n13 = ChannelSftp.this.io.in.read(this.rest_byte, n11, n12);
                                if (n13 <= 0) break;
                                n11 += n13;
                                n12 -= n13;
                            }
                        }
                        if (sftpProgressMonitor != null && !sftpProgressMonitor.count(n8)) {
                            this.close();
                            return -1;
                        }
                        return n8;
                    }
                    return 0;
                }

                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    if (sftpProgressMonitor != null) {
                        sftpProgressMonitor.end();
                    }
                    try {
                        ChannelSftp.this._sendCLOSE(byArray, this.header);
                    }
                    catch (Exception exception) {
                        throw new IOException("error");
                    }
                }
            };
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public Vector ls(String string) throws SftpException {
        try {
            String string2 = string = this.remoteAbsolutePath(string);
            byte[] byArray = null;
            SftpATTRS sftpATTRS = null;
            if (this.isPattern(string2) || (sftpATTRS = this.stat(string2)) != null && !sftpATTRS.isDir()) {
                int n2 = string.lastIndexOf(47);
                string2 = string.substring(0, n2 == 0 ? 1 : n2);
                byArray = string.substring(n2 + 1).getBytes();
            }
            this.sendOPENDIR(string2.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            int n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101 && n4 != 102) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                int n5 = this.buf.getInt();
                this.throwStatusError(this.buf, n5);
            }
            byte[] byArray2 = this.buf.getString();
            Vector<LsEntry> vector = new Vector<LsEntry>();
            block2: while (true) {
                int n6;
                this.sendREADDIR(byArray2);
                header = this.header(this.buf, header);
                n3 = header.length;
                n4 = header.type;
                if (n4 != 101 && n4 != 104) {
                    throw new SftpException(4, "");
                }
                if (n4 == 101) {
                    this.buf.rewind();
                    this.fill(this.buf.buffer, 0, n3);
                    n6 = this.buf.getInt();
                    if (n6 == 1) break;
                    this.throwStatusError(this.buf, n6);
                }
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, 4);
                n3 -= 4;
                n6 = this.buf.getInt();
                this.buf.reset();
                while (true) {
                    if (n6 <= 0) continue block2;
                    if (n3 > 0) {
                        this.buf.shift();
                        int n7 = this.buf.buffer.length > this.buf.index + n3 ? n3 : this.buf.buffer.length - this.buf.index;
                        int n8 = this.fill(this.buf.buffer, this.buf.index, n7);
                        this.buf.index += n8;
                        n3 -= n8;
                    }
                    byte[] byArray3 = this.buf.getString();
                    byte[] byArray4 = this.buf.getString();
                    String string3 = new String(byArray4);
                    SftpATTRS sftpATTRS2 = SftpATTRS.getATTR(this.buf);
                    if (byArray == null || Util.glob(byArray, byArray3)) {
                        vector.addElement(new LsEntry(new String(byArray3), string3, sftpATTRS2));
                    }
                    --n6;
                }
                break;
            }
            this._sendCLOSE(byArray2, header);
            return vector;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public String readlink(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.sendREADLINK(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 101 && n3 != 104) {
                throw new SftpException(4, "");
            }
            if (n3 == 104) {
                int n4 = this.buf.getInt();
                byte[] byArray = null;
                byte[] byArray2 = null;
                int n5 = 0;
                while (n5 < n4) {
                    byArray = this.buf.getString();
                    byArray2 = this.buf.getString();
                    SftpATTRS.getATTR(this.buf);
                    ++n5;
                }
                return new String(byArray);
            }
            int n6 = this.buf.getInt();
            this.throwStatusError(this.buf, n6);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
        return null;
    }

    public void symlink(String string, String string2) throws SftpException {
        if (this.server_version < 3) {
            throw new SftpException(4, "The remote sshd is too old to support symlink operation.");
        }
        try {
            string = this.remoteAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            if (n2 != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (this.isPattern(string2)) {
                throw new SftpException(4, vector.toString());
            }
            string2 = Util.unquote(string2);
            this.sendSYMLINK(string.getBytes(), string2.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            int n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101) {
                throw new SftpException(4, "");
            }
            int n5 = this.buf.getInt();
            if (n5 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n5);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rename(String string, String string2) throws SftpException {
        if (this.server_version < 2) {
            throw new SftpException(4, "The remote sshd is too old to support rename operation.");
        }
        try {
            string = this.remoteAbsolutePath(string);
            string2 = this.remoteAbsolutePath(string2);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            if (n2 != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            vector = this.glob_remote(string2);
            n2 = vector.size();
            if (n2 >= 2) {
                throw new SftpException(4, vector.toString());
            }
            if (n2 == 1) {
                string2 = (String)vector.elementAt(0);
            } else {
                if (this.isPattern(string2)) {
                    throw new SftpException(4, string2);
                }
                string2 = Util.unquote(string2);
            }
            this.sendRENAME(string.getBytes(), string2.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n3 = header.length;
            int n4 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n3);
            if (n4 != 101) {
                throw new SftpException(4, "");
            }
            int n5 = this.buf.getInt();
            if (n5 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n5);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rm(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            Header header = new Header();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                this.sendREMOVE(string.getBytes());
                header = this.header(this.buf, header);
                int n4 = header.length;
                int n5 = header.type;
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, n4);
                if (n5 != 101) {
                    throw new SftpException(4, "");
                }
                int n6 = this.buf.getInt();
                if (n6 != 0) {
                    this.throwStatusError(this.buf, n6);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private boolean isRemoteDir(String string) {
        try {
            this.sendSTAT(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 105) {
                return false;
            }
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS.isDir();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void chgrp(int n2, String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                string = (String)vector.elementAt(n4);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setUIDGID(sftpATTRS.uid, n2);
                this._setStat(string, sftpATTRS);
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void chown(int n2, String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                string = (String)vector.elementAt(n4);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setUIDGID(n2, sftpATTRS.gid);
                this._setStat(string, sftpATTRS);
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void chmod(int n2, String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                string = (String)vector.elementAt(n4);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setPERMISSIONS(n2);
                this._setStat(string, sftpATTRS);
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void setMtime(String string, int n2) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                string = (String)vector.elementAt(n4);
                SftpATTRS sftpATTRS = this._stat(string);
                sftpATTRS.setFLAGS(0);
                sftpATTRS.setACMODTIME(sftpATTRS.getATime(), n2);
                this._setStat(string, sftpATTRS);
                ++n4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void rmdir(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            Header header = new Header();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                this.sendRMDIR(string.getBytes());
                header = this.header(this.buf, header);
                int n4 = header.length;
                int n5 = header.type;
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, n4);
                if (n5 != 101) {
                    throw new SftpException(4, "");
                }
                int n6 = this.buf.getInt();
                if (n6 != 0) {
                    this.throwStatusError(this.buf, n6);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void mkdir(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            this.sendMKDIR(string.getBytes(), null);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            int n4 = this.buf.getInt();
            if (n4 == 0) {
                return;
            }
            this.throwStatusError(this.buf, n4);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS stat(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            return this._stat(string);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpATTRS _stat(String string) throws SftpException {
        try {
            this.sendSTAT(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 105) {
                if (n3 == 101) {
                    int n4 = this.buf.getInt();
                    this.throwStatusError(this.buf, n4);
                }
                throw new SftpException(4, "");
            }
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS lstat(String string) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            return this._lstat(string);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private SftpATTRS _lstat(String string) throws SftpException {
        try {
            this.sendLSTAT(string.getBytes());
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 105) {
                if (n3 == 101) {
                    int n4 = this.buf.getInt();
                    this.throwStatusError(this.buf, n4);
                }
                throw new SftpException(4, "");
            }
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public void setStat(String string, SftpATTRS sftpATTRS) throws SftpException {
        try {
            string = this.remoteAbsolutePath(string);
            Vector vector = this.glob_remote(string);
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                string = (String)vector.elementAt(n3);
                this._setStat(string, sftpATTRS);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    private void _setStat(String string, SftpATTRS sftpATTRS) throws SftpException {
        try {
            this.sendSETSTAT(string.getBytes(), sftpATTRS);
            Header header = new Header();
            header = this.header(this.buf, header);
            int n2 = header.length;
            int n3 = header.type;
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, n2);
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            int n4 = this.buf.getInt();
            if (n4 != 0) {
                this.throwStatusError(this.buf, n4);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            if (exception instanceof Throwable) {
                throw new SftpException(4, "", exception);
            }
            throw new SftpException(4, "");
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public String lpwd() {
        return this.lcwd;
    }

    public String version() {
        return this.version;
    }

    public String getHome() {
        return this.home;
    }

    private void read(byte[] byArray, int n2, int n3) throws IOException, SftpException {
        int n4 = 0;
        while (n3 > 0) {
            n4 = this.io.in.read(byArray, n2, n3);
            if (n4 <= 0) {
                throw new SftpException(4, "");
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    private boolean checkStatus(int[] nArray, Header header) throws IOException, SftpException {
        header = this.header(this.buf, header);
        int n2 = header.length;
        int n3 = header.type;
        if (nArray != null) {
            nArray[0] = header.rid;
        }
        this.buf.rewind();
        this.fill(this.buf.buffer, 0, n2);
        if (n3 != 101) {
            throw new SftpException(4, "");
        }
        int n4 = this.buf.getInt();
        if (n4 != 0) {
            this.throwStatusError(this.buf, n4);
        }
        return true;
    }

    private boolean _sendCLOSE(byte[] byArray, Header header) throws Exception {
        this.sendCLOSE(byArray);
        return this.checkStatus(null, header);
    }

    private void sendINIT() throws Exception {
        this.packet.reset();
        this.putHEAD((byte)1, 5);
        this.buf.putInt(3);
        this.session.write(this.packet, this, 9);
    }

    private void sendREALPATH(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)16, byArray);
    }

    private void sendSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)17, byArray);
    }

    private void sendLSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)7, byArray);
    }

    private void sendFSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)8, byArray);
    }

    private void sendSETSTAT(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)9, 9 + byArray.length + sftpATTRS.length());
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        sftpATTRS.dump(this.buf);
        this.session.write(this.packet, this, 9 + byArray.length + sftpATTRS.length() + 4);
    }

    private void sendREMOVE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)13, byArray);
    }

    private void sendMKDIR(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)14, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4));
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        if (sftpATTRS != null) {
            sftpATTRS.dump(this.buf);
        } else {
            this.buf.putInt(0);
        }
        this.session.write(this.packet, this, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4) + 4);
    }

    private void sendRMDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)15, byArray);
    }

    private void sendSYMLINK(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)20, byArray, byArray2);
    }

    private void sendREADLINK(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)19, byArray);
    }

    private void sendOPENDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)11, byArray);
    }

    private void sendREADDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)12, byArray);
    }

    private void sendRENAME(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)18, byArray, byArray2);
    }

    private void sendCLOSE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)4, byArray);
    }

    private void sendOPENR(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 1);
    }

    private void sendOPENW(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 26);
    }

    private void sendOPENA(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 10);
    }

    private void sendOPEN(byte[] byArray, int n2) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)3, 17 + byArray.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putInt(n2);
        this.buf.putInt(0);
        this.session.write(this.packet, this, 17 + byArray.length + 4);
    }

    private void sendPacketPath(byte by2, byte[] byArray) throws Exception {
        this.packet.reset();
        this.putHEAD(by2, 9 + byArray.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.session.write(this.packet, this, 9 + byArray.length + 4);
    }

    private void sendPacketPath(byte by2, byte[] byArray, byte[] byArray2) throws Exception {
        this.packet.reset();
        this.putHEAD(by2, 13 + byArray.length + byArray2.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putString(byArray2);
        this.session.write(this.packet, this, 13 + byArray.length + byArray2.length + 4);
    }

    private int sendWRITE(byte[] byArray, long l2, byte[] byArray2, int n2, int n3) throws Exception {
        int n4 = n3;
        this.packet.reset();
        if (this.buf.buffer.length < this.buf.index + 13 + 21 + byArray.length + n3 + 32 + 20) {
            n4 = this.buf.buffer.length - (this.buf.index + 13 + 21 + byArray.length + 32 + 20);
        }
        this.putHEAD((byte)6, 21 + byArray.length + n4);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putLong(l2);
        if (this.buf.buffer != byArray2) {
            this.buf.putString(byArray2, n2, n4);
        } else {
            this.buf.putInt(n4);
            this.buf.skip(n4);
        }
        this.session.write(this.packet, this, 21 + byArray.length + n4 + 4);
        return n4;
    }

    private void sendREAD(byte[] byArray, long l2, int n2) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)5, 21 + byArray.length);
        this.buf.putInt(this.seq++);
        this.buf.putString(byArray);
        this.buf.putLong(l2);
        this.buf.putInt(n2);
        this.session.write(this.packet, this, 21 + byArray.length + 4);
    }

    private void putHEAD(byte by2, int n2) throws Exception {
        this.buf.putByte((byte)94);
        this.buf.putInt(this.recipient);
        this.buf.putInt(n2 + 4);
        this.buf.putInt(n2);
        this.buf.putByte(by2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private Vector glob_remote(String string) throws Exception {
        byte[] byArray;
        Vector<String> vector = new Vector<String>();
        byte[] byArray2 = string.getBytes();
        if (!this.isPattern(byArray2)) {
            vector.addElement(Util.unquote(string));
            return vector;
        }
        int n2 = byArray2.length - 1;
        while (n2 >= 0) {
            if (byArray2[n2] == 47) break;
            --n2;
        }
        if (n2 < 0) {
            vector.addElement(Util.unquote(string));
            return vector;
        }
        if (n2 == 0) {
            byArray = new byte[]{47};
        } else {
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        byte[] byArray3 = new byte[byArray2.length - n2 - 1];
        System.arraycopy(byArray2, n2 + 1, byArray3, 0, byArray3.length);
        this.sendOPENDIR(byArray);
        Header header = new Header();
        header = this.header(this.buf, header);
        int n3 = header.length;
        int n4 = header.type;
        this.buf.rewind();
        this.fill(this.buf.buffer, 0, n3);
        if (n4 != 101 && n4 != 102) {
            throw new SftpException(4, "");
        }
        if (n4 == 101) {
            n2 = this.buf.getInt();
            this.throwStatusError(this.buf, n2);
        }
        byte[] byArray4 = this.buf.getString();
        block1: while (true) {
            this.sendREADDIR(byArray4);
            header = this.header(this.buf, header);
            n3 = header.length;
            n4 = header.type;
            if (n4 != 101 && n4 != 104) {
                throw new SftpException(4, "");
            }
            if (n4 == 101) {
                this.buf.rewind();
                this.fill(this.buf.buffer, 0, n3);
                if (this._sendCLOSE(byArray4, header)) return vector;
                return null;
            }
            this.buf.rewind();
            this.fill(this.buf.buffer, 0, 4);
            n3 -= 4;
            int n5 = this.buf.getInt();
            this.buf.reset();
            boolean bl2 = true;
            do {
                if (bl2 && !(bl2 = false)) {
                    if (true) continue;
                }
                if (n3 > 0) {
                    this.buf.shift();
                    int n6 = this.buf.buffer.length > this.buf.index + n3 ? n3 : this.buf.buffer.length - this.buf.index;
                    n2 = this.io.in.read(this.buf.buffer, this.buf.index, n6);
                    if (n2 <= 0) continue block1;
                    this.buf.index += n2;
                    n3 -= n2;
                }
                byte[] byArray5 = this.buf.getString();
                byte[] byArray6 = this.buf.getString();
                SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
                if (Util.glob(byArray3, byArray5)) {
                    vector.addElement(new String(byArray) + "/" + new String(byArray5));
                }
                --n5;
            } while (n5 > 0);
        }
    }

    private boolean isPattern(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            if (byArray[n2] == 42 || byArray[n2] == 63) {
                if (n2 <= 0 || byArray[n2 - 1] != 92) break;
                --n2;
            }
            --n2;
        }
        return n2 >= 0;
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_local(String var1_1) throws Exception {
        var2_2 = new Vector<String>();
        var3_3 = var1_1.getBytes();
        var4_4 = var3_3.length - 1;
        while (var4_4 >= 0) {
            if (var3_3[var4_4] == 42 || var3_3[var4_4] == 63) break;
            --var4_4;
        }
        if (var4_4 >= 0) ** GOTO lbl13
        var2_2.addElement(var1_1);
        return var2_2;
        while (var3_3[var4_4] != ChannelSftp.file_separatorc) {
            --var4_4;
lbl13:
            // 2 sources

            if (var4_4 >= 0) continue;
        }
        if (var4_4 < 0) {
            var2_2.addElement(var1_1);
            return var2_2;
        }
        if (var4_4 == 0) {
            var5_5 = new byte[]{(byte)ChannelSftp.file_separatorc};
        } else {
            var5_5 = new byte[var4_4];
            System.arraycopy(var3_3, 0, var5_5, 0, var4_4);
        }
        var6_6 = new byte[var3_3.length - var4_4 - 1];
        System.arraycopy(var3_3, var4_4 + 1, var6_6, 0, var6_6.length);
        try {
            var7_7 = new File(new String(var5_5)).list();
            var8_9 = 0;
            while (var8_9 < var7_7.length) {
                if (Util.glob(var6_6, var7_7[var8_9].getBytes())) {
                    var2_2.addElement(new String(var5_5) + ChannelSftp.file_separator + var7_7[var8_9]);
                }
                ++var8_9;
            }
        }
        catch (Exception var7_8) {
            // empty catch block
        }
        return var2_2;
    }

    private void throwStatusError(Buffer buffer, int n2) throws SftpException {
        if (this.server_version >= 3) {
            byte[] byArray = buffer.getString();
            throw new SftpException(n2, new String(byArray));
        }
        throw new SftpException(n2, "Failure");
    }

    private static boolean isLocalAbsolutePath(String string) {
        return new File(string).isAbsolute();
    }

    public void disconnect() {
        this.clearRunningThreads();
        super.disconnect();
    }

    protected synchronized void addRunningThread(Thread thread) {
        if (this.threadList == null) {
            this.threadList = new Vector();
        }
        this.threadList.add(thread);
    }

    protected synchronized void clearRunningThreads() {
        if (this.threadList == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.threadList.size()) {
            Thread thread = (Thread)this.threadList.get(n2);
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
            }
            ++n2;
        }
        this.threadList.clear();
    }

    private boolean isPattern(String string) {
        return string.indexOf("*") != -1 || string.indexOf("?") != -1;
    }

    private int fill(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = n2;
        while (n3 > 0) {
            n4 = this.io.in.read(byArray, n2, n3);
            if (n4 <= 0) {
                throw new IOException("inputstream is closed");
            }
            n2 += n4;
            n3 -= n4;
        }
        return n2 - n5;
    }

    private void skip(long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = this.io.in.skip(l2);
            if (l3 <= 0L) break;
            l2 -= l3;
        }
    }

    private Header header(Buffer buffer, Header header) throws IOException {
        buffer.rewind();
        int n2 = this.fill(buffer.buffer, 0, 9);
        header.length = buffer.getInt() - 5;
        header.type = buffer.getByte() & 0xFF;
        header.rid = buffer.getInt();
        return header;
    }

    private String remoteAbsolutePath(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        if (this.cwd.endsWith("/")) {
            return this.cwd + string;
        }
        return this.cwd + "/" + string;
    }

    private String localAbsolutePath(String string) {
        if (ChannelSftp.isLocalAbsolutePath(string)) {
            return string;
        }
        if (this.lcwd.endsWith(file_separator)) {
            return this.lcwd + string;
        }
        return this.lcwd + file_separator + string;
    }

    public class LsEntry {
        private String filename;
        private String longname;
        private SftpATTRS attrs;

        LsEntry(String string, String string2, SftpATTRS sftpATTRS) {
            this.setFilename(string);
            this.setLongname(string2);
            this.setAttrs(sftpATTRS);
        }

        public String getFilename() {
            return this.filename;
        }

        void setFilename(String string) {
            this.filename = string;
        }

        public String getLongname() {
            return this.longname;
        }

        void setLongname(String string) {
            this.longname = string;
        }

        public SftpATTRS getAttrs() {
            return this.attrs;
        }

        void setAttrs(SftpATTRS sftpATTRS) {
            this.attrs = sftpATTRS;
        }

        public String toString() {
            return this.longname;
        }
    }

    class Header {
        int length;
        int type;
        int rid;

        Header() {
        }
    }
}

