/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ServiceStateVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateVariableResponseParser
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(StateVariableResponseParser.class);
    private static final String SOAP_FAULT_EL = "Fault";
    private ServiceStateVariable stateVar;
    private boolean faultResponse = false;
    private UPNPResponseException msgEx;
    private boolean readFaultCode = false;
    private boolean readFaultString = false;
    private boolean readErrorCode = false;
    private boolean readErrorDescription = false;
    private boolean parseStateVar = false;
    private StateVariableResponse result;

    protected StateVariableResponseParser(ServiceStateVariable stateVar) {
        this.stateVar = stateVar;
    }

    protected UPNPResponseException getUPNPResponseException() {
        return this.msgEx;
    }

    protected StateVariableResponse getStateVariableResponse() {
        return this.result;
    }

    public void characters(char[] ch2, int start, int length) {
        if (this.parseStateVar) {
            String origChars = this.result.stateVariableValue;
            String newChars = new String(ch2, start, length);
            this.result.stateVariableValue = origChars == null ? newChars : origChars + newChars;
        } else if (this.readFaultCode) {
            this.msgEx.faultCode = new String(ch2, start, length);
            this.readFaultCode = false;
        } else if (this.readFaultString) {
            this.msgEx.faultString = new String(ch2, start, length);
            this.readFaultString = false;
        } else if (this.readErrorCode) {
            String code = new String(ch2, start, length);
            try {
                this.msgEx.detailErrorCode = Integer.parseInt(code);
            }
            catch (Throwable ex) {
                log.debug("Error during returned error code " + code + " parsing");
            }
            this.readErrorCode = false;
        } else if (this.readErrorDescription) {
            this.msgEx.detailErrorDescription = new String(ch2, start, length);
            this.readErrorDescription = false;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.faultResponse) {
            if (localName.equals("faultcode")) {
                this.readFaultCode = true;
            } else if (localName.equals("faultstring")) {
                this.readFaultString = true;
            } else if (localName.equals("errorCode")) {
                this.readErrorCode = true;
            } else if (localName.equals("errorDescription")) {
                this.readErrorDescription = true;
            }
        } else if (localName.equals(SOAP_FAULT_EL)) {
            this.msgEx = new UPNPResponseException();
            this.faultResponse = true;
        } else if (localName.equals("return") || localName.equals("varName")) {
            this.parseStateVar = true;
            this.result = new StateVariableResponse();
            this.result.stateVar = this.stateVar;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("return") || localName.equals("varName")) {
            this.parseStateVar = false;
        }
    }
}

