/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sbbi.upnp.services.ServiceActionArgument;
import net.sbbi.upnp.services.UPNPService;

public class ServiceAction {
    protected String name;
    protected UPNPService parent;
    private List orderedActionArguments;
    private List orderedInputActionArguments;
    private List orderedOutputActionArguments;
    private List orderedInputActionArgumentsNames;
    private List orderedOutputActionArgumentsNames;

    protected ServiceAction() {
    }

    public UPNPService getParent() {
        return this.parent;
    }

    public List getActionArguments() {
        return this.orderedActionArguments;
    }

    public ServiceActionArgument getActionArgument(String argumentName) {
        if (this.orderedActionArguments == null) {
            return null;
        }
        Iterator i2 = this.orderedActionArguments.iterator();
        while (i2.hasNext()) {
            ServiceActionArgument arg = (ServiceActionArgument)i2.next();
            if (!arg.getName().equals(argumentName)) continue;
            return arg;
        }
        return null;
    }

    protected void setActionArguments(List orderedActionArguments) {
        this.orderedActionArguments = orderedActionArguments;
        this.orderedInputActionArguments = this.getListForActionArgument(orderedActionArguments, "in");
        this.orderedOutputActionArguments = this.getListForActionArgument(orderedActionArguments, "out");
        this.orderedInputActionArgumentsNames = this.getListForActionArgumentNames(orderedActionArguments, "in");
        this.orderedOutputActionArgumentsNames = this.getListForActionArgumentNames(orderedActionArguments, "out");
    }

    public List getInputActionArguments() {
        return this.orderedInputActionArguments;
    }

    public ServiceActionArgument getInputActionArgument(String argumentName) {
        if (this.orderedInputActionArguments == null) {
            return null;
        }
        Iterator i2 = this.orderedInputActionArguments.iterator();
        while (i2.hasNext()) {
            ServiceActionArgument arg = (ServiceActionArgument)i2.next();
            if (!arg.getName().equals(argumentName)) continue;
            return arg;
        }
        return null;
    }

    public List getOutputActionArguments() {
        return this.orderedOutputActionArguments;
    }

    public ServiceActionArgument getOutputActionArgument(String argumentName) {
        if (this.orderedOutputActionArguments == null) {
            return null;
        }
        Iterator i2 = this.orderedOutputActionArguments.iterator();
        while (i2.hasNext()) {
            ServiceActionArgument arg = (ServiceActionArgument)i2.next();
            if (!arg.getName().equals(argumentName)) continue;
            return arg;
        }
        return null;
    }

    public List getInputActionArgumentsNames() {
        return this.orderedInputActionArgumentsNames;
    }

    public List getOutputActionArgumentsNames() {
        return this.orderedOutputActionArgumentsNames;
    }

    public String getName() {
        return this.name;
    }

    private List getListForActionArgument(List args, String direction) {
        if (args == null) {
            return null;
        }
        ArrayList<ServiceActionArgument> rtrVal = new ArrayList<ServiceActionArgument>();
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            ServiceActionArgument actArg = (ServiceActionArgument)itr.next();
            if (actArg.getDirection() != direction) continue;
            rtrVal.add(actArg);
        }
        if (rtrVal.size() == 0) {
            rtrVal = null;
        }
        return rtrVal;
    }

    private List getListForActionArgumentNames(List args, String direction) {
        if (args == null) {
            return null;
        }
        ArrayList<String> rtrVal = new ArrayList<String>();
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            ServiceActionArgument actArg = (ServiceActionArgument)itr.next();
            if (actArg.getDirection() != direction) continue;
            rtrVal.add(actArg.getName());
        }
        if (rtrVal.size() == 0) {
            rtrVal = null;
        }
        return rtrVal;
    }
}

