/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sbbi.upnp.JXPathParser;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.services.ServiceAction;
import net.sbbi.upnp.services.ServiceActionArgument;
import net.sbbi.upnp.services.ServiceStateVariable;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.xml.DocumentContainer;

public class UPNPService {
    protected String serviceType;
    protected String serviceId;
    private int specVersionMajor;
    private int specVersionMinor;
    protected URL SCPDURL;
    protected String SCPDURLData;
    protected URL controlURL;
    protected URL eventSubURL;
    protected UPNPDevice serviceOwnerDevice;
    protected Map UPNPServiceActions;
    protected Map UPNPServiceStateVariables;
    private String USN;
    private boolean parsedSCPD = false;
    private DocumentContainer UPNPService;

    public UPNPService(JXPathContext serviceCtx, URL baseDeviceURL, UPNPDevice serviceOwnerDevice) throws MalformedURLException {
        this.serviceOwnerDevice = serviceOwnerDevice;
        this.serviceType = (String)serviceCtx.getValue("serviceType");
        this.serviceId = (String)serviceCtx.getValue("serviceId");
        this.SCPDURL = UPNPRootDevice.getURL((String)serviceCtx.getValue("SCPDURL"), baseDeviceURL);
        this.controlURL = UPNPRootDevice.getURL((String)serviceCtx.getValue("controlURL"), baseDeviceURL);
        this.eventSubURL = UPNPRootDevice.getURL((String)serviceCtx.getValue("eventSubURL"), baseDeviceURL);
        this.USN = serviceOwnerDevice.getUDN().concat("::").concat(this.serviceType);
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getUSN() {
        return this.USN;
    }

    public URL getSCPDURL() {
        return this.SCPDURL;
    }

    public URL getControlURL() {
        return this.controlURL;
    }

    public URL getEventSubURL() {
        return this.eventSubURL;
    }

    public int getSpecVersionMajor() {
        this.lazyInitiate();
        return this.specVersionMajor;
    }

    public int getSpecVersionMinor() {
        this.lazyInitiate();
        return this.specVersionMinor;
    }

    public UPNPDevice getServiceOwnerDevice() {
        return this.serviceOwnerDevice;
    }

    public ServiceAction getUPNPServiceAction(String actionName) {
        this.lazyInitiate();
        return (ServiceAction)this.UPNPServiceActions.get(actionName);
    }

    public ServiceStateVariable getUPNPServiceStateVariable(String stateVariableName) {
        this.lazyInitiate();
        return (ServiceStateVariable)this.UPNPServiceStateVariables.get(stateVariableName);
    }

    public Iterator getAvailableActionsName() {
        this.lazyInitiate();
        return this.UPNPServiceActions.keySet().iterator();
    }

    public int getAvailableActionsSize() {
        this.lazyInitiate();
        return this.UPNPServiceActions.keySet().size();
    }

    public Iterator getAvailableStateVariableName() {
        this.lazyInitiate();
        return this.UPNPServiceStateVariables.keySet().iterator();
    }

    public int getAvailableStateVariableSize() {
        this.lazyInitiate();
        return this.UPNPServiceStateVariables.keySet().size();
    }

    private void parseSCPD() {
        try {
            DocumentContainer.registerXMLParser("DOM", new JXPathParser());
            this.UPNPService = new DocumentContainer(this.SCPDURL, "DOM");
            JXPathContext context = JXPathContext.newContext(this);
            Pointer rootPtr = context.getPointer("UPNPService/scpd");
            JXPathContext rootCtx = context.getRelativeContext(rootPtr);
            this.specVersionMajor = Integer.parseInt((String)rootCtx.getValue("specVersion/major"));
            this.specVersionMinor = Integer.parseInt((String)rootCtx.getValue("specVersion/minor"));
            this.parseServiceStateVariables(rootCtx);
            Pointer actionsListPtr = rootCtx.getPointer("actionList");
            JXPathContext actionsListCtx = context.getRelativeContext(actionsListPtr);
            Double arraySize = (Double)actionsListCtx.getValue("count( action )");
            this.UPNPServiceActions = new HashMap();
            for (int i2 = 1; i2 <= arraySize.intValue(); ++i2) {
                ServiceAction action = new ServiceAction();
                action.name = (String)actionsListCtx.getValue("action[" + i2 + "]/name");
                action.parent = this;
                Pointer argumentListPtr = null;
                try {
                    argumentListPtr = actionsListCtx.getPointer("action[" + i2 + "]/argumentList");
                }
                catch (JXPathException ex) {
                    // empty catch block
                }
                if (argumentListPtr != null) {
                    JXPathContext argumentListCtx = actionsListCtx.getRelativeContext(argumentListPtr);
                    Double arraySizeArgs = (Double)argumentListCtx.getValue("count( argument )");
                    ArrayList<ServiceActionArgument> orderedActionArguments = new ArrayList<ServiceActionArgument>();
                    for (int z2 = 1; z2 <= arraySizeArgs.intValue(); ++z2) {
                        ServiceActionArgument arg = new ServiceActionArgument();
                        arg.name = (String)argumentListCtx.getValue("argument[" + z2 + "]/name");
                        String direction = (String)argumentListCtx.getValue("argument[" + z2 + "]/direction");
                        arg.direction = direction.equals("in") ? "in" : "out";
                        String stateVarName = (String)argumentListCtx.getValue("argument[" + z2 + "]/relatedStateVariable");
                        ServiceStateVariable stateVar = (ServiceStateVariable)this.UPNPServiceStateVariables.get(stateVarName);
                        if (stateVar == null) {
                            throw new IllegalArgumentException("Unable to find any state variable named " + stateVarName + " for service " + this.getServiceId() + " action " + action.name + " argument " + arg.name);
                        }
                        arg.relatedStateVariable = stateVar;
                        orderedActionArguments.add(arg);
                    }
                    if (arraySizeArgs.intValue() > 0) {
                        action.setActionArguments(orderedActionArguments);
                    }
                }
                this.UPNPServiceActions.put(action.getName(), action);
            }
            this.parsedSCPD = true;
        }
        catch (Throwable t2) {
            throw new RuntimeException("Error during lazy SCDP file parsing at " + this.SCPDURL, t2);
        }
    }

    private void parseServiceStateVariables(JXPathContext rootContext) {
        Pointer serviceStateTablePtr = rootContext.getPointer("serviceStateTable");
        JXPathContext serviceStateTableCtx = rootContext.getRelativeContext(serviceStateTablePtr);
        Double arraySize = (Double)serviceStateTableCtx.getValue("count( stateVariable )");
        this.UPNPServiceStateVariables = new HashMap();
        for (int i2 = 1; i2 <= arraySize.intValue(); ++i2) {
            ServiceStateVariable srvStateVar = new ServiceStateVariable();
            String sendEventsLcl = null;
            try {
                sendEventsLcl = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/@sendEvents");
            }
            catch (JXPathException defEx) {
                sendEventsLcl = "yes";
            }
            srvStateVar.parent = this;
            srvStateVar.sendEvents = !sendEventsLcl.equalsIgnoreCase("no");
            srvStateVar.name = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/name");
            srvStateVar.dataType = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/dataType");
            try {
                srvStateVar.defaultValue = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/defaultValue");
            }
            catch (JXPathException defEx) {
                // empty catch block
            }
            Pointer allowedValuesPtr = null;
            try {
                allowedValuesPtr = serviceStateTableCtx.getPointer("stateVariable[" + i2 + "]/allowedValueList");
            }
            catch (JXPathException ex) {
                // empty catch block
            }
            if (allowedValuesPtr != null) {
                JXPathContext allowedValuesCtx = serviceStateTableCtx.getRelativeContext(allowedValuesPtr);
                Double arraySizeAllowed = (Double)allowedValuesCtx.getValue("count( allowedValue )");
                srvStateVar.allowedvalues = new HashSet();
                for (int z2 = 1; z2 <= arraySizeAllowed.intValue(); ++z2) {
                    String allowedValue = (String)allowedValuesCtx.getValue("allowedValue[" + z2 + "]");
                    srvStateVar.allowedvalues.add(allowedValue);
                }
            }
            Pointer allowedValueRangePtr = null;
            try {
                allowedValueRangePtr = serviceStateTableCtx.getPointer("stateVariable[" + i2 + "]/allowedValueRange");
            }
            catch (JXPathException ex) {
                // empty catch block
            }
            if (allowedValueRangePtr != null) {
                srvStateVar.minimumRangeValue = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/allowedValueRange/minimum");
                srvStateVar.maximumRangeValue = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/allowedValueRange/maximum");
                try {
                    srvStateVar.stepRangeValue = (String)serviceStateTableCtx.getValue("stateVariable[" + i2 + "]/allowedValueRange/step");
                }
                catch (JXPathException stepEx) {
                    // empty catch block
                }
            }
            this.UPNPServiceStateVariables.put(srvStateVar.getName(), srvStateVar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitiate() {
        if (!this.parsedSCPD) {
            UPNPService uPNPService = this;
            synchronized (uPNPService) {
                if (!this.parsedSCPD) {
                    this.parseSCPD();
                }
            }
        }
    }

    public Container getUPNPService() {
        return this.UPNPService;
    }

    public String getSCDPData() {
        if (this.SCPDURLData == null) {
            try {
                InputStream in = this.SCPDURL.openConnection().getInputStream();
                int readen = 0;
                byte[] buff = new byte[512];
                StringBuffer strBuff = new StringBuffer();
                while ((readen = in.read(buff)) != -1) {
                    strBuff.append(new String(buff, 0, readen));
                }
                in.close();
                this.SCPDURLData = strBuff.toString();
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return this.SCPDURLData;
    }
}

