/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;

public abstract class NodePointer
implements Pointer {
    public static final int WHOLE_COLLECTION = Integer.MIN_VALUE;
    protected int index = Integer.MIN_VALUE;
    public static final String UNKNOWN_NAMESPACE = "<<unknown namespace>>";
    private boolean attribute = false;
    private transient Object rootNode;
    protected NodePointer parent;
    protected Locale locale;

    public static NodePointer newNodePointer(QName name, Object bean, Locale locale) {
        if (bean == null) {
            return new NullPointer(name, locale);
        }
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i2 = 0;
        while (i2 < factories.length) {
            NodePointer pointer = factories[i2].createNodePointer(name, bean, locale);
            if (pointer != null) {
                return pointer;
            }
            ++i2;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    public static NodePointer newChildNodePointer(NodePointer parent, QName name, Object bean) {
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        int i2 = 0;
        while (i2 < factories.length) {
            NodePointer pointer = factories[i2].createNodePointer(parent, name, bean);
            if (pointer != null) {
                return pointer;
            }
            ++i2;
        }
        throw new JXPathException("Could not allocate a NodePointer for object of " + bean.getClass());
    }

    protected NodePointer(NodePointer parent) {
        this.parent = parent;
    }

    protected NodePointer(NodePointer parent, Locale locale) {
        this.parent = parent;
        this.locale = locale;
    }

    public NodePointer getParent() {
        return this.parent;
    }

    public void setAttribute(boolean attribute) {
        this.attribute = attribute;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public abstract boolean isLeaf();

    public boolean isNode() {
        return !this.isContainer();
    }

    public boolean isContainer() {
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract boolean isCollection();

    public abstract int getLength();

    public Object getValue() {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != this) {
            return valuePointer.getValue();
        }
        return this.getNode();
    }

    public NodePointer getValuePointer() {
        NodePointer ivp = this.getImmediateValuePointer();
        if (ivp != this) {
            return ivp.getValuePointer();
        }
        return this;
    }

    public NodePointer getImmediateValuePointer() {
        return this;
    }

    public boolean isActual() {
        if (this.index == Integer.MIN_VALUE) {
            return true;
        }
        return this.index >= 0 && this.index < this.getLength();
    }

    public abstract QName getName();

    public abstract Object getBaseValue();

    public Object getNodeValue() {
        return this.getNode();
    }

    public Object getNode() {
        return this.getValuePointer().getImmediateNode();
    }

    public Object getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.parent != null ? this.parent.getRootNode() : this.getImmediateNode();
        }
        return this.rootNode;
    }

    public abstract Object getImmediateNode();

    public abstract void setValue(Object var1);

    public abstract int compareChildNodePointers(NodePointer var1, NodePointer var2);

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String nodeNS;
            String testNS;
            String nodePrefix;
            if (this.isContainer()) {
                return false;
            }
            QName testName = ((NodeNameTest)test).getNodeName();
            QName nodeName = this.getName();
            String testPrefix = testName.getPrefix();
            if (!NodePointer.equalStrings(testPrefix, nodePrefix = nodeName.getPrefix()) && !NodePointer.equalStrings(testNS = this.getNamespaceURI(testPrefix), nodeNS = this.getNamespaceURI(nodePrefix))) {
                return false;
            }
            String testLocalName = testName.getName();
            if (testLocalName.equals("*")) {
                return true;
            }
            return testLocalName.equals(nodeName.getName());
        }
        if (test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1) {
            return this.isNode();
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        this.setValue(value);
        return this;
    }

    public void remove() {
    }

    public NodePointer createPath(JXPathContext context) {
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + name + "[" + (index + 1) + "]" + ", operation is not allowed for this type of node");
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        throw new JXPathException("Cannot create an object for path " + this.asPath() + "/" + name + "[" + (index + 1) + "]" + ", operation is not allowed for this type of node");
    }

    public NodePointer createAttribute(JXPathContext context, QName name) {
        throw new JXPathException("Cannot create an attribute for path " + this.asPath() + "/@" + name + ", operation is not allowed for this type of node");
    }

    public Locale getLocale() {
        if (this.locale == null && this.parent != null) {
            this.locale = this.parent.getLocale();
        }
        return this.locale;
    }

    public boolean isLanguage(String lang) {
        Locale loc = this.getLocale();
        String name = loc.toString().replace('_', '-');
        return name.toUpperCase().startsWith(lang.toUpperCase());
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != null && valuePointer != this) {
            return valuePointer.childIterator(test, reverse, startWith);
        }
        return null;
    }

    public NodeIterator attributeIterator(QName qname) {
        NodePointer valuePointer = this.getValuePointer();
        if (valuePointer != null && valuePointer != this) {
            return valuePointer.attributeIterator(qname);
        }
        return null;
    }

    public NodeIterator namespaceIterator() {
        return null;
    }

    public NodePointer namespacePointer(String namespace) {
        return null;
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    protected boolean isDefaultNamespace(String prefix) {
        if (prefix == null) {
            return true;
        }
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            return false;
        }
        return namespace.equals(this.getDefaultNamespaceURI());
    }

    protected String getDefaultNamespaceURI() {
        return null;
    }

    public QName getExpandedName() {
        return this.getName();
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        return context.getPointerByID(id);
    }

    public Pointer getPointerByKey(JXPathContext context, String key, String value) {
        return context.getPointerByKey(key, value);
    }

    public String asPath() {
        if (this.parent != null && this.parent.isContainer()) {
            return this.parent.asPath();
        }
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        if (this.attribute) {
            buffer.append('@');
        }
        buffer.append(this.getName());
        if (this.index != Integer.MIN_VALUE && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void ex;
            NodePointer ptr = (NodePointer)super.clone();
            if (this.parent != null) {
                ptr.parent = (NodePointer)this.parent.clone();
            }
            return ex;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.asPath();
    }

    public int compareTo(Object object) {
        NodePointer pointer = (NodePointer)object;
        if (this.parent == pointer.parent) {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.compareChildNodePointers(this, pointer);
        }
        int depth1 = 0;
        NodePointer p1 = this;
        while (p1 != null) {
            ++depth1;
            p1 = p1.parent;
        }
        int depth2 = 0;
        NodePointer p2 = pointer;
        while (p2 != null) {
            ++depth2;
            p2 = p2.parent;
        }
        return this.compareNodePointers(this, depth1, pointer, depth2);
    }

    private int compareNodePointers(NodePointer p1, int depth1, NodePointer p2, int depth2) {
        if (depth1 < depth2) {
            int r2 = this.compareNodePointers(p1, depth1, p2.parent, depth2 - 1);
            if (r2 != 0) {
                return r2;
            }
            return -1;
        }
        if (depth1 > depth2) {
            int r3 = this.compareNodePointers(p1.parent, depth1 - 1, p2, depth2);
            if (r3 != 0) {
                return r3;
            }
            return 1;
        }
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 != null && p1.equals(p2)) {
            return 0;
        }
        if (depth1 == 1) {
            throw new JXPathException("Cannot compare pointers that do not belong to the same tree: '" + p1 + "' and '" + p2 + "'");
        }
        int r4 = this.compareNodePointers(p1.parent, depth1 - 1, p2.parent, depth2 - 1);
        if (r4 != 0) {
            return r4;
        }
        return p1.parent.compareChildNodePointers(p1, p2);
    }

    public void printPointerChain() {
        NodePointer.printDeep(this, "");
    }

    private static void printDeep(NodePointer pointer, String indent) {
        if (indent.length() == 0) {
            System.err.println("POINTER: " + pointer + "(" + pointer.getClass().getName() + ")");
        } else {
            System.err.println(indent + " of " + pointer + "(" + pointer.getClass().getName() + ")");
        }
        if (pointer.getParent() != null) {
            NodePointer.printDeep(pointer.getParent(), indent + "  ");
        }
    }
}

