/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.fileutil;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import org.jdesktop.jdic.fileutil.FileIterator;
import org.jdesktop.jdic.fileutil.NativeFileUtil;

public class FileUtil {
    private NativeFileUtil fileUtil = NativeFileUtil.getNativeFileUtil();

    public boolean recycle(File file) throws IOException, SecurityException, UnsupportedOperationException {
        return this.fileUtil.recycle(file);
    }

    public BigInteger getFreeSpace(File file) throws IOException, UnsupportedOperationException {
        return this.fileUtil.getFreeSpace(file);
    }

    public BigInteger getTotalSpace(File file) throws IOException, UnsupportedOperationException {
        return this.fileUtil.getTotalSpace(file);
    }

    public FileIterator listFiles(File file) {
        return new InnerFileIterator(file);
    }

    public FileIterator listFiles(File file, FileFilter fileFilter) {
        return new InnerFileFilterIterator(file, fileFilter);
    }

    public FileIterator listFiles(File file, FilenameFilter filenameFilter) {
        return new InnerFilenameFilterIterator(file, filenameFilter);
    }

    private class InnerFilenameFilterIterator
    extends InnerFileIterator {
        private FilenameFilter filter;
        private File directory;

        public InnerFilenameFilterIterator(File file, FilenameFilter filenameFilter) {
            super(file);
            this.directory = file;
            this.filter = filenameFilter;
        }

        public boolean hasNext() throws IOException {
            if (super.hasNext()) {
                if (this.filter.accept(this.directory, this.next().getName())) {
                    return true;
                }
                return this.hasNext();
            }
            return false;
        }
    }

    private class InnerFileFilterIterator
    extends InnerFileIterator {
        private FileFilter filter;

        public InnerFileFilterIterator(File file, FileFilter fileFilter) {
            super(file);
            this.filter = fileFilter;
        }

        public boolean hasNext() throws IOException {
            if (super.hasNext()) {
                if (this.filter.accept(this.next())) {
                    return true;
                }
                return this.hasNext();
            }
            return false;
        }
    }

    private class InnerFileIterator
    implements FileIterator {
        private boolean closed;
        private File nextFile;
        private File directory;
        private boolean firstRead;

        public InnerFileIterator(File file) {
            this.directory = file;
            this.firstRead = true;
            this.closed = true;
        }

        public boolean hasNext() throws IOException {
            if (this.directory.isDirectory()) {
                String string;
                if (this.firstRead) {
                    string = FileUtil.this.fileUtil.readFirst(this.directory.getCanonicalPath());
                    this.firstRead = false;
                    this.closed = false;
                } else {
                    string = FileUtil.this.fileUtil.readNext();
                }
                if (string != null) {
                    this.nextFile = new File(this.directory.getCanonicalPath() + string);
                    return true;
                }
                this.nextFile = null;
                this.close();
                return false;
            }
            return false;
        }

        public File next() throws NoSuchElementException {
            if (this.closed) {
                throw new NoSuchElementException();
            }
            return this.nextFile;
        }

        public void close() {
            if (!this.closed) {
                FileUtil.this.fileUtil.close();
                this.closed = true;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

