/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.http.ChunkingInputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpResponse;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class HttpInputStream
extends FilterInputStream {
    private static Log log = LogFactory.getLog(HttpInputStream.class);
    private static ClosedStream __closedStream = new ClosedStream();
    private ChunkingInputStream _deChunker;
    private LineInput _realIn;
    private boolean _chunking;
    private OutputStream _expectContinues;

    public HttpInputStream(InputStream in) {
        this(in, 4096);
    }

    public HttpInputStream(InputStream in, int bufferSize) {
        super(null);
        try {
            this._realIn = new LineInput(in, bufferSize, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e2) {
            log.fatal(e2);
            System.exit(1);
        }
        this.in = this._realIn;
    }

    public OutputStream getExpectContinues() {
        return this._expectContinues;
    }

    public void setExpectContinues(OutputStream expectContinues) {
        this._expectContinues = expectContinues;
    }

    public int read() throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read();
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(b2, off, len);
    }

    public int read(byte[] b2) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.read(b2);
    }

    public long skip(long n2) throws IOException {
        if (this._expectContinues != null) {
            this.expectContinues();
        }
        return super.skip(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expectContinues() throws IOException {
        try {
            if (this.available() <= 0) {
                this._expectContinues.write(HttpResponse.__Continue);
                this._expectContinues.flush();
            }
        }
        finally {
            this._expectContinues = null;
        }
    }

    public InputStream getInputStream() {
        return this._realIn;
    }

    public InputStream getFilterStream() {
        return this.in;
    }

    public void setFilterStream(InputStream filter) {
        this.in = filter;
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking() throws IllegalStateException {
        if (this._realIn.getByteLimit() >= 0) {
            throw new IllegalStateException("Has Content-Length");
        }
        if (this._deChunker == null) {
            this._deChunker = new ChunkingInputStream(this._realIn);
        }
        this.in = this._deChunker;
        this._chunking = true;
        this._deChunker._trailer = null;
    }

    public void resetStream() throws IllegalStateException {
        if (this._deChunker != null && this._deChunker._chunkSize > 0 || this._realIn.getByteLimit() > 0) {
            throw new IllegalStateException("Unread input");
        }
        if (log.isTraceEnabled()) {
            log.trace("resetStream()");
        }
        this.in = this._realIn;
        if (this._deChunker != null) {
            this._deChunker.resetStream();
        }
        this._chunking = false;
        this._realIn.setByteLimit(-1);
    }

    public void close() throws IOException {
        this.in = __closedStream;
    }

    public void setContentLength(int len) {
        if (this._chunking && len >= 0 && this.getExpectContinues() == null) {
            throw new IllegalStateException("Chunking");
        }
        this._realIn.setByteLimit(len);
    }

    void unsafeSetContentLength(int len) {
        this._realIn.setByteLimit(len);
    }

    public int getContentLength() {
        return this._realIn.getByteLimit();
    }

    public HttpFields getTrailer() {
        return this._deChunker._trailer;
    }

    public void destroy() {
        if (this._realIn != null) {
            this._realIn.destroy();
        }
        this._realIn = null;
        this._deChunker = null;
        this._expectContinues = null;
    }

    private static class ClosedStream
    extends InputStream {
        private ClosedStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

