/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlParser;

public class TagLibConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog(TagLibConfiguration.class);
    WebApplicationContext _context;

    public void setWebApplicationContext(WebApplicationContext context) {
        this._context = context;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    public void configureClassPath() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    public void configureWebApp() throws Exception {
        Resource l2;
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (this._context.getResourceAliases() != null) {
            Iterator iter = this._context.getResourceAliases().values().iterator();
            while (iter.hasNext()) {
                String location = (String)iter.next();
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                l2 = this._context.getBaseResource().addPath(location);
                tlds.add(l2);
            }
        }
        if (this._context.getWebInf() != null) {
            String[] contents = this._context.getWebInf().list();
            for (int i2 = 0; i2 < contents.length; ++i2) {
                if (contents[i2] == null || !contents[i2].toLowerCase().endsWith(".tld")) continue;
                l2 = this._context.getWebInf().addPath(contents[i2]);
                tlds.add(l2);
            }
            Resource lib = this._context.getWebInf().addPath("lib/");
            if (lib.exists() && lib.isDirectory()) {
                contents = lib.list();
                for (int i3 = 0; i3 < contents.length; ++i3) {
                    if (contents[i3] == null || !contents[i3].toLowerCase().endsWith(".jar")) continue;
                    Resource l3 = lib.addPath(contents[i3]);
                    Resource meta = Resource.newResource("jar:" + l3 + "!/META-INF/");
                    if (!meta.exists()) continue;
                    String[] meta_contents = meta.list();
                    for (int j2 = 0; j2 < meta_contents.length; ++j2) {
                        if (meta_contents[j2] == null || !meta_contents[j2].toLowerCase().endsWith(".tld")) continue;
                        Resource t2 = meta.addPath(meta_contents[j2]);
                        tlds.add(t2);
                    }
                }
            }
        }
        XmlParser parser = new XmlParser(false);
        parser.redirectEntity("web-jsptaglibrary_1_1.dtd", WebApplicationContext.class.getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd"));
        parser.redirectEntity("web-jsptaglibrary_1_2.dtd", WebApplicationContext.class.getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd"));
        parser.redirectEntity("web-jsptaglibrary_2_0.xsd", WebApplicationContext.class.getResource("/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd"));
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                Resource tld = (Resource)iter.next();
                if (log.isDebugEnabled()) {
                    log.debug("TLD=" + tld);
                }
                XmlParser.Node root = parser.parse(tld.getURL());
                for (int i4 = 0; i4 < root.size(); ++i4) {
                    XmlParser.Node node;
                    Object o2 = root.get(i4);
                    if (!(o2 instanceof XmlParser.Node) || !"listener".equals((node = (XmlParser.Node)o2).getTag())) continue;
                    String className = node.getString("listener-class", false, true);
                    if (log.isDebugEnabled()) {
                        log.debug("listener=" + className);
                    }
                    try {
                        Class listenerClass = this.getWebApplicationContext().loadClass(className);
                        EventListener l4 = (EventListener)listenerClass.newInstance();
                        this._context.addEventListener(l4);
                        continue;
                    }
                    catch (Exception e2) {
                        log.warn("Could not instantiate listener " + className, e2);
                    }
                }
            }
            catch (Exception e3) {
                log.warn(e3);
            }
        }
    }
}

