/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;

public class StringUtil {
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1;
    public static final String __UTF_8 = "UTF-8";
    private static char[] lowercases;

    public static String asciiToLowerCase(String s2) {
        char[] c2 = null;
        int i2 = s2.length();
        while (i2-- > 0) {
            char c22;
            char c1 = s2.charAt(i2);
            if (c1 > '\u007f' || c1 == (c22 = lowercases[c1])) continue;
            c2 = s2.toCharArray();
            c2[i2] = c22;
            break;
        }
        while (i2-- > 0) {
            if (c2[i2] > 127) continue;
            c2[i2] = lowercases[c2[i2]];
        }
        return c2 == null ? s2 : new String(c2);
    }

    public static boolean startsWithIgnoreCase(String s2, String w2) {
        if (w2 == null) {
            return true;
        }
        if (s2 == null || s2.length() < w2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < w2.length(); ++i2) {
            char c2;
            char c1 = s2.charAt(i2);
            if (c1 == (c2 = w2.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s2, String w2) {
        if (w2 == null) {
            return true;
        }
        int sl = s2.length();
        int wl = w2.length();
        if (s2 == null || sl < wl) {
            return false;
        }
        int i2 = wl;
        while (i2-- > 0) {
            char c2;
            char c1;
            if ((c1 = s2.charAt(--sl)) == (c2 = w2.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s2, String chars) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (chars.indexOf(s2.charAt(i2)) < 0) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replace(String s2, String sub, String with) {
        StringBuffer buf;
        int c2 = 0;
        int i2 = s2.indexOf(sub, c2);
        if (i2 == -1) {
            return s2;
        }
        StringBuffer stringBuffer = buf = new StringBuffer(s2.length() + with.length());
        synchronized (stringBuffer) {
            do {
                buf.append(s2.substring(c2, i2));
                buf.append(with);
            } while ((i2 = s2.indexOf(sub, c2 = i2 + sub.length())) != -1);
            if (c2 < s2.length()) {
                buf.append(s2.substring(c2, s2.length()));
            }
            return buf.toString();
        }
    }

    public static String unquote(String s2) {
        if (s2.startsWith("\"") && s2.endsWith("\"") || s2.startsWith("'") && s2.endsWith("'")) {
            s2 = s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuffer buf, String s2, int offset, int length) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            int end = offset + length;
            for (int i2 = offset; i2 < end && i2 < s2.length(); ++i2) {
                buf.append(s2.charAt(i2));
            }
        }
    }

    public static void append(StringBuffer buf, byte b2, int base) {
        int bi2 = 0xFF & b2;
        int c2 = 48 + bi2 / base % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
        c2 = 48 + bi2 % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
    }

    public static void append2digits(StringBuffer buf, int i2) {
        if (i2 < 100) {
            buf.append((char)(i2 / 10 + 48));
            buf.append((char)(i2 % 10 + 48));
        }
    }

    public static String nonNull(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    public static boolean equals(String s2, char[] buf, int offset, int length) {
        if (s2.length() != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (buf[offset + i2] == s2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    static {
        String iso = System.getProperty("ISO_8859_1");
        if (iso != null) {
            __ISO_8859_1 = iso;
        } else {
            try {
                new String(new byte[]{20}, "ISO-8859-1");
                iso = "ISO-8859-1";
            }
            catch (UnsupportedEncodingException e2) {
                iso = "ISO8859_1";
            }
            __ISO_8859_1 = iso;
        }
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }
}

