/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

public abstract class AbstractImageInfo
extends BasicIo
implements AbstractInfo {
    public static final Dimension DEFAULT_THUMB_SIZE = new Dimension(120, 96);
    public static final String EXT_JPEG = "Jpeg";
    static final DateFormat dateformat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    static final DecimalFormat fnumberformat = new DecimalFormat("F1:#0.0#");
    static final String NA = "n/a";
    static final byte[] BMP_SIG = new byte[]{66, 77};
    static final int BMP24_HDR_SIZE = 54;
    protected static final Class[] EMPTY_PARAMS = new Class[0];
    public static final double[] AV_TO_FSTOP = new double[]{1.0, 1.4, 2.0, 2.8, 4.0, 5.6, 8.0, 11.0, 16.0, 22.0, 32.0};
    public static final Rational[] TV_TO_SEC = new Rational[]{new Rational(1, 1), new Rational(1, 2), new Rational(1, 4), new Rational(1, 8), new Rational(1, 15), new Rational(1, 30), new Rational(1, 60), new Rational(1, 125), new Rational(1, 250), new Rational(1, 500), new Rational(1, 1000), new Rational(1, 2000), new Rational(1, 4000), new Rational(1, 8000), new Rational(1, 16000)};
    protected transient InputStream is;
    protected int offset;
    protected String name;
    protected String comments;
    protected Object[] fiveObjects = new Object[5];

    public AbstractImageInfo() {
    }

    public AbstractImageInfo(InputStream is, byte[] data, int offset, String name, String comments) throws FileFormatException {
        this.is = is;
        this.data = data;
        this.offset = offset;
        this.name = name;
        this.comments = comments;
        this.readInfo();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void readInfo() throws FileFormatException;

    public abstract String getFormat();

    public abstract int getResolutionX();

    public abstract int getResolutionY();

    public abstract String getMake();

    public abstract String getModel();

    public abstract String getDataTimeOriginalString();

    public abstract float getFNumber();

    public abstract Rational getShutter();

    public abstract boolean isFlash();

    public abstract String getQuality();

    public abstract float getFocalLength();

    public abstract int getMetering();

    public abstract int getExpoProgram();

    public abstract String getReport();

    public abstract Icon getThumbnailIcon(StrippedJpeg var1, Dimension var2);

    public String toString() {
        String result = this.getReport();
        if (result != null && result.length() > 0) {
            return result;
        }
        return super.toString();
    }

    public Object[] getFiveMajorAttributes() {
        return this.fiveObjects;
    }

    public Icon getThumbnailIcon(StrippedJpeg im) {
        return this.getThumbnailIcon(im, null);
    }

    public String getThumbnailExtension() {
        return EXT_JPEG;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean saveThumbnailImage(StrippedJpeg im, OutputStream os) throws IOException {
        if (os == null || im == null) {
            return false;
        }
        return false;
    }

    public Date getDateTimeOriginal() {
        try {
            return dateformat.parse(this.getDataTimeOriginalString());
        }
        catch (NullPointerException e2) {
        }
        catch (ParseException e3) {
            System.err.println("" + e3);
        }
        return new Date();
    }

    public float apertureToFnumber(float aperture) {
        try {
            int si = (int)aperture;
            float result = (float)AV_TO_FSTOP[si];
            if ((aperture -= (float)si) != 0.0f) {
                result = (float)((double)result + (AV_TO_FSTOP[si + 1] - AV_TO_FSTOP[si]) * (double)aperture);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1.0f;
        }
    }

    public void setAttribute(String name, Object value) {
        if (!"Comments".equals(name)) {
            throw new RuntimeException("Calling this method not allowed by AbstractImageInfo implementation.");
        }
        this.comments = value.toString();
    }

    public Object getAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.getShutter();
        }
        if ("timestamp".equals(name)) {
            return this.getDateTimeOriginal();
        }
        if ("quality".equals(name)) {
            return this.getQuality();
        }
        if ("make".equals(name)) {
            return this.getMake();
        }
        return this.getGenericAttribute(name);
    }

    public int getIntAttribute(String name) {
        if ("charachter".equals(name)) {
            return (int)this.getFocalLength();
        }
        Object result = this.getGenericAttribute(name);
        if (result != null) {
            if (result instanceof Integer) {
                return (Integer)result;
            }
        } else {
            return 0;
        }
        throw new IllegalArgumentException("Not supported attribute name for int " + name);
    }

    public float getFloatAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.getFNumber();
        }
        Object result = this.getGenericAttribute(name);
        if (result != null) {
            if (result instanceof Float) {
                return ((Float)result).floatValue();
            }
        } else {
            return 0.0f;
        }
        throw new IllegalArgumentException("Not supported attribute name for float " + name);
    }

    public long getLongAttribute(String name) {
        throw new IllegalArgumentException("Not supported attribute name for long " + name);
    }

    public double getDoubleAttribute(String name) {
        throw new IllegalArgumentException("Not supported attribute name for double " + name);
    }

    public boolean getBoolAttribute(String name) {
        if ("charachter".equals(name)) {
            return this.isFlash();
        }
        return this.getGenericBoolAttribute(name);
    }

    protected Object getGenericAttribute(String name) {
        try {
            return this.getClass().getMethod("get" + name, EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable t2) {
            throw new IllegalArgumentException("Not supported attribute " + name + " <<" + t2);
        }
    }

    protected Boolean getGenericBoolAttribute(String name) {
        try {
            return (Boolean)this.getClass().getMethod("is" + name, EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable t2) {
            try {
                return (Boolean)this.getGenericAttribute(name);
            }
            catch (Throwable t22) {
                throw new IllegalArgumentException("Not supported boolean attribute " + name + " <<" + t22 + " <<" + t2);
            }
        }
    }
}

