/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.DirectoryEntry;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Header;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

public class Flashpix
extends AbstractImageInfo {
    public static final String FORMAT = "Flashpix";
    static final int HEADER_LENGTH = 512;
    static final byte[] SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    Header header;
    byte[] fat;
    Icon icon;

    public Flashpix() {
    }

    public Flashpix(InputStream is, byte[] data, int offset, String name) throws FileFormatException {
        super(is, data, offset, name, null);
    }

    public void readInfo() throws FileFormatException {
        try {
            this.data = new byte[504];
            Flashpix.read(this.is, this.data);
            this.offset += this.data.length;
            this.header = new Header();
            this.header.fill(this.data, -8);
            this.intel = this.header.intelByteOrder;
            System.err.println("Header " + this.header.toString() + " of " + this.getName());
            Flashpix.skip(this.is, this.header.fat[0] * this.header.sectorSize);
            this.offset += this.header.fat[0] * this.header.sectorSize;
            this.data = new byte[this.header.sectorSize];
            for (int i2 = 0; i2 < this.header.sectsFat; ++i2) {
                System.err.println("Fat sector [" + i2 + "]=" + this.header.fat[i2]);
            }
            Flashpix.read(this.is, this.data);
            this.offset += this.data.length;
            System.err.println("Sector " + this.header.sectDirStart + " marker " + Integer.toHexString(this.s2n(this.header.sectDirStart * 4, 4)));
            this.fat = this.data;
            this.data = new byte[this.header.sectorSize];
            Flashpix.read(this.is, this.data);
            this.offset += this.data.length;
            DirectoryEntry root = new DirectoryEntry();
            root.fill(this.data, 0);
            System.err.println("Root " + root.toString());
            if (root._child < 0) {
                return;
            }
            DirectoryEntry child = new DirectoryEntry();
            child.fill(this.data, root._child * 128);
            System.err.println("Child " + child.toString());
            DirectoryEntry sibchild = new DirectoryEntry();
            if (child._leftSib > 0) {
                sibchild.fill(this.data, child._leftSib * 128);
                System.err.println("Left sib " + sibchild.toString());
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String getFormat() {
        return FORMAT;
    }

    public int getResolutionX() {
        return 0;
    }

    public int getResolutionY() {
        return 0;
    }

    public String getMake() {
        return null;
    }

    public String getModel() {
        return null;
    }

    public String getDataTimeOriginalString() {
        return null;
    }

    public float getFNumber() {
        return 0.0f;
    }

    public Rational getShutter() {
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        return false;
    }

    public String getQuality() {
        return null;
    }

    public float getFocalLength() {
        return 0.0f;
    }

    public int getMetering() {
        return 0;
    }

    public int getExpoProgram() {
        return 0;
    }

    public String getReport() {
        return null;
    }

    public Icon getThumbnailIcon(StrippedJpeg im, Dimension size) {
        if (this.icon != null) {
            return this.icon;
        }
        return null;
    }
}

