/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.util.JComponentHolder;

public class ControlPanel
extends JPanel
implements JComponentHolder {
    private boolean useExtraSpace = true;

    public ControlPanel() {
        super(new RiverLayout());
        this.setBorder(null);
        this.transparentize(this);
    }

    public ControlPanel(String title) {
        this();
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.setBorder(this.createControlPanelBorder(title));
    }

    private Border createControlPanelBorder(String title) {
        if (title.length() <= 0) {
            return null;
        }
        return JAlbumBorders.createTitledCurveBorder(title, this.useExtraSpace);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            comps[i2].setEnabled(enable);
        }
    }

    public void add(Component c2, Object o2) {
        this.transparentize(c2);
        super.add(c2, o2);
    }

    public Component add(String s2, Component c2) {
        this.transparentize(c2);
        return super.add(s2, c2);
    }

    public void add(Component c2, Object o2, int i2) {
        this.transparentize(c2);
        super.add(c2, o2, i2);
    }

    public Component add(Component c2, int i2) {
        this.transparentize(c2);
        return super.add(c2, i2);
    }

    public Component add(Component c2) {
        this.transparentize(c2);
        return super.add(c2);
    }

    public void transparentize(Component c2) {
        if (JAlbum.isMac() && JAlbum.isUsingSystemLAF()) {
            boolean isJComponent = c2 instanceof JComponent;
            boolean isTextComponent = c2 instanceof JTextComponent;
            if (isJComponent && !isTextComponent) {
                ((JComponent)c2).setOpaque(false);
            }
        }
    }

    public void setUseExtraSpace(boolean extraSpace) {
        this.useExtraSpace = extraSpace;
    }
}

