/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import se.datadosen.jalbum.JAlbum;

public class JSmartSeparator
extends JComponent {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int align = 0;
    private String text = "";
    private Color textColor = SystemColor.controlText;
    private Color lineColor = new Color(0, 0, 0, 60);

    public JSmartSeparator() {
        this("");
    }

    public JSmartSeparator(String text) {
        this(text, 0);
    }

    public JSmartSeparator(String text, int align) {
        this.align = align;
        this.setText(text);
        Font f2 = new JLabel().getFont();
        if (JAlbum.isMac()) {
            f2 = f2.deriveFont(f2.getSize2D() - 2.0f);
        }
        this.setFont(f2);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    protected void paintComponent(Graphics g2) {
        Dimension d2 = this.getSize();
        int w2 = d2.width;
        int h2 = d2.height;
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D b2 = fm.getStringBounds(this.text, g2);
        int space = fm.getAscent() / 3;
        int x1 = this.align == 0 ? fm.getAscent() : (this.align == 1 ? (int)(((double)w2 - b2.getWidth()) / 2.0 - (double)space) : (int)((double)w2 - b2.getWidth() - (double)(3 * space)));
        int ty = h2 - fm.getDescent();
        int x2 = (int)((double)x1 + b2.getWidth());
        int ly = ty - fm.getDescent() - 1;
        g2.setColor(this.textColor);
        g2.drawString(this.text, x1, ty);
        g2.setColor(this.lineColor);
        g2.drawLine(0, ly, x1 - space - 1, ly);
        g2.drawLine(x2 + space, ly, w2, ly);
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        Graphics g2 = this.getGraphics();
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D r2 = fm.getStringBounds(this.text, g2);
        g2.dispose();
        size.width = (int)Math.ceil(r2.getWidth());
        size.height = (int)Math.ceil(r2.getHeight());
        return size;
    }
}

