/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.dnd;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import se.datadosen.dnd.TransferableNode;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    protected JTree tree;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static DefaultMutableTreeNode draggedNode;
    private DefaultMutableTreeNode draggedNodeParent;
    private static BufferedImage image;
    private Rectangle rect2D = new Rectangle();
    private boolean drawImage;
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);

    protected AbstractTreeTransferHandler(JTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
        this.dropTarget = new DropTarget(tree, action, this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeParent);
        }
    }

    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            draggedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.draggedNodeParent = (DefaultMutableTreeNode)draggedNode.getParent();
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
            }
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableNode(draggedNode), this);
        }
    }

    public final void dragEnter(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.autoscroll(pt);
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    public final void drop(DropTargetDropEvent dtde) {
        try {
            if (this.drawImage) {
                this.clearImage();
            }
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            Point pt = dtde.getLocation();
            if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
                DefaultMutableTreeNode newParentNode;
                TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                if (this.executeDrop(this.tree, node, newParentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent(), action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
            }
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (Exception e2) {
            System.out.println(e2);
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
    }

    private final void paintImage(Point pt) {
        this.tree.paintImmediately(this.rect2D.getBounds());
        this.rect2D.setRect((int)pt.getX(), (int)pt.getY(), image.getWidth(), image.getHeight());
        this.tree.getGraphics().drawImage(image, (int)pt.getX(), (int)pt.getY(), this.tree);
    }

    private final void clearImage() {
        this.tree.paintImmediately(this.rect2D.getBounds());
    }

    public abstract boolean canPerformAction(JTree var1, DefaultMutableTreeNode var2, int var3, Point var4);

    public abstract boolean executeDrop(JTree var1, DefaultMutableTreeNode var2, DefaultMutableTreeNode var3, int var4);

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.autoscrollInsets;
        Rectangle outer = this.tree.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.tree.scrollRectToVisible(scrollRect);
        }
    }

    static {
        image = null;
    }
}

