/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;

class ExplorerSelectionModel {
    static final int NORTH = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int EAST = 4;
    private JExplorerPanel explorer;
    int lastClickedIndex = 0;
    boolean wasAlreadySelected = false;
    private JAlbumObject focusedObject;

    public ExplorerSelectionModel(JExplorerPanel explorer) {
        this.explorer = explorer;
    }

    int indexOf(Component comp) {
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (comps[i2] != comp) continue;
            return i2;
        }
        return -1;
    }

    void deselectAll() {
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            ((JAlbumObject)comps[i2]).setSelected(false);
        }
    }

    void selectAll() {
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            ((JAlbumObject)comps[i2]).setSelected(true);
        }
    }

    void invertSelection() {
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao;
            jao.setSelected(!(jao = (JAlbumObject)comps[i2]).isSelected());
        }
    }

    void selectRange(int startIndex, int endIndex) {
        Component[] comps = this.explorer.getComponents();
        if (startIndex > endIndex) {
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            jao.setSelected(true);
        }
    }

    LinkedList getSelectedObjects() {
        LinkedList<JAlbumObject> list = new LinkedList<JAlbumObject>();
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (!jao.isSelected()) continue;
            list.add(jao);
        }
        return list;
    }

    JAlbumObject getSingleSelected() {
        JAlbumObject selected = null;
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (!jao.isSelected()) continue;
            if (selected != null) {
                return null;
            }
            selected = jao;
        }
        return selected;
    }

    JAlbumObject getFocusedObject() {
        return this.focusedObject;
    }

    void setFocusedObject(JAlbumObject jao) {
        this.focusedObject = jao;
    }

    JAlbumObject getNeighbourObject(JAlbumObject jao, int direction) {
        Point p2 = jao.getLocation();
        Dimension dim = this.explorer.objectSize;
        p2.x += dim.width / 2;
        p2.y += dim.height / 2;
        switch (direction) {
            case 1: {
                p2.y -= dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 2: {
                p2.y += dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 3: {
                p2.x -= dim.width + this.explorer.explorerThumbsLayout.getHgap();
                break;
            }
            case 4: {
                p2.x += dim.width + this.explorer.explorerThumbsLayout.getHgap();
            }
        }
        return (JAlbumObject)this.explorer.getNearestComponent(p2);
    }
}

