/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.IOException;
import se.datadosen.jalbum.AlbumObjectMetadata;

public class FastFile
extends File {
    private boolean directory;
    private boolean isDirectoryAsked;
    private long modificationDate = 0L;
    private File originalFile;
    private AlbumObjectMetadata meta;

    public FastFile(File f2) {
        super(f2.getAbsolutePath());
        this.originalFile = f2;
    }

    public final boolean isDirectory() {
        if (!this.isDirectoryAsked) {
            this.directory = super.isDirectory();
            this.isDirectoryAsked = true;
        }
        return this.directory;
    }

    public final long lastModified() {
        if (this.modificationDate == 0L) {
            this.modificationDate = super.lastModified();
        }
        return this.modificationDate;
    }

    public final boolean setLastModified(long modificationDate) {
        boolean ok = super.setLastModified(modificationDate);
        if (ok) {
            this.modificationDate = modificationDate;
        }
        return ok;
    }

    public long getCameraDate() {
        if (this.meta == null) {
            try {
                this.meta = new AlbumObjectMetadata(this.originalFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.meta.getCameraDate();
    }

    public final File unWrap() {
        return this.originalFile;
    }
}

