/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import se.datadosen.io.FastFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.CameraDateComparator;
import se.datadosen.jalbum.FileDateComparator;
import se.datadosen.jalbum.FileNameComparator;
import se.datadosen.jalbum.SimpleFileNameComparator;
import se.datadosen.util.IO;

class FileCollection {
    public static final String META_FILE_NAME = "meta.properties";
    public static final String ORDERING_KEY = "ordering";
    public static final String JALBUM_ORDERING = "jalbum";
    public static final String CUSTOM_ORDERING = "custom";
    File baseDir;
    File albumfilesFile;
    Set included;
    Set excluded = new HashSet();
    AlbumBean engine;
    boolean doSort = false;
    private String ordering;
    private String folderOrdering = "date";
    private boolean foldersFirst;
    private boolean reverseOrdering;
    private boolean reverseFolderOrdering;

    public FileCollection(AlbumBean engine, File baseDir) {
        this.engine = engine;
        this.baseDir = baseDir;
        this.albumfilesFile = new File(baseDir, "albumfiles.txt");
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    private void readProperties() {
        if (this.ordering == null) {
            String s2;
            Map props = this.getFolderProperties();
            this.ordering = (String)props.get(ORDERING_KEY);
            if (this.ordering == null) {
                this.ordering = this.albumfilesFile.exists() ? CUSTOM_ORDERING : JALBUM_ORDERING;
            }
            if ((s2 = (String)props.get("folderOrdering")) != null) {
                this.folderOrdering = s2;
            }
            this.foldersFirst = this.isTrue("foldersFirst", props);
            this.reverseOrdering = this.isTrue("reverseOrdering", props);
            this.reverseFolderOrdering = this.isTrue("reverseFolderOrdering", props);
        }
    }

    private void writeProperties() throws IOException {
        Map props = this.getFolderProperties();
        props.put(ORDERING_KEY, this.ordering);
        if (this.reverseOrdering) {
            props.put("reverseOrdering", "" + this.reverseOrdering);
        } else {
            props.remove("reverseOrdering");
        }
        if (this.foldersFirst) {
            props.put("foldersFirst", "" + this.foldersFirst);
            props.put("folderOrdering", this.folderOrdering);
            props.put("reverseFolderOrdering", "" + this.reverseFolderOrdering);
        } else {
            props.remove("foldersFirst");
        }
        this.setFolderProperties(props);
    }

    private boolean isTrue(String key, Map props) {
        return "true".equals((String)props.get(key));
    }

    public String getOrdering() {
        this.readProperties();
        return this.ordering;
    }

    public void setOrdering(String ordering) throws IOException {
        this.ordering = ordering;
        this.writeProperties();
    }

    public String getFolderOrdering() {
        this.readProperties();
        return this.folderOrdering;
    }

    public void setFolderOrdering(String folderOrdering) throws IOException {
        this.folderOrdering = folderOrdering;
        this.writeProperties();
    }

    public boolean isFoldersFirst() {
        this.readProperties();
        return this.foldersFirst;
    }

    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.foldersFirst = foldersFirst;
        this.writeProperties();
    }

    public boolean isReverseOrdering() {
        this.readProperties();
        return this.reverseOrdering;
    }

    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.reverseOrdering = reverseOrdering;
        this.writeProperties();
    }

    public boolean isReverseFolderOrdering() {
        this.readProperties();
        return this.reverseFolderOrdering;
    }

    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.reverseFolderOrdering = reverseFolderOrdering;
        this.writeProperties();
    }

    private Map getFolderProperties() {
        try {
            return AlbumBean.getFolderProperties(this.baseDir);
        }
        catch (IOException ex) {
            return new HashMap();
        }
    }

    private void setFolderProperties(Map properties) throws IOException {
        IO.writeMapFile(properties, new File(this.baseDir, META_FILE_NAME));
    }

    public void setDoSort(boolean doSort) {
        this.doSort = doSort;
    }

    private File getFile(String line) {
        StringTokenizer tokens = new StringTokenizer(line, "\t");
        String fileName = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            String targetPath = tokens.nextToken();
            if (fileName.startsWith("-")) {
                targetPath = "-" + targetPath;
            }
            return new LinkFile(this.baseDir, fileName, new File(targetPath));
        }
        File f2 = new File(fileName);
        if (!f2.isAbsolute()) {
            return new File(this.baseDir, fileName);
        }
        return new LinkFile(this.baseDir, f2.getName(), f2);
    }

    public File[] listFiles(FileFilter ff) {
        return this.listFiles(ff, false);
    }

    public File[] listFiles(FileFilter ff, boolean includeExcluded) {
        if (!this.albumfilesFile.exists()) {
            return this.sort(this.baseDir.listFiles(ff));
        }
        try {
            this.excluded = new HashSet();
            LinkedList<File> list = new LinkedList<File>();
            String text = IO.readTextFile(this.albumfilesFile);
            StringTokenizer lines = new StringTokenizer(text, "\n");
            while (lines.hasMoreTokens()) {
                String line = lines.nextToken();
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                File f2 = this.getFile(line);
                if (f2.exists() && ff.accept(f2)) {
                    list.addLast(f2);
                    continue;
                }
                if (!line.startsWith("-")) continue;
                f2 = this.getFile(line.substring(1));
                this.excluded.add(f2);
                if (!includeExcluded || !f2.exists() || !ff.accept(f2)) continue;
                list.add(f2);
            }
            this.included = new HashSet(list);
            File[] content = this.baseDir.listFiles(ff);
            for (int i2 = 0; i2 < content.length; ++i2) {
                File f3 = content[i2];
                if (this.included.contains(f3) || this.excluded.contains(f3)) continue;
                if (includeExcluded || !this.engine.isExcludeByDefault()) {
                    list.add(f3);
                }
                if (!this.engine.isExcludeByDefault()) continue;
                this.excluded.add(f3);
            }
            File[] files = list.toArray(new File[list.size()]);
            return this.sort(files);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            throw new RuntimeException(ex.toString());
        }
    }

    private File[] sort(File[] files) {
        if (!this.doSort || files == null) {
            return files;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            files[i2] = new FastFile(files[i2]);
        }
        if (this.getOrdering().equals(JALBUM_ORDERING)) {
            String imageOrdering = this.engine.getImageOrdering();
            boolean reverseOrder = this.engine.isReverseOrder();
            boolean directoriesFirst = this.engine.isDirectoriesFirst();
            Comparator customImageOrdering = this.engine.getCustomImageOrdering();
            Comparator fileComparator = customImageOrdering != null ? customImageOrdering : FileCollection.getComparator(imageOrdering, reverseOrder);
            FileCollection.sort2(files, fileComparator, directoriesFirst ? new FileNameComparator(false) : null);
        } else if (!this.getOrdering().equals(CUSTOM_ORDERING)) {
            Comparator fileComparator = FileCollection.getComparator(this.getOrdering(), this.isReverseOrdering());
            Comparator directoryComparator = null;
            if (this.isFoldersFirst()) {
                directoryComparator = FileCollection.getComparator(this.getFolderOrdering(), this.isReverseFolderOrdering());
            }
            FileCollection.sort2(files, fileComparator, directoryComparator);
        }
        for (int i3 = 0; i3 < files.length; ++i3) {
            files[i3] = ((FastFile)files[i3]).unWrap();
        }
        return files;
    }

    private static File[] sort2(File[] files, Comparator fileComparator, Comparator directoryComparator) {
        int i2;
        if (directoryComparator == null) {
            Arrays.sort(files, fileComparator);
            return files;
        }
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                int diff = 0;
                if (((File)o1).isDirectory()) {
                    --diff;
                }
                if (((File)o2).isDirectory()) {
                    ++diff;
                }
                return diff;
            }
        });
        for (i2 = 0; i2 < files.length && files[i2].isDirectory(); ++i2) {
        }
        Arrays.sort(files, 0, i2, directoryComparator);
        Arrays.sort(files, i2, files.length, fileComparator);
        return files;
    }

    private static Comparator getComparator(String key, boolean reverse) {
        if (key.equals("date") || key.equals("OrderByDate")) {
            return new FileDateComparator(reverse);
        }
        if (key.equals("name") || key.equals("OrderByName")) {
            return new FileNameComparator(reverse);
        }
        if (key.equals("cameraDate")) {
            return new CameraDateComparator(reverse);
        }
        return new SimpleFileNameComparator(reverse);
    }

    public boolean isExcluded(File f2) {
        return this.excluded.contains(f2);
    }
}

