/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.io.DualPrintStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumUtils;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.EasyJFrame;
import se.datadosen.jalbum.FileListMenuListener;
import se.datadosen.jalbum.JAboutWindow;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JConsoleFrame;
import se.datadosen.jalbum.JExternalToolsMenu;
import se.datadosen.jalbum.JFileListMenu;
import se.datadosen.jalbum.JFileMenuItem;
import se.datadosen.jalbum.JMainSettingsPanel;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.JPreferencesWindow;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.jalbum.JShareWindow;
import se.datadosen.jalbum.JSkinPreview;
import se.datadosen.jalbum.JToolBarButton;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.Stopwatch;

public class JAlbumFrame
extends EasyJFrame {
    public static final String PROJECT_EXTENSION = ".jap";
    public static final String PROJECT_FILE_NAME = "jalbum-settings.jap";
    static final File defaultProjectFile = new File(System.getProperty("user.home"), ".jalbum-defaults.jap");
    JConsoleFrame console = new JConsoleFrame(this);
    private Thread processThread = null;
    private Thread updateCheckerThread = null;
    Config cfg = Config.getConfig();
    private Properties cleanProjectSettings = null;
    JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
    public JAlbumFrameActions actions = new JAlbumFrameActions();
    public JAlbumFrameButtons frameToolbars = new JAlbumFrameButtons();
    public JMainSettingsPanel mainSettingsPanel = new JMainSettingsPanel(this);
    JAlbumExplorer albumExplorer = new JAlbumExplorer(this);
    JAlbumFrameMenus frameMenus = new JAlbumFrameMenus();
    JShareWindow shareWindow = new JShareWindow(this);
    public JPreferencesWindow preferencesWindow = new JPreferencesWindow(this);
    JSettingsWindow settingsWindow = new JSettingsWindow(this);
    JPublishWizard publishWizard;
    JSkinPreview skinPreview = new JSkinPreview();
    JProgressDialog progressDialog;
    JLabel statusBar = new JLabel();
    AlbumBean engine;
    private File editDirectory;
    StringBuffer errorBuffer = new StringBuffer();
    public DeferredChooser projectChooser = new DeferredChooser(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = JAlbumFrame.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser);
    private JFileChooser addFileChooser;
    private JAlbumAdapter _adapter;
    boolean exitOnClose = true;
    boolean loadHints = true;
    private ArrayList jalbumListeners = new ArrayList();
    public DummyCheckBox useLayoutHints;
    private Properties previousSettings;
    private Properties appliedHints;
    static /* synthetic */ Class class$javax$swing$JFileChooser;

    public JAlbumFrame(File projectFile) {
        this.useLayoutHints = new DummyCheckBox(this.preferencesWindow.useLayoutHints);
        this.previousSettings = null;
        this.appliedHints = null;
        this.enableEvents(64L);
        try {
            this.engine = new AlbumBean();
            this.init();
            if (projectFile == null && defaultProjectFile.exists()) {
                projectFile = defaultProjectFile;
            }
            if (defaultProjectFile != null && defaultProjectFile.exists()) {
                Properties props = IO.readPropertyFile(defaultProjectFile);
                PropertyBinder.syncUI(props, this.preferencesWindow);
            } else {
                BeanBinder.getProperties((Object)Config.getConfig(), this.preferencesWindow);
            }
            File myAlbums = new File(this.preferencesWindow.myAlbumsLocation.getText());
            if (myAlbums.exists()) {
                this.projectChooser.setCurrentDirectory(myAlbums);
            }
            this.newProject(projectFile);
            if (this.preferencesWindow.checkForUpdates.isSelected()) {
                this.checkForUpdates(true);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void pack() {
        this.settingsWindow.pack();
    }

    public void packThis() {
        super.pack();
        JAlbumFrame.optimizeFrameSize(this);
    }

    private static void optimizeFrameSize(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)frameSize.height < (double)screenSize.height / 1.6) {
            frameSize.height = (int)((double)screenSize.height / 1.6);
        }
        if (frameSize.height < 540) {
            frameSize.height = 540;
        }
        frameSize.width = 30 + frameSize.height * 5 / 4;
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        frame.setSize(frameSize);
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    void setTitle() {
        String title = Msg.getString("ui.windowTitle");
        File f2 = this.projectChooser.getSelectedFile();
        if (f2 != null) {
            f2 = new File(f2.getAbsolutePath());
            title = title + " [";
            File parent = f2.getParentFile();
            String projectFileName = "";
            if (!f2.getName().equals(PROJECT_FILE_NAME)) {
                projectFileName = File.separatorChar + f2.getName();
            }
            title = parent.getParentFile() == null ? title + parent.getName() + projectFileName + "]" : title + parent.getParentFile().getName() + File.separatorChar + parent.getName() + projectFileName + "]";
        }
        this.setTitle(title);
    }

    boolean askProjectSave(String title) {
        try {
            if (!this.preferencesWindow.showWarnings.isSelected()) {
                return true;
            }
            this.ui2Engine();
            Properties currentProjectSettings = this.getProjectSettings();
            if (this.cleanProjectSettings != null && !this.arePropertiesEqual(currentProjectSettings, this.cleanProjectSettings)) {
                int answer = JOptionPane.showConfirmDialog(this, Msg.getString("ui.saveChangesToProjectQuestion"), title, 1);
                switch (answer) {
                    case 0: {
                        return this.saveProject(false);
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return true;
    }

    private boolean arePropertiesEqual(Properties a2, Properties b2) {
        return a2.equals(b2);
    }

    boolean askStopSharing() {
        if (!this.shareWindow.shareBean.isRunning() || this.shareWindow.shareBean.getShares().size() == 0) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, Msg.getString("ui.activeSharesWarning"), Msg.getString("ui.exitMenu"), 2, 2);
        return answer == 0;
    }

    void setTexts() {
        this.setTitle(Msg.getString("ui.windowTitle"));
        this.frameMenus.setTexts();
        this.frameToolbars.setTexts();
        this.albumExplorer.setTexts();
        this.shareWindow.setTexts();
        this.preferencesWindow.setTexts();
        this.mainSettingsPanel.setTexts();
        this.settingsWindow.setTexts();
        this.preferencesWindow.setTitle(Msg.getString("ui.prefsPanel"));
        this.settingsWindow.setTitle(Msg.getString("ui.albumSettingsTitle"));
        this.console.setTitle(Msg.getString("ui.consoleMenu"));
        this.progressDialog.setTitle(Msg.getString("ui.generatingAlbumInfo"));
        this.statusBar.setText("");
    }

    private void renameTab(JTabbedPane tabs, JComponent comp, String newName) {
        int index = tabs.indexOfTab(comp.getName());
        if (index != -1) {
            tabs.setTitleAt(index, newName);
            comp.setName(newName);
        }
    }

    public synchronized void removeJAlbumListener(JAlbumListener listener) {
        if (this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.remove(listener);
            this.jalbumListeners = list;
        }
    }

    public synchronized void addJAlbumListener(JAlbumListener listener) {
        if (!this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.add(listener);
            this.jalbumListeners = list;
        }
    }

    protected void fireSkinUIDisplayed(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIDisplayed(e2);
        }
    }

    protected void fireSkinUIHidden(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIHidden(e2);
        }
    }

    protected void fireStyleChanged(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).styleChanged(e2);
        }
    }

    protected void fireSkinChanged(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinChanged(e2);
            it.remove();
        }
    }

    protected void fireAlbumCreationStarted(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationStarted(e2);
        }
    }

    protected void fireAlbumCreationFinished(JAlbumEvent e2) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationFinished(e2);
        }
    }

    private void init() throws Exception {
        this.initConsole();
        this.setGlassPane(this.skinPreview);
        if (!JAlbum.isMac()) {
            this.setIconImage(this.icons.windowIcon.getImage());
        }
        if (System.getProperty("java.version").compareTo("1.4") < 0) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Msg.getString("ui.javaVersionError"), "1.4"), "JAlbum", 0);
            System.exit(20);
        }
        this.progressDialog = new JProgressDialog(this, "", true);
        this.setTexts();
        this.setJMenuBar(this.frameMenus.mainMenuBar);
        this.projectChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(JAlbumFrame.PROJECT_EXTENSION);
            }

            public String getDescription() {
                return "JAlbum Project files (*.jap)";
            }
        });
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.albumExplorer, "Center");
        this.settingsWindow.populateWithDefaultTabs();
        contentPane.add((Component)this.createStatusPanel(), "South");
        if (this.shareWindow.shareBean.isAutoStart()) {
            Thread t2 = new Thread("Web server launcher thread"){

                public void run() {
                    JAlbumFrame.this.shareWindow.startAction.actionPerformed(null);
                }
            };
            t2.setDaemon(true);
            t2.start();
        }
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
        this.statusBar.setFont(new Font("SansSerif", 0, 11));
        panel.add((Component)this.statusBar, "West");
        return panel;
    }

    private void initConsole() {
        boolean debug = this.preferencesWindow.debugMode.isSelected();
        if (debug) {
            System.setOut(new DualPrintStream(System.out, this.console.getPrintStream()));
            System.setErr(new DualPrintStream(System.err, this.console.getPrintStream()));
        } else {
            System.setOut(this.console.getPrintStream());
            System.setErr(this.console.getPrintStream());
        }
        JAlbumFrame.log("JAlbum 7.2.1 system console.");
        JAlbumFrame.log("This section captures debug prints sent to System.out and System.err");
        JAlbumFrame.log("The top section evaluates BeanShell expressions (interpreted Java)");
        JAlbumFrame.log("Press " + KeyEvent.getKeyModifiersText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) + "+E to evaluate an expression. (Evaluates selected text if selection is active)");
        JAlbumFrame.log("You have access to the basic JAlbum implicit objects such as engine and window");
        JAlbumFrame.log("\nSample expressions:");
        JAlbumFrame.log("4*(3+2); // Basic calculations");
        JAlbumFrame.log("engine.getSkin(); // Use of implicit object");
        JAlbumFrame.log("for (int i=1; i<10; i++) System.out.println(i); // Iterations");
        JAlbumFrame.log("window.messageBox(\"You can interact with any Java object\");\n");
    }

    public void initProject(File inputDirectory) {
        this.settingsWindow.directory.setText(inputDirectory.getAbsolutePath());
        File projectFile = new File(inputDirectory, PROJECT_FILE_NAME);
        this.projectChooser.setSelectedFile(projectFile);
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        } else {
            this.ui2Engine();
        }
        this.setTitle();
        this.initView();
        this.fixUIdisabling();
    }

    private static void log(String s2) {
        System.out.println(s2);
    }

    void showAboutBox() {
        JAboutWindow dlg = new JAboutWindow(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void doExit(ActionEvent e2) {
        if (this.exitOnClose) {
            if (this.shareWindow.trayIcon != null) {
                this.setVisible(false);
                return;
            }
            if (!this.askProjectSave(Msg.getString("ui.exitMenu"))) {
                return;
            }
            if (!this.askStopSharing()) {
                return;
            }
            System.exit(0);
        }
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            if (this.shareWindow.trayIcon != null) {
                this.setVisible(false);
                return;
            }
            if (!this.askProjectSave(Msg.getString("ui.exitMenu")) || !this.askStopSharing()) {
                return;
            }
            System.exit(0);
        } else {
            super.processWindowEvent(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMakeAlbum() {
        int res;
        if (this.engine.isAppendImages() && (this.engine.getLastImageSize() != null && !this.settingsWindow.getImageSize().equals(this.engine.getLastImageSize()) || this.engine.getLastThumbSize() != null && !this.settingsWindow.getThumbsSize().equals(this.engine.getLastThumbSize()))) {
            String def = Msg.getString("ui.ignore");
            Object[] options = new String[]{def, Msg.getString("ui.rebuildAll"), Msg.getString("ui.useOldSizes"), Msg.getString("cancel")};
            int res2 = 0;
            if (this.preferencesWindow.showWarnings.isSelected()) {
                res2 = JOptionPane.showOptionDialog(this, MessageFormat.format(Msg.getString("ui.newSizeWarning"), this.settingsWindow.getImageSize(), this.settingsWindow.getThumbsSize(), this.engine.getLastImageSize(), this.engine.getLastThumbSize()), Msg.getString("ui.newSizeWarningLabel"), 0, 2, null, options, def);
            }
            if (res2 == -1 || res2 == 3) {
                return;
            }
            if (res2 == 1) {
                this.engine.setAppendImages(false);
            }
            if (res2 == 2) {
                this.settingsWindow.setThumbsSize(this.engine.getLastThumbSize());
                this.settingsWindow.setImageSize(this.engine.getLastImageSize());
            }
        }
        boolean warn = false;
        String imageDir = this.settingsWindow.getDirectory();
        String outputDir = this.settingsWindow.getOutputDirectory();
        if (this.settingsWindow.getSameDirectory()) {
            if (!imageDir.equals(this.engine.getDirectory())) {
                warn = true;
            }
        } else if (!outputDir.equals(this.engine.getOutputDirectory())) {
            warn = true;
        }
        if (!(imageDir.equals(outputDir) || this.settingsWindow.getLinkScaled() || this.settingsWindow.getCopyOriginals())) {
            res = 1;
            if (this.preferencesWindow.showWarnings.isSelected()) {
                res = this.messageBox(Msg.getString("ui.externalLinksWarning"), 19, Msg.getString("ui.makeAlbum"));
            }
            if (res != 1) {
                return;
            }
        }
        if (warn && (res = this.messageBox(MessageFormat.format(Msg.getString("ui.makeAlbumInfo"), outputDir), 3, Msg.getString("ui.makeAlbum"))) != 1) {
            return;
        }
        Object object = JAlbum.initializedOkMonitor;
        synchronized (object) {
            try {
                this.ui2Engine();
                if (Runtime.getRuntime().availableProcessors() > 1) {
                    this.engine.setNThreads((Integer)this.preferencesWindow.nThreads.getSelectedItem());
                }
                this.fireAlbumCreationStarted(new JAlbumEvent(this));
                if (this.processThread == null) {
                    this.processThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                JAlbumFrame.this.errorBuffer = new StringBuffer();
                                Stopwatch timer = new Stopwatch();
                                timer.start();
                                JAlbumFrame.this.engine.makeAlbum();
                                System.out.println("Elapsed time: " + timer);
                                if (JAlbumFrame.this.preferencesWindow.closeProgressDialog.isSelected()) {
                                    JAlbumFrame.this.progressDialog.setVisible(false);
                                } else {
                                    JAlbumFrame.this.progressDialog.setDialogToFinishedState();
                                }
                                JAlbumFrame.this.processThread = null;
                            }
                            catch (Throwable t2) {
                                JAlbumFrame.this.processThread = null;
                                try {
                                    throw t2;
                                }
                                catch (ParameterException ex) {
                                    JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                }
                                catch (UnsupportedEncodingException ex) {
                                    JAlbumFrame.this.messageBox(MessageFormat.format(Msg.getString("ui.unsupportedEncodingError"), JAlbumFrame.this.engine.getTextEncoding()), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.toString());
                                }
                                catch (IOException ex) {
                                    JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                }
                                catch (OperationAbortedException ex) {
                                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.operationAborted"));
                                }
                                catch (ElementException ex) {
                                    Debug.showCopyableError(JAlbumFrame.this, ex, Msg.getString("ui.scriptingError"));
                                }
                                catch (Throwable t22) {
                                    Debug.showStackTraceDialog(JAlbumFrame.this, t22);
                                }
                            }
                            finally {
                                JAlbumFrame.this.fireAlbumCreationFinished(new JAlbumEvent(this));
                                JAlbumFrame.this.engine2UI(true);
                            }
                            if (JAlbumFrame.this.errorBuffer.length() > 0) {
                                JScrollPane sp = new JScrollPane();
                                JSmartTextArea ta = new JSmartTextArea(JAlbumFrame.this.errorBuffer.toString());
                                ta.setEditable(false);
                                sp.getViewport().add((Component)ta, null);
                                JOptionPane.showMessageDialog(JAlbumFrame.this, sp, Msg.getString("ui.errorsDuringAlbumGeneration"), 2);
                            }
                        }
                    };
                    this.processThread.setPriority(1);
                    this.progressDialog.abort = false;
                    this.processThread.start();
                    this.progressDialog.updateStateAndSetVisible(true);
                } else {
                    this.processThread = null;
                }
            }
            catch (BeanBinderException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private static void enableComponents(JComponent comp, boolean enable) {
        comp.setEnabled(enable);
        Component[] components = comp.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            if (!(components[i2] instanceof JComponent)) continue;
            JAlbumFrame.enableComponents((JComponent)components[i2], enable);
        }
    }

    void setPreviewImage() {
        String skin = this.mainSettingsPanel.getSelectedSkin();
        String style = this.mainSettingsPanel.getSelectedStyle();
        if (skin == null || style == null) {
            return;
        }
        this.setPreviewImage(skin, style);
    }

    void setPreviewImage(String skin, String style) {
        File f2 = new File(this.cfg.skinsDir, skin + "/styles/" + IO.baseName(style) + ".jpg");
        if (!f2.exists()) {
            f2 = new File(this.cfg.skinsDir, skin + "/preview.jpg");
        }
        if (f2.exists()) {
            this.skinPreview.setImage(f2);
        } else {
            this.skinPreview.setText(Msg.getString("ui.noPreviewAvailable"));
        }
    }

    void executeScript(File f2) {
        if (f2.exists()) {
            try {
                this.engine.processBeanShellFile(f2);
            }
            catch (ElementException ex) {
                Debug.showCopyableError(this, ex, Msg.getString("ui.scriptingError"));
                ex.printStackTrace(System.out);
            }
            catch (OperationAbortedException ex) {
                this.statusBar.setText(Msg.getString("ui.operationAborted"));
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    public boolean isSkinUISelected() {
        return this.settingsWindow.isSkinUISelected();
    }

    public void setSkinUI(ControlPanel ui) {
        this.settingsWindow.setSkinUI(ui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newProject(File projectFile) {
        if (!this.askProjectSave(defaultProjectFile.equals(projectFile) ? Msg.getString("ui.newProjectMenu") : Msg.getString("ui.openProjectMenu"))) {
            return;
        }
        this.engine = new AlbumBean();
        this.engine.addAlbumBeanListener(this.progressDialog);
        this.engine.addAlbumBeanListener(new AlbumBeanListener(){

            public void imageProcessingStarted(AlbumBeanEvent e2) {
                JAlbumFrame.this.statusBar.setText(MessageFormat.format(Msg.getString("ui.albumGenerationProgress"), new Integer(e2.imageNum), new Integer(e2.imageSum), e2.directory));
                if (JAlbumFrame.this.processThread == null) {
                    e2.abortProcessing();
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.processingAborted"));
                }
            }

            public void imageProcessingFinished(AlbumBeanEvent e2) {
                JAlbumFrame.this.statusBar.setText(MessageFormat.format(Msg.getString("ui.albumGenerationProgress"), new Integer(e2.imageNum), new Integer(e2.imageSum), e2.directory) + Msg.getString("ui.albumGenerationDone"));
                if (JAlbumFrame.this.processThread == null) {
                    e2.abortProcessing();
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.processingAborted"));
                }
            }

            public void errorOccured(Throwable t2, File f2) {
                String msg;
                if (t2 instanceof RuntimeException && JAlbumFrame.this.preferencesWindow.debugMode.isSelected()) {
                    throw (RuntimeException)t2;
                }
                if (JAlbumFrame.this.errorBuffer.length() == 0) {
                    JAlbumFrame.this.errorBuffer.append(Msg.getString("ui.fileProcessingError") + "\n");
                }
                if ((msg = t2.getMessage()) == null || t2 instanceof RuntimeException) {
                    msg = t2.toString();
                }
                JAlbumFrame.this.errorBuffer.append(f2.getName() + ": " + msg + "\n");
            }
        });
        JAlbumFrame.fillCombo(this.mainSettingsPanel.style, new File(this.cfg.skinsDir, this.engine.getSkin() + "/styles"), new StyleFileFilter());
        this.projectChooser.setSelectedFile(null);
        this.setTitle();
        if (projectFile != null) {
            this.loadProject(projectFile);
        } else {
            try {
                this.loadHints = false;
                try {
                    this.engine2UI();
                }
                finally {
                    this.loadHints = true;
                }
                this.loadHints();
                this.ui2Engine();
                this.cleanProjectSettings = this.getProjectSettings();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.updateCheckerThread == null || !this.updateCheckerThread.isAlive()) {
            this.statusBar.setText(Msg.getString("ui.introInfo"));
        }
    }

    static void fillCombo(JComboBox combo, File dir2, FileFilter filter) {
        if (!dir2.isDirectory()) {
            return;
        }
        File[] files = dir2.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.toString(), o2.toString());
            }
        });
        for (int i2 = 0; i2 < files.length; ++i2) {
            combo.addItem(files[i2].getName());
        }
    }

    boolean saveProject(boolean alwaysSaveAs) {
        if (alwaysSaveAs || this.projectChooser.getSelectedFile() == null) {
            int returnVal = this.projectChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveProject(this.projectChooser.getSelectedFile());
                return true;
            }
            return false;
        }
        this.saveProject(this.projectChooser.getSelectedFile());
        return true;
    }

    public void scanImageDirectory() {
        File dir2 = new File(this.settingsWindow.getDirectory());
        if (!dir2.isDirectory()) {
            return;
        }
        File projectFile = new File(dir2, PROJECT_FILE_NAME);
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        }
    }

    private Set getChangedKeys(Properties before, Properties after) {
        HashSet<String> changedKeys = new HashSet<String>();
        if (before == null) {
            return changedKeys;
        }
        Iterator<Object> it = before.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (before.getProperty(key).equals(after.getProperty(key))) continue;
            changedKeys.add(key);
        }
        return changedKeys;
    }

    private Properties filterProperties(Properties allSettings, Set keysToKeep) {
        Properties filtered = new Properties();
        Iterator it = keysToKeep.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!allSettings.containsKey(key)) continue;
            filtered.put(key, allSettings.get(key));
        }
        return filtered;
    }

    void loadHints() {
        if (!this.preferencesWindow.useLayoutHints.isSelected()) {
            return;
        }
        try {
            File hintsFile;
            this.ui2Engine();
            if (this.preferencesWindow.restorePreviousSettings.isSelected() && this.previousSettings != null) {
                Set changedKeys = this.getChangedKeys(this.appliedHints, BeanBinder.getProperties(this.engine));
                Iterator it = changedKeys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.previousSettings.remove(key);
                }
                BeanBinder.setProperties((Object)this.engine, this.previousSettings);
            }
            if (!(hintsFile = new File(this.cfg.skinsDir, this.mainSettingsPanel.getSelectedSkin() + "/hints.jap")).exists()) {
                this.appliedHints = null;
                this.previousSettings = null;
                this.engine.setSkinVariables(new PrintSafeHashMap());
                this.engine2UI(true);
                return;
            }
            Properties hints = IO.readPropertyFile(hintsFile);
            Iterator it = this.engine.getUserVariables().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                if (!((String)e2.getKey()).startsWith("filter")) continue;
                it.remove();
            }
            if (this.preferencesWindow.restorePreviousSettings.isSelected()) {
                Properties allSettings = BeanBinder.getProperties((Object)this.engine, false);
                this.previousSettings = this.filterProperties(allSettings, hints.keySet());
            }
            BeanBinder.setProperties((Object)this.engine, hints);
            this.appliedHints = hints;
            Map userVariables = this.engine.getUserVariables();
            userVariables.putAll(AlbumUtils.getUserVariables(hints));
            this.engine.setUserVariables(userVariables);
            this.engine.setSkinVariables(AlbumUtils.getSkinVariables(hints));
            this.engine2UI(true);
        }
        catch (IOException ex) {
            this.engine2UI();
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(File projectFile) {
        try {
            if (!projectFile.equals(defaultProjectFile) && !this.askProjectSave(Msg.getString("ui.openProjectMenu"))) {
                return;
            }
            Properties props = IO.readPropertyFile(projectFile);
            BeanBinder.setProperties((Object)this.engine, props);
            this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
            this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
            if (projectFile.equals(defaultProjectFile)) {
                BeanBinder.setProperties((Object)Config.getConfig(), props);
                PropertyBinder.syncUI(props, this.preferencesWindow);
            } else {
                this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
                this.statusBar.setText(Msg.getString("ui.projectLoaded") + " " + projectFile.getAbsolutePath());
            }
            this.loadHints = false;
            this.engine2UI();
            this.ui2Engine();
            this.initView();
            try {
                this.cleanProjectSettings = this.getProjectSettings();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        catch (IOException ex) {
            this.engine2UI();
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
        finally {
            this.loadHints = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProject(File projectFile) {
        String fileName = projectFile.getName();
        if (!fileName.endsWith(PROJECT_EXTENSION)) {
            fileName = fileName + PROJECT_EXTENSION;
        }
        projectFile = new File(projectFile.getParentFile(), fileName);
        FileOutputStream fos = null;
        try {
            this.ui2Engine();
            this.cleanProjectSettings = this.getProjectSettings();
            Properties props = this.getProjectSettings(true);
            if (projectFile.equals(defaultProjectFile)) {
                BeanBinder.getProperties((Object)Config.getConfig(), props);
                PropertyBinder.getProperties(this.preferencesWindow, props);
                props.remove("directory");
            } else {
                this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                this.frameMenus.fileMenuSaveItem.setEnabled(true);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
            }
            fos = new FileOutputStream(projectFile);
            props.store(fos, "JAlbum Project");
            this.statusBar.setText(Msg.getString("ui.projectSaved") + " " + projectFile.getAbsolutePath());
            boolean bl2 = true;
            IO.close(fos);
            return bl2;
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            IO.close(fos);
        }
    }

    private Properties getProjectSettings() throws Exception {
        return this.getProjectSettings(false);
    }

    private Properties getProjectSettings(boolean full) throws Exception {
        Map.Entry<Object, Object> item;
        Properties props = BeanBinder.getProperties(this.engine);
        props.remove("userVariables");
        props.remove("skinVariables");
        Iterator<Map.Entry<Object, Object>> it = this.settingsWindow.userVariablesTable.getMap().entrySet().iterator();
        while (it.hasNext()) {
            item = it.next();
            props.setProperty("user." + item.getKey(), item.getValue().toString());
        }
        if (this.settingsWindow.skinUI != null && full) {
            it = PropertyBinder.getProperties(this.settingsWindow.skinUI).entrySet().iterator();
            while (it.hasNext()) {
                item = it.next();
                props.setProperty("skin." + item.getKey(), item.getValue().toString());
            }
        }
        return props;
    }

    void engine2UI() {
        this.engine2UI(false);
    }

    void engine2UI(boolean quick) {
        try {
            if (quick) {
                this.mainSettingsPanel.skin.removeActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            Object[] uis = new Object[]{this, this.settingsWindow, this.mainSettingsPanel};
            BeanBinder.getProperties((Object)this.engine, uis);
            if (quick) {
                this.mainSettingsPanel.skin.addActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            this.settingsWindow.userVariablesTable.clear();
            TreeMap vars = new TreeMap(this.engine.getUserVariables());
            this.settingsWindow.userVariablesTable.putAll(vars);
            this.settingsWindow.userVariablesTable.updateUI();
            if (this.settingsWindow.skinUI != null) {
                PropertyBinder.syncUI(vars, this.settingsWindow.skinUI);
                PropertyBinder.syncUI(this.engine.getSkinVariables(), this.settingsWindow.skinUI);
            }
            this.initView();
            this.fixUIdisabling();
            this.repaint();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void ui2Engine() throws BeanBinderException {
        Object[] uis = new Object[]{this, this.settingsWindow, this.mainSettingsPanel};
        BeanBinder.setProperties((Object)this.engine, uis);
        if (this.settingsWindow.skinUI != null) {
            this.engine.setSkinVariables(PropertyBinder.getProperties(this.settingsWindow.skinUI));
        }
        this.engine.setUserVariables(this.settingsWindow.userVariablesTable.getMap());
        BeanBinder.setProperties((Object)this.engine, this.preferencesWindow);
    }

    void fixUIdisabling() {
        this.frameMenus.fileMenuSaveItem.setEnabled(this.projectChooser.getSelectedFile() != null);
        JAlbumFrame.enableComponents(this.settingsWindow.outputDirectoryLabel, !this.settingsWindow.getSameDirectory());
        JAlbumFrame.enableComponents(this.settingsWindow.outputDirectory, !this.settingsWindow.getSameDirectory());
        JAlbumFrame.enableComponents(this.settingsWindow.copyOriginals, !this.settingsWindow.getSameDirectory());
        this.settingsWindow.imageSize.setEnabled(!this.settingsWindow.getLinkOriginals());
        this.settingsWindow.copyOriginals.setEnabled(!this.settingsWindow.getLinkScaled() && !this.settingsWindow.getSameDirectory());
        this.directorySelected();
    }

    void directorySelected() {
        if (this.settingsWindow.getDirectory().length() > 0 && (this.settingsWindow.getSameDirectory() || this.settingsWindow.getOutputDirectory().length() > 0)) {
            this.shareWindow.setShareCurrentEnabled(true);
            this.actions.makeAction.setEnabled(true);
            this.actions.makeAllAction.setEnabled(true);
            this.actions.makeChangesAction.setEnabled(true);
            this.actions.viewAlbumAction.setEnabled(true);
            this.actions.slideShowAction.setEnabled(true);
        } else {
            this.shareWindow.setShareCurrentEnabled(false);
            this.actions.makeAction.setEnabled(false);
            this.actions.makeAllAction.setEnabled(false);
            this.actions.makeChangesAction.setEnabled(false);
            this.actions.viewAlbumAction.setEnabled(false);
            this.actions.slideShowAction.setEnabled(false);
        }
    }

    public void initView() {
        File f2 = new File(this.settingsWindow.directory.getText());
        if (this.editDirectory == null || !this.editDirectory.equals(f2)) {
            this.editDirectory = f2;
            AlbumObjectFactory factory = new AlbumObjectFactory(this.engine);
            AlbumObject root = factory.createInstance(f2);
            this.albumExplorer.setRootFolder(root);
            this.albumExplorer.viewFolder(root);
        }
    }

    void checkForUpdates(final boolean onStartup) {
        this.updateCheckerThread = new Thread("UpdateChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.updateCheckInfo"));
                    String padVersion = JAlbumSite.getInstance().getClientVersion();
                    if (padVersion.compareTo("7.2.1") <= 0) {
                        if (!onStartup) {
                            String msg = Msg.getString("ui.versionIsCurrentInfo");
                            JOptionPane.showMessageDialog(JAlbumFrame.this, msg, Msg.getString("ui.checkForUpdates"), 1);
                        }
                        return;
                    }
                    String msg = MessageFormat.format(Msg.getString("ui.newUpdateAvailable"), padVersion);
                    int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, msg, Msg.getString("ui.checkForUpdatesTitle"), 0, 1);
                    if (answer == 0) {
                        BrowserLauncher.openURL("http://jalbum.net/history.jsp");
                    }
                }
                catch (Exception ex) {
                    if (!onStartup) {
                        JOptionPane.showMessageDialog(JAlbumFrame.this, ex.toString(), Msg.getString("ui.checkForUpdatesTitle"), 0);
                    }
                }
                finally {
                    JAlbumFrame.this.statusBar.setText(Msg.getString("ui.introInfo"));
                }
            }
        };
        this.updateCheckerThread.start();
    }

    public void show(Window win) {
        if (win.isShowing()) {
            win.toFront();
            return;
        }
        win.pack();
        Dimension windowPreferedSize = win.getPreferredSize();
        Dimension assignedSize = this.min(windowPreferedSize, Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle appBounds = this.getBounds();
        win.setSize(assignedSize);
        int xpos = (appBounds.width - assignedSize.width) / 2 + appBounds.x;
        int ypos = (appBounds.height - assignedSize.height) / 2 + appBounds.y;
        win.setLocation(xpos, ypos);
        win.setVisible(true);
    }

    private Dimension min(Dimension d1, Dimension d2) {
        int minWidth = d1.width < d2.width ? d1.width : d2.width;
        int minHeight = d1.height < d2.height ? d1.height : d2.height;
        return new Dimension(minWidth, minHeight);
    }

    public AlbumBean getEngine() {
        return this.engine;
    }

    public ControlPanel getSkinUI() {
        return this.settingsWindow.skinUI;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JAlbumFrameActions {
        Action parentFolderAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.albumExplorer.parentFolderAction.actionPerformed(e2);
            }
        };
        Action addAction = new AbstractAction(){
            {
                this.putValue("ShortDescription", Msg.getString("ui.addImagesTooltip"));
            }

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumFrame.this.addFileChooser == null) {
                    JAlbumFrame.this.addFileChooser = new JFileChooser();
                    JAlbumFrame.this.addFileChooser.setDialogTitle(Msg.getString("ui.addImagesTooltip"));
                    JAlbumFrame.this.addFileChooser.setDialogType(2);
                    JAlbumFrame.this.addFileChooser.setMultiSelectionEnabled(true);
                    JAlbumFrame.this.addFileChooser.setFileSelectionMode(2);
                    JAlbumFrame.this.addFileChooser.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e2) {
                            File[] selectedFiles;
                            if (e2.getActionCommand().equals("ApproveSelection") && (selectedFiles = JAlbumFrame.this.addFileChooser.getSelectedFiles()) != null && selectedFiles.length > 0) {
                                List<File> files = Arrays.asList(selectedFiles);
                                ((JAlbumFrameActions)(this).JAlbumFrameActions.this).JAlbumFrame.this.albumExplorer.explorer.handleFileAdd(files);
                            }
                        }
                    });
                }
                JAlbumFrame.this.addFileChooser.showDialog(JAlbumFrame.this, Msg.getString("add"));
            }
        };
        Action refreshAction = new AbstractAction(){
            {
                this.putValue("Name", Msg.getString("edit.update"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.albumExplorer.refreshAction.actionPerformed(e2);
            }
        };
        Action slideShowAction = new AbstractAction(){
            {
                this.putValue("Name", Msg.getString("edit.runSlideshow"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(122, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.albumExplorer.slideShowAction.actionPerformed(e2);
            }
        };
        Action makeAction = new AbstractAction(){
            {
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.engine.setAppendImages(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.mainSettingsPanel.isMakeChanges());
                JAlbumFrame.this.doMakeAlbum();
            }
        };
        Action makeChangesAction = new AbstractAction(){
            {
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.engine.setAppendImages(true);
                JAlbumFrame.this.doMakeAlbum();
            }
        };
        Action makeAllAction = new AbstractAction(){
            {
                JAlbumFrame.this.setIconImage(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.icons.enginesIcon.getImage());
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 1));
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.engine.setAppendImages(false);
                JAlbumFrame.this.doMakeAlbum();
            }
        };
        Action viewAlbumAction = new AbstractAction(){
            {
                JAlbumFrame.this.setIconImage(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.icons.viewIcon.getImage());
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                try {
                    File dir2 = new File(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.getSameDirectory() ? ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.getDirectory() : ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.getOutputDirectory());
                    if (!dir2.isAbsolute()) {
                        dir2 = new File(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.getDirectory(), ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.getOutputDirectory());
                    }
                    File indexFile = new File(dir2, ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.indexPageName.getText() + ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow.pageExtension.getText());
                    BrowserLauncher.openLocal(indexFile);
                }
                catch (IOException ex) {
                    System.err.println(e2);
                    ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.statusBar.setText(ex.getMessage());
                }
            }
        };
        public Action showAlbumSettingsWindow = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.show(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.settingsWindow);
            }
        };
        Action showShareWindowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.show(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.shareWindow);
            }
        };
        Action showPublishWindowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                if (((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.publishWizard != null && ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.publishWizard.isShowing()) {
                    ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.publishWizard.toFront();
                    return;
                }
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.publishWizard = new JPublishWizard(JAlbumFrame.this, ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.engine);
                JAlbumFrame.this.show(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.publishWizard);
            }
        };
        Action showPreferencesWindowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumFrame.this.show(((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.preferencesWindow);
            }
        };
        Action showConsoleWindowAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
            }

            public void actionPerformed(ActionEvent e2) {
                ((JAlbumFrameActions)JAlbumFrameActions.this).JAlbumFrame.this.console.setVisible(true);
            }
        };
    }

    public class JAlbumFrameButtons {
        private JToolBar mainToolbar;
        private JButton addButton;
        private JButton refreshButton;
        private JButton parentDirectoryButton;
        JButton makeAlbumButton;
        public JButton albumSettingsButton;
        private JButton viewAlbumToolButton;
        private JButton slideShowToolButton;
        private JButton shareToolButton;
        private JButton publishToolButton;

        JAlbumFrameButtons() {
            this.addButton = new JToolBarButton(JAlbumFrame.this.actions.addAction);
            this.refreshButton = new JToolBarButton(JAlbumFrame.this.actions.refreshAction);
            this.parentDirectoryButton = new JToolBarButton(JAlbumFrame.this.actions.parentFolderAction);
            this.makeAlbumButton = new JToolBarButton(JAlbumFrame.this.actions.makeAction);
            this.albumSettingsButton = new JToolBarButton(JAlbumFrame.this.actions.showAlbumSettingsWindow);
            this.viewAlbumToolButton = new JToolBarButton(JAlbumFrame.this.actions.viewAlbumAction);
            this.slideShowToolButton = new JToolBarButton(JAlbumFrame.this.actions.slideShowAction);
            this.shareToolButton = new JToolBarButton(JAlbumFrame.this.actions.showShareWindowAction);
            this.publishToolButton = new JToolBarButton(JAlbumFrame.this.actions.showPublishWindowAction);
            this.mainToolbar = new JToolBar("JAlbum");
            this.init();
        }

        public JComponent getMainToolbar() {
            return this.mainToolbar;
        }

        private void init() {
            Class<?> cl2 = this.getClass();
            ImageIcon addIcon = new ImageIcon(cl2.getResource("button_images/add2.png"));
            ImageIcon refreshIcon = new ImageIcon(cl2.getResource("button_images/refresh.png"));
            ImageIcon parentFolderIcon = new ImageIcon(cl2.getResource("button_images/folder_up.png"));
            ImageIcon slideShowIcon = new ImageIcon(cl2.getResource("button_images/presentation.png"));
            ImageIcon viewAlbumIcon = new ImageIcon(cl2.getResource("button_images/earth_view.png"));
            ImageIcon shareIcon = new ImageIcon(cl2.getResource("button_images/earth_connection.png"));
            ImageIcon publishIcon = new ImageIcon(cl2.getResource("button_images/publish.png"));
            ImageIcon albumSettingsIcon = new ImageIcon(cl2.getResource("button_images/gear_preferences.png"));
            this.addButton.setIcon(addIcon);
            this.refreshButton.setIcon(refreshIcon);
            this.parentDirectoryButton.setIcon(parentFolderIcon);
            this.albumSettingsButton.setIcon(albumSettingsIcon);
            this.slideShowToolButton.setIcon(slideShowIcon);
            this.viewAlbumToolButton.setIcon(viewAlbumIcon);
            this.shareToolButton.setIcon(shareIcon);
            this.publishToolButton.setIcon(publishIcon);
            this.makeAlbumButton.setIcon(JAlbumFrame.this.icons.engineIcon);
            this.makeAlbumButton.setHorizontalTextPosition(0);
            this.makeAlbumButton.setVerticalTextPosition(3);
            this.mainToolbar.setFloatable(false);
            this.mainToolbar.setBorderPainted(false);
            this.mainToolbar.add(this.addButton);
            this.mainToolbar.add(this.parentDirectoryButton);
            this.mainToolbar.add(this.refreshButton);
            this.mainToolbar.add(Box.createHorizontalGlue());
            this.mainToolbar.add(this.viewAlbumToolButton);
            this.mainToolbar.add(this.slideShowToolButton);
            this.mainToolbar.add(this.publishToolButton);
        }

        void setTexts() {
            this.addButton.setText("");
            this.parentDirectoryButton.setText("");
            this.refreshButton.setText("");
            this.albumSettingsButton.setText(Msg.getString("ui.settings"));
            this.viewAlbumToolButton.setText(Msg.getString("ui.viewAlbum"));
            this.viewAlbumToolButton.setToolTipText(Msg.getString("ui.viewAlbumToolTip"));
            this.slideShowToolButton.setText(Msg.getString("edit.runSlideshow"));
            this.slideShowToolButton.setToolTipText(Msg.getString("edit.runSlideshowToolTip"));
            this.shareToolButton.setText(Msg.getString("ui.sharePanel"));
            this.shareToolButton.setToolTipText(Msg.getString("ui.shareToolTip"));
            this.publishToolButton.setText(Msg.getString("ui.publishPanel"));
            this.publishToolButton.setToolTipText(Msg.getString("ui.publishToolTip"));
            this.makeAlbumButton.setText(Msg.getString("ui.makeAlbum"));
        }
    }

    class JAlbumFrameMenus {
        final JMenuBar mainMenuBar = new JMenuBar();
        final JMenu fileMenu = new JMenu();
        final JMenuItem fileMenuNewItem = new JMenuItem();
        final JMenuItem fileMenuOpenItem = new JMenuItem();
        final JFileListMenu fileMenuRecentFilesMenu = new JFileListMenu(new File(System.getProperty("user.home"), ".jalbum-recent-projects.properties"));
        final JMenuItem fileMenuCloseItem = new JMenuItem();
        final JMenuItem fileMenuSaveItem = new JMenuItem();
        final JMenuItem fileMenuSaveAsItem = new JMenuItem();
        final JMenuItem fileMenuSaveAsDefaultItem = new JMenuItem();
        final JMenuItem fileMenuExitItem = new JMenuItem();
        final JMenu editMenu = new JMenu();
        final JMenu viewMenu = new JMenu();
        final JMenuItem viewMenuLargeThumbnailsItem;
        final JMenuItem viewMenuHideExcludedItem;
        final JMenu viewMenuOrderBySubMenu;
        final JMenu viewMenuOrderFoldersBySubMenu;
        final JMenuItem viewMenuRefreshItem;
        final JMenu albumMenu;
        final JMenuItem albumMenuMakeAllItem;
        final JMenuItem albumMenuMakeChangesItem;
        final JMenuItem albumMenuViewAlbumItem;
        final JMenuItem albumMenuSettingsItem;
        final JMenu toolsMenu;
        final JMenuItem toolsMenuRunSlideshowItem;
        final JMenuItem toolsMenuShareMenuItem;
        final JMenuItem toolsMenuPublishMenuItem;
        final JMenu openDirectoriesMenu;
        final JMenuItem openSkinDirectoryMenuItem;
        final JMenuItem openImageDirectoryMenuItem;
        final JMenuItem openOutputDirectoryMenuItem;
        final JMenu toolsMenuExternalToolsSubMenu;
        final JMenuItem toolsMenuPreferencesMenuItem;
        final JMenu helpMenu;
        final JMenuItem helpMenuCheckForUpdates;
        final JMenuItem helpMenuTopicsItem;
        final JMenuItem helpMenuWebItem;
        final JMenuItem helpMenuSupportingItem;
        final JMenuItem helpMenuAboutItem;

        JAlbumFrameMenus() {
            this.viewMenuLargeThumbnailsItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.largeThumbnailsAction);
            this.viewMenuHideExcludedItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.hideExcludedAction);
            this.viewMenuOrderBySubMenu = new JMenu();
            this.viewMenuOrderFoldersBySubMenu = new JMenu();
            this.viewMenuRefreshItem = new JMenuItem(JAlbumFrame.this.actions.refreshAction);
            this.albumMenu = new JMenu();
            this.albumMenuMakeAllItem = new JMenuItem(JAlbumFrame.this.actions.makeAllAction);
            this.albumMenuMakeChangesItem = new JMenuItem(JAlbumFrame.this.actions.makeChangesAction);
            this.albumMenuViewAlbumItem = new JMenuItem(JAlbumFrame.this.actions.viewAlbumAction);
            this.albumMenuSettingsItem = new JMenuItem(JAlbumFrame.this.actions.showAlbumSettingsWindow);
            this.toolsMenu = new JMenu();
            this.toolsMenuRunSlideshowItem = new JMenuItem(JAlbumFrame.this.actions.slideShowAction);
            this.toolsMenuShareMenuItem = new JMenuItem(JAlbumFrame.this.actions.showShareWindowAction);
            this.toolsMenuPublishMenuItem = new JMenuItem(JAlbumFrame.this.actions.showPublishWindowAction);
            this.openDirectoriesMenu = new JMenu();
            this.openSkinDirectoryMenuItem = new JMenuItem();
            this.openImageDirectoryMenuItem = new JMenuItem();
            this.openOutputDirectoryMenuItem = new JMenuItem();
            this.toolsMenuExternalToolsSubMenu = new JExternalToolsMenu(JAlbumFrame.this);
            this.toolsMenuPreferencesMenuItem = new JMenuItem(JAlbumFrame.this.actions.showPreferencesWindowAction);
            this.helpMenu = new JMenu();
            this.helpMenuCheckForUpdates = new JMenuItem();
            this.helpMenuTopicsItem = new JMenuItem();
            this.helpMenuWebItem = new JMenuItem();
            this.helpMenuSupportingItem = new JMenuItem();
            this.helpMenuAboutItem = new JMenuItem();
            this.fileMenuExitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.doExit(e2);
                }
            });
            this.helpMenuTopicsItem.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
            this.helpMenuTopicsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        File localHelp = new File(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.cfg.progDir, "help/index.html");
                        if (localHelp.exists()) {
                            BrowserLauncher.openLocal(localHelp);
                        } else {
                            BrowserLauncher.openURL("http://jalbum.net/help");
                        }
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuWebItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        BrowserLauncher.openURL("http://jalbum.net");
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuSupportingItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        BrowserLauncher.openURL("http://jalbum.net/supporting.jsp");
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuAboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.showAboutBox();
                }
            });
            this.fileMenuNewItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuNewItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.newProject(defaultProjectFile.exists() ? defaultProjectFile : null);
                    JNewProjectDialog newProjectDialog = new JNewProjectDialog(JAlbumFrame.this);
                    JAlbumFrame.this.show(newProjectDialog);
                }
            });
            if (JAlbum.isMac()) {
                this.fileMenuCloseItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            }
            this.fileMenuCloseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.newProject(defaultProjectFile.exists() ? defaultProjectFile : null);
                }
            });
            this.fileMenuOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuOpenItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    int returnVal = ((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.showOpenDialog(JAlbumFrame.this);
                    if (returnVal == 0) {
                        JAlbumFrame.this.loadProject(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuSaveItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    if (((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.getSelectedFile() != null) {
                        JAlbumFrame.this.saveProject(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveAsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    int returnVal = ((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.showSaveDialog(JAlbumFrame.this);
                    if (returnVal == 0) {
                        JAlbumFrame.this.saveProject(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveAsDefaultItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.saveProject(defaultProjectFile);
                }
            });
            this.openSkinDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openSkinDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        BrowserLauncher.openLocal(new File(Config.getConfig().skinsDir, ((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.engine.getSkin()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.openImageDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openImageDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        JAlbumFrame.this.ui2Engine();
                        BrowserLauncher.openLocal(new File(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.engine.getDirectory()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.openOutputDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openOutputDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    try {
                        JAlbumFrame.this.ui2Engine();
                        BrowserLauncher.openLocal(((JAlbumFrameMenus)JAlbumFrameMenus.this).JAlbumFrame.this.engine.getInterpretedOutputDirectory());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.fileMenuRecentFilesMenu.addFileListMenuListener(new FileListMenuListener(){

                public void fileSelected(ActionEvent e2) {
                    JFileMenuItem item = (JFileMenuItem)e2.getSource();
                    JAlbumFrame.this.loadProject(item.getFullPath());
                }
            });
            this.helpMenuCheckForUpdates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JAlbumFrame.this.checkForUpdates(false);
                }
            });
            this.buildMenu();
        }

        private void buildMenu() {
            this.fileMenu.add(this.fileMenuNewItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuOpenItem);
            this.fileMenu.add(this.fileMenuRecentFilesMenu);
            this.fileMenu.add(this.fileMenuCloseItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuSaveItem);
            this.fileMenu.add(this.fileMenuSaveAsItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuSaveAsDefaultItem);
            if (!JAlbum.isMac()) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.fileMenuExitItem);
            }
            this.editMenu.add(JAlbumFrame.this.albumExplorer.pasteAction);
            this.editMenu.addSeparator();
            this.editMenu.add(JAlbumFrame.this.albumExplorer.selectAllAction);
            this.editMenu.add(JAlbumFrame.this.albumExplorer.invertSelectionAction);
            this.viewMenuLargeThumbnailsItem.setModel(JAlbumFrame.this.albumExplorer.largeThumbnailsMenuItem.getModel());
            this.viewMenu.add(this.viewMenuLargeThumbnailsItem);
            this.viewMenuHideExcludedItem.setModel(JAlbumFrame.this.albumExplorer.hideExcludedMenuItem.getModel());
            this.viewMenu.add(this.viewMenuHideExcludedItem);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.viewMenuOrderBySubMenu);
            JAlbumFrame.this.albumExplorer.populateOrderingSubMenu(this.viewMenuOrderBySubMenu);
            this.viewMenu.add(this.viewMenuOrderFoldersBySubMenu);
            JAlbumFrame.this.albumExplorer.populateFolderOrderingSubMenu(this.viewMenuOrderFoldersBySubMenu);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.viewMenuRefreshItem);
            this.albumMenu.add(this.albumMenuMakeAllItem);
            this.albumMenu.add(this.albumMenuMakeChangesItem);
            this.albumMenu.add(this.albumMenuViewAlbumItem);
            this.albumMenu.addSeparator();
            this.albumMenu.add(this.albumMenuSettingsItem);
            this.toolsMenu.add(this.toolsMenuRunSlideshowItem);
            this.toolsMenu.add(this.toolsMenuShareMenuItem);
            this.toolsMenu.add(this.toolsMenuPublishMenuItem);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.openDirectoriesMenu);
            this.openDirectoriesMenu.add(this.openImageDirectoryMenuItem);
            this.openDirectoriesMenu.add(this.openOutputDirectoryMenuItem);
            this.openDirectoriesMenu.add(this.openSkinDirectoryMenuItem);
            this.toolsMenu.add(this.toolsMenuExternalToolsSubMenu);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(JAlbumFrame.this.actions.showConsoleWindowAction);
            if (!JAlbum.isMac()) {
                this.toolsMenu.addSeparator();
                this.toolsMenu.add(this.toolsMenuPreferencesMenuItem);
            }
            this.helpMenu.add(this.helpMenuTopicsItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.helpMenuCheckForUpdates);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.helpMenuWebItem);
            this.helpMenu.add(this.helpMenuSupportingItem);
            if (!JAlbum.isMac()) {
                this.helpMenu.addSeparator();
                this.helpMenu.add(this.helpMenuAboutItem);
            }
            this.mainMenuBar.add(this.fileMenu);
            this.mainMenuBar.add(this.editMenu);
            this.mainMenuBar.add(this.viewMenu);
            this.mainMenuBar.add(this.albumMenu);
            this.mainMenuBar.add(this.toolsMenu);
            this.mainMenuBar.add(this.helpMenu);
        }

        void setTexts() {
            this.fileMenu.setText(Msg.getString("ui.fileMenu"));
            this.fileMenuOpenItem.setText(Msg.getString("ui.openProjectMenu"));
            this.fileMenuNewItem.setText(Msg.getString("ui.newProjectMenu") + "...");
            this.fileMenuCloseItem.setText(Msg.getString("ui.closeProjectMenu"));
            this.fileMenuSaveItem.setText(Msg.getString("ui.saveProjectMenu"));
            this.fileMenuSaveAsItem.setText(Msg.getString("ui.saveProjectAsMenu"));
            this.fileMenuSaveAsDefaultItem.setText(Msg.getString("ui.saveAsDefaultMenu"));
            this.fileMenuRecentFilesMenu.setText(Msg.getString("ui.recentProjectsMenu"));
            this.fileMenuExitItem.setText(Msg.getString("ui.exitMenu"));
            this.helpMenu.setText(Msg.getString("ui.helpMenu"));
            this.helpMenuTopicsItem.setText(Msg.getString("ui.helpTopicsMenu"));
            this.helpMenuWebItem.setText(Msg.getString("ui.jalbumOnTheWebMenu"));
            this.helpMenuSupportingItem.setText(Msg.getString("ui.supportingJAlbumMenu"));
            this.helpMenuAboutItem.setText(Msg.getString("ui.aboutMenu"));
            this.helpMenuCheckForUpdates.setText(Msg.getString("ui.checkForUpdatesMenu"));
            this.toolsMenu.setText(Msg.getString("ui.toolsMenu"));
            this.toolsMenuShareMenuItem.setText(Msg.getString("ui.sharePanel") + "...");
            this.toolsMenuPublishMenuItem.setText(Msg.getString("ui.publishPanel") + "...");
            this.openDirectoriesMenu.setText(Msg.getString("ui.openDirectoriesMenu"));
            this.openSkinDirectoryMenuItem.setText(Msg.getString("ui.skinDirectoryMenu"));
            this.openImageDirectoryMenuItem.setText(Msg.getString("ui.imageDirectoryLabel"));
            this.openOutputDirectoryMenuItem.setText(Msg.getString("ui.outputDirectory"));
            this.toolsMenuExternalToolsSubMenu.setText(Msg.getString("ui.externalToolsMenu"));
            JAlbumFrame.this.actions.showConsoleWindowAction.putValue("Name", Msg.getString("ui.consoleMenu"));
            this.toolsMenuPreferencesMenuItem.setText(Msg.getString("ui.prefsPanel") + "...");
            this.albumMenu.setText(Msg.getString("ui.albumMenu"));
            JAlbumFrame.this.actions.makeChangesAction.putValue("Name", Msg.getString("ui.makeChanges"));
            JAlbumFrame.this.actions.makeChangesAction.putValue("ShortDescription", Msg.getString("ui.makeAlbumToolTip"));
            JAlbumFrame.this.actions.makeAllAction.putValue("Name", Msg.getString("ui.makeAll"));
            JAlbumFrame.this.actions.makeAllAction.putValue("ShortDescription", Msg.getString("ui.rebuildAllToolTip"));
            this.albumMenuViewAlbumItem.setText(Msg.getString("ui.viewAlbum"));
            this.albumMenuSettingsItem.setText(Msg.getString("ui.settings") + "...");
            this.editMenu.setText(Msg.getString("ui.edit"));
            this.viewMenu.setText(Msg.getString("ui.view"));
            this.viewMenuOrderBySubMenu.setText(Msg.getString("edit.orderBy"));
            this.viewMenuOrderFoldersBySubMenu.setText(Msg.getString("edit.orderFoldersBy"));
        }
    }

    public class CheckBoxProxy {
        private JCheckBox cb;

        public CheckBoxProxy(JCheckBox cb2) {
            this.cb = cb2;
        }

        public boolean isSelected() {
            return this.cb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.cb.setSelected(selected);
        }
    }

    public class DummyCheckBox {
        JCheckBox cb;

        public DummyCheckBox(JCheckBox cb2) {
            this.cb = cb2;
        }

        public boolean isSelected() {
            return this.cb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.cb.setSelected(selected);
        }
    }
}

